/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.jseclipse.library.Library;
import com.interaktonline.jseclipse.library.LibraryExtractor;
import com.interaktonline.jseclipse.library.LibraryItem;
import com.interaktonline.jseclipse.library.LibraryManager;
import com.interaktonline.jseclipse.library.LibraryProject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;

public class HtmlLibraryExtractor
extends LibraryExtractor {
    private Pattern srcPatern = Pattern.compile("<script\\s.*?src=\"(.*?)\".*?>");
    private Pattern idPatern = Pattern.compile("<(\\w*)[^>]*?\\sid=\"(.*?)\"");

    public void parse(IFile file, LibraryManager manager, LibraryProject project) {
        Library.LibraryFile libfile;
        String theFilePath = file.getLocation().toString();
        Long creation = project.getLibCreation(theFilePath);
        if (creation != null && creation >= file.getModificationStamp()) {
            return;
        }
        Long noParse = project.getNoParse(theFilePath);
        if (noParse != null && noParse.longValue() == file.getModificationStamp()) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        String text = FileTools.getFileText(file);
        if (text == null) {
            return;
        }
        Matcher m = this.srcPatern.matcher(text);
        ArrayList srcs = new ArrayList();
        while (m.find()) {
            srcs.add(m.group(1));
        }
        if (srcs.size() == 0) {
            project.setNoParse(theFilePath, file.getModificationStamp());
            return;
        }
        Library oldLibrary = project.getLibrary((String)(srcs = this.processSrcs(srcs)).get(0));
        if (oldLibrary != null && (libfile = oldLibrary.getLibraryFile(theFilePath)) != null && file.getModificationStamp() == libfile.getCreationDate()) {
            return;
        }
        Matcher m1 = this.idPatern.matcher(text);
        ArrayList<tag> tags = new ArrayList<tag>();
        while (m1.find()) {
            tag t = new tag();
            t.id = m1.group(2);
            t.name = m1.group(1);
            t.position = m1.start(2);
            tags.add(t);
        }
        Iterator it = srcs.iterator();
        while (it.hasNext()) {
            Library.LibraryFile theFile;
            String src = (String)it.next();
            Library lib = project.getLibrary(src);
            if (lib != null) {
                theFile = lib.getLibraryFile(theFilePath);
                if (theFile != null) {
                    Iterator init = theFile.getItems().iterator();
                    while (init.hasNext()) {
                        LibraryItem item = (LibraryItem)init.next();
                        lib.removeItem(item);
                    }
                    theFile.getItems().clear();
                } else {
                    Library library = lib;
                    library.getClass();
                    theFile = new Library.LibraryFile(library, theFilePath);
                    lib.addLibraryFile(theFile);
                }
                theFile.setCreationDate(file.getModificationStamp());
                this.createItems(tags, lib, theFile);
            } else {
                lib = new Library();
                lib.setExtendsLibString("");
                lib.setPrefix(src);
                Library library = lib;
                library.getClass();
                theFile = new Library.LibraryFile(library, theFilePath);
                lib.addLibraryFile(theFile);
                theFile.setCreationDate(file.getModificationStamp());
                this.createItems(tags, lib, theFile);
                project.setLibrary(lib);
            }
            lib.setSave(true);
        }
    }

    private void createItems(ArrayList tags, Library lib, Library.LibraryFile theFile) {
        Iterator it = tags.iterator();
        while (it.hasNext()) {
            tag t = (tag)it.next();
            LibraryItem li = new LibraryItem(lib);
            theFile.addItem(li);
            li.setLocation(t.position);
            li.setDisplay(String.valueOf(t.id) + " [" + t.name + "]");
            li.setReplacement(t.id);
        }
    }

    private ArrayList processSrcs(ArrayList arr) {
        ArrayList<String> arrnew = new ArrayList<String>();
        Iterator it = arr.iterator();
        while (it.hasNext()) {
            String src = (String)it.next();
            int ix = src.lastIndexOf(47);
            if (ix != -1) {
                arrnew.add(src.substring(ix + 1));
                continue;
            }
            arrnew.add(src);
        }
        return arrnew;
    }

    class tag {
        public String name;
        public String id;
        public int position;

        tag() {
        }
    }
}

