/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.library.HtmlLibraryExtractor;
import com.interaktonline.jseclipse.library.LibraryExtractor;
import com.interaktonline.jseclipse.library.LibraryManager;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class HtmlLibraryManager
extends LibraryManager {
    private static HtmlLibraryManager instance = new HtmlLibraryManager();

    public static HtmlLibraryManager getInstance() {
        return instance;
    }

    private HtmlLibraryManager() {
        this.pathSuffix = "htmllibrary/";
        this.fileFilter = new HtmlFilenameFilter(JavaScriptEditorPlugin.getDefault().getPreferenceStore());
        this.parseDynamicLibrary();
    }

    public void parseStaticLibrary() {
    }

    public LibraryExtractor getLibraryExtractor() {
        return new HtmlLibraryExtractor();
    }

    public String toString() {
        return "-- HtmlLibraryManager --";
    }

    static class HtmlFilenameFilter
    implements FilenameFilter,
    IPropertyChangeListener {
        private IPreferenceStore store;
        private String[] scanedExt;

        public HtmlFilenameFilter(IPreferenceStore store) {
            this.store = store;
            this.store.addPropertyChangeListener((IPropertyChangeListener)this);
            String exts = store.getString("scannedExtensions");
            this.scanedExt = exts.split(",");
            Arrays.sort(this.scanedExt);
        }

        public boolean accept(File dir, String name) {
            int ix = name.lastIndexOf(46);
            if (ix == -1) {
                return false;
            }
            String ext = name.substring(ix + 1);
            return Arrays.binarySearch(this.scanedExt, ext) >= 0;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("scannedExtensions")) {
                String exts = this.store.getString("scannedExtensions");
                this.scanedExt = exts.split(",");
                Arrays.sort(this.scanedExt);
                HtmlLibraryManager htmmanager = HtmlLibraryManager.getInstance();
                htmmanager.clear();
                ((LibraryManager)htmmanager).parseStaticLibrary();
                htmmanager.parseDynamicLibrary();
            }
        }
    }
}

