/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.jseclipse.library.Library;
import com.interaktonline.jseclipse.library.LibraryExtractor;
import com.interaktonline.jseclipse.library.LibraryItem;
import com.interaktonline.jseclipse.library.LibraryManager;
import com.interaktonline.jseclipse.library.LibraryProject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;

public class JsLibraryExtractor
extends LibraryExtractor {
    private Pattern classDefinitions = Pattern.compile("(\\w*)\\.prototype\\.(\\w*)\\s*=.*?[;{)]");
    private Pattern methodNamePatern = Pattern.compile(".*?=\\s*(.*?);");
    private Pattern inlineFunction = Pattern.compile("function\\s+\\w+\\s*(\\([^)]*\\))");
    private Pattern inlineBackFunction = Pattern.compile("\\s*\\w+\\s*=\\s*function\\s*(\\([^)]*\\))");
    private int chrno;
    private Map classes;

    public void parse(IFile file, LibraryManager manager, LibraryProject project) {
        Library.LibraryFile libfile;
        this.classes = new HashMap();
        String theFilePath = file.getLocation().toString();
        Long creation = project.getLibCreation(theFilePath);
        if (creation != null && creation >= file.getLocalTimeStamp()) {
            return;
        }
        Long noParse = project.getNoParse(theFilePath);
        if (noParse != null && noParse.longValue() == file.getLocalTimeStamp()) {
            return;
        }
        String text = FileTools.getFileText(file);
        if (text == null) {
            return;
        }
        Matcher m = this.classDefinitions.matcher(text);
        String aClass = null;
        while (m.find()) {
            aClass = m.group(1);
            classObj co = this.getClassObj(aClass);
            co.addEntry(m);
        }
        if (aClass == null) {
            project.setNoParse(theFilePath, file.getLocalTimeStamp());
            return;
        }
        Library oldLibrary = project.getLibrary(aClass);
        if (oldLibrary != null && (libfile = oldLibrary.getLibraryFile(theFilePath)) != null && file.getModificationStamp() == libfile.getCreationDate()) {
            return;
        }
        ArrayList tags = null;
        Iterator it = this.classes.keySet().iterator();
        while (it.hasNext()) {
            Library.LibraryFile theFile;
            String className = it.next().toString();
            tags = this.getCompletionItems(text, className);
            Library lib = project.getLibrary(className);
            if (lib != null) {
                theFile = lib.getLibraryFile(theFilePath);
                if (theFile != null) {
                    Iterator init = theFile.getItems().iterator();
                    while (init.hasNext()) {
                        LibraryItem item = (LibraryItem)init.next();
                        lib.removeItem(item);
                    }
                    theFile.getItems().clear();
                } else {
                    Library library = lib;
                    library.getClass();
                    theFile = new Library.LibraryFile(library, theFilePath);
                    lib.addLibraryFile(theFile);
                }
                theFile.setCreationDate(file.getLocalTimeStamp());
                this.createItems(tags, lib, theFile);
            } else {
                lib = new Library();
                lib.setExtendsLibString("");
                lib.setPrefix(className);
                Library library = lib;
                library.getClass();
                theFile = new Library.LibraryFile(library, theFilePath);
                lib.addLibraryFile(theFile);
                theFile.setCreationDate(file.getLocalTimeStamp());
                this.createItems(tags, lib, theFile);
                project.setLibrary(lib);
            }
            this.setParentClass(lib, text);
            this.saveLibrary(String.valueOf(manager.getLibraryPath()) + project.getName() + "/", lib);
        }
    }

    private void createItems(ArrayList tags, Library lib, Library.LibraryFile theFile) {
        Iterator it = tags.iterator();
        while (it.hasNext()) {
            LibraryItem li = (LibraryItem)it.next();
            li.setParent(lib);
            lib.setItem(li);
            theFile.addItem(li);
        }
    }

    private ArrayList getCompletionItems(String text, String className) {
        classObj co = (classObj)this.classes.get(className);
        ArrayList<LibraryItem> tags = new ArrayList<LibraryItem>();
        Pattern staticDefinitions = Pattern.compile("(" + className + ")\\.(\\w+)\\s*=.*?[;{)]");
        Matcher m1 = staticDefinitions.matcher(text);
        while (m1.find()) {
            if (m1.group(2).equals("prototype")) continue;
            LibraryItem li = new LibraryItem();
            String params = this.getDisplayString(text, m1.group(2), m1.group());
            li.setReplacement(String.valueOf(m1.group(2)) + (params.equals("") ? "" : "()"));
            li.setDisplay(String.valueOf(m1.group(2)) + params);
            if (this.chrno != 0) {
                li.setLocation(this.chrno);
            } else {
                li.setLocation(m1.start(1));
            }
            tags.add(li);
        }
        Iterator it = co.entries.iterator();
        while (it.hasNext()) {
            classEntry ce = (classEntry)it.next();
            LibraryItem li = new LibraryItem();
            String params = this.getDisplayString(text, ce.name, ce.row);
            li.setReplacement(String.valueOf(ce.name) + (params.equals("") ? "" : "()"));
            li.setDisplay(String.valueOf(ce.name) + params);
            if (this.chrno != 0) {
                li.setLocation(this.chrno);
            } else {
                li.setLocation(ce.position);
            }
            tags.add(li);
        }
        return tags;
    }

    private String getDisplayString(String text, String methodName, String methodRow) {
        String smn = "";
        this.chrno = 0;
        if (methodRow.endsWith(";")) {
            Matcher m = this.methodNamePatern.matcher(methodRow);
            if (!m.find()) {
                return "";
            }
            smn = m.group(1);
            Pattern function = null;
            try {
                function = Pattern.compile("function\\s+" + smn + "\\s*(\\([^)]*\\))");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return "";
            }
            m = function.matcher(text);
            if (m.find()) {
                this.chrno = m.start(1);
                return m.group(1);
            }
            Pattern backfunction = Pattern.compile("\\s*" + smn + "\\s*=\\s*function\\s*(\\([^)]*\\))");
            m = backfunction.matcher(text);
            if (m.find()) {
                this.chrno = m.start(1);
                return m.group(1);
            }
            return "";
        }
        this.chrno = 0;
        Pattern function = this.inlineFunction;
        Matcher m = function.matcher(methodRow);
        if (m.find()) {
            return m.group(1);
        }
        Pattern backfunction = this.inlineBackFunction;
        m = backfunction.matcher(methodRow);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private void setParentClass(Library lib, String text) {
        String prefix = lib.getPrefix();
        Pattern extendsDefinition = Pattern.compile(String.valueOf(prefix) + "\\.prototype\\.__proto__\\s*=\\s*(\\w+)\\.prototype");
        Matcher m = extendsDefinition.matcher(text);
        if (m.find()) {
            lib.setExtendsLibString(m.group(1));
            return;
        }
        extendsDefinition = Pattern.compile(String.valueOf(prefix) + "\\.prototype\\s*=\\s*new\\s+(\\w+)");
        m = extendsDefinition.matcher(text);
        if (m.find()) {
            lib.setExtendsLibString(m.group(1));
            return;
        }
        lib.setExtendsLibString("Object");
    }

    private void saveLibrary(String libPath, Library lib) {
        File folder = new File(libPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File f = null;
        try {
            f = File.createTempFile("jsl", ".xml", folder);
        }
        catch (IOException iOException) {}
        if (f == null) {
            FileTools.saveToFile(libPath, String.valueOf(lib.getPrefix()) + ".xml", lib.export());
        } else {
            FileTools.saveToFile(f, lib.export());
        }
    }

    private classObj getClassObj(String name) {
        classObj co = (classObj)this.classes.get(name);
        if (co == null) {
            co = new classObj();
            co.name = name;
            this.classes.put(name, co);
        }
        return co;
    }

    public void parse(File file, LibraryManager manager, LibraryProject project) {
    }

    class classObj {
        public String name;
        public ArrayList entries = new ArrayList();

        classObj() {
        }

        public void addEntry(Matcher m) {
            classEntry ce = new classEntry();
            ce.name = m.group(2);
            if (ce.name.equals("__proto__")) {
                return;
            }
            ce.row = m.group();
            ce.position = m.start(1);
            this.entries.add(ce);
        }
    }

    class classEntry {
        public String name;
        public String row;
        public int position;

        classEntry() {
        }
    }
}

