/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.library.LibraryExtractor;
import com.interaktonline.jseclipse.library.LibraryManager;
import com.interaktonline.jseclipse.library.LibraryParser;
import com.interaktonline.jseclipse.library.RhinoLibraryExtractor;
import com.interaktonline.jseclipse.library.StaticLibrarys;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;

public class JsLibraryManager
extends LibraryManager {
    protected URL xmlBaseURL;
    private static JsLibraryManager instance = new JsLibraryManager();

    public static JsLibraryManager getInstance() {
        return instance;
    }

    private JsLibraryManager() {
        this.pathSuffix = "library/";
        try {
            this.xmlBaseURL = new URL(JavaScriptEditorPlugin.getDefault().getBundle().getEntry("/"), this.pathSuffix);
        }
        catch (MalformedURLException e) {
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileFilter = new JsFilenameFilter();
        this.parseStaticLibrary();
        this.parseUserLibrary();
        this.parseDynamicLibrary();
    }

    public void parseStaticLibrary() {
        LibraryParser parser = new LibraryParser(this);
        parser.setLibraryRoot(this.xmlBaseURL, StaticLibrarys.XML);
        parser.start();
    }

    public void parseUserLibrary() {
        LibraryParser parser = new LibraryParser(this);
        parser.setLibraryRoot(this.getUserLibraryPath());
        parser.setKeepVersion(false);
        parser.setUsers(true);
        parser.start();
    }

    private String getUserLibraryPath() {
        IPath loc = JavaScriptEditorPlugin.getDefault().getStateLocation();
        return String.valueOf(loc.toString()) + "/user_library/";
    }

    protected URL createXmlFileURL(String name) throws MalformedURLException {
        if (this.xmlBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(this.xmlBaseURL, name);
    }

    public LibraryExtractor getLibraryExtractor() {
        return new RhinoLibraryExtractor();
    }

    public String toString() {
        return "-- JsLibraryManager --";
    }

    static class JsFilenameFilter
    implements FilenameFilter {
        JsFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".js");
        }
    }
}

