/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.jseclipse.library.LibraryItem;
import com.interaktonline.jseclipse.library.LibraryManager;
import com.interaktonline.jseclipse.library.LibraryNode;
import com.interaktonline.jseclipse.util.JsPluginImages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.graphics.Image;

public class Library
extends LibraryNode {
    private Library extendsLib = null;
    private HashMap libraries = null;
    private ArrayList prefixes = null;
    private String extendsLibString = "Object";
    private ArrayList items = new ArrayList();
    private ArrayList files = new ArrayList();
    private boolean save = false;

    public Library() {
        this.libraries = new HashMap();
        this.prefixes = new ArrayList();
    }

    public Image getImage() {
        return JsPluginImages.get("namespace.gif");
    }

    public Library getLibrary(String[] path, int index, int pathEnd) {
        if (index >= path.length) {
            return null;
        }
        Library lib = (Library)this.libraries.get(path[index]);
        if (lib == null) {
            return null;
        }
        if (index >= pathEnd) {
            return lib;
        }
        return lib.getLibrary(path, index + 1, pathEnd);
    }

    public Library getOrCreateLibrary(String[] path, int index) {
        if (path == null || path.length == 0) {
            return this;
        }
        Library lib = (Library)this.libraries.get(path[index]);
        if (lib == null) {
            lib = new Library();
            lib.setPrefix(path[index]);
            this.setLibrary(lib);
        }
        if (index == path.length - 1) {
            return lib;
        }
        return lib.getOrCreateLibrary(path, index + 1);
    }

    public Library[] getLibraries() {
        Library[] libs = new Library[this.libraries.size()];
        int i = 0;
        Iterator it = this.libraries.values().iterator();
        while (it.hasNext()) {
            libs[i++] = (Library)it.next();
        }
        return libs;
    }

    public ArrayList get(Library staticProject, String[] lprefix, boolean ignoreCase) {
        String rest = lprefix[lprefix.length - 1];
        Library lib = this.getLibrary(lprefix, 0, lprefix.length - 2);
        Library staticlib = null;
        if (staticProject != null) {
            staticlib = staticProject.getLibrary(lprefix, 0, lprefix.length - 2);
        }
        if (lib != null) {
            ArrayList staticList;
            ArrayList lItems = lib.getAllItems(rest, ignoreCase);
            lItems.addAll(lib.getAllLibraries(rest, ignoreCase));
            if (staticlib != null && (staticList = staticlib.getAllItems(rest, ignoreCase)) != null) {
                lItems.addAll(staticList);
            }
            if (lib.getPrefix().equals("Object")) {
                return lItems;
            }
            String ext = lib.getExtendesLibString();
            String[] extPath = ext.split("\\.");
            String[] allExtPath = new String[extPath.length + 1];
            System.arraycopy(extPath, 0, allExtPath, 0, extPath.length);
            allExtPath[extPath.length] = rest;
            ArrayList list = this.get(staticProject, allExtPath, true);
            if (list != null) {
                lItems.addAll(list);
            }
            return lItems;
        }
        return null;
    }

    public boolean hasItems() {
        return this.items.size() != 0;
    }

    public ArrayList getItems() {
        return this.items;
    }

    public LibraryItem getItem(String lprefix, boolean ignoreCase) {
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            LibraryItem li = (LibraryItem)it.next();
            if (!li.startsWith(lprefix, ignoreCase)) continue;
            return li;
        }
        if (this.extendsLib != null) {
            return this.extendsLib.getItem(lprefix, ignoreCase);
        }
        return null;
    }

    public ArrayList getAllItems(String rest, boolean ignoreCase) {
        ArrayList<LibraryItem> ret = new ArrayList<LibraryItem>();
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            LibraryItem li = (LibraryItem)it.next();
            if (!li.startsWith(rest, ignoreCase)) continue;
            ret.add(li);
        }
        return ret;
    }

    public ArrayList getAllLibraries(String rest, boolean ignoreCase) {
        ArrayList ret = new ArrayList();
        Iterator it = this.prefixes.iterator();
        while (it.hasNext()) {
            String lstr = (String)it.next();
            if (!this.startsWith(lstr, rest, ignoreCase)) continue;
            ret.add(this.libraries.get(lstr));
        }
        return ret;
    }

    public ArrayList getPrefixes(String suffix, boolean ignoreCase) {
        ArrayList<String> ps = new ArrayList<String>();
        int i = 0;
        while (i < this.prefixes.size()) {
            String p = (String)this.prefixes.get(i);
            boolean toadd = ignoreCase ? p.toLowerCase().startsWith(suffix.toLowerCase()) : p.startsWith(suffix);
            if (toadd) {
                ps.add(p);
            }
            ++i;
        }
        return ps;
    }

    public void addLibraryFile(LibraryFile file) {
        this.files.add(file);
    }

    public LibraryFile getLibraryFile(String path) {
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            LibraryFile file = (LibraryFile)it.next();
            if (!file.getPath().equals(path)) continue;
            return file;
        }
        return null;
    }

    public Library getLibrary(String lprefix) {
        return (Library)this.libraries.get(lprefix);
    }

    public Library getLibraryNoCase(String className) {
        int i = 0;
        while (i < this.prefixes.size()) {
            String lprefix = (String)this.prefixes.get(i);
            if (lprefix.toLowerCase().equals(className.toLowerCase())) {
                return (Library)this.libraries.get(lprefix);
            }
            ++i;
        }
        return null;
    }

    public synchronized void setLibrary(Library lib) {
        Library prev = this.libraries.put(lib.getPrefix(), lib);
        if (prev == null) {
            this.prefixes.add(lib.getPrefix());
        }
        lib.setParent(this);
    }

    public LibraryItem getItem(int index) {
        if (this.items.size() > 0) {
            return (LibraryItem)this.items.get(index);
        }
        return null;
    }

    public void setItem(LibraryItem libitem) {
        this.items.add(libitem);
    }

    public boolean removeItem(LibraryItem libitem) {
        return this.items.remove(libitem);
    }

    public String getPrefix() {
        return this.replacement;
    }

    public void setPrefix(String prefix) {
        this.replacement = prefix;
    }

    public void setExtendsLib(Library extendsLib) {
        this.extendsLib = extendsLib;
    }

    public String getExtendesLibString() {
        return this.extendsLibString;
    }

    public void setExtendsLibString(String extendsLibStr) {
        this.extendsLibString = extendsLibStr;
    }

    public boolean mustSave() {
        return this.save;
    }

    public void setSave(boolean save) {
        this.save = save;
    }

    public String getLibraryAbsoluteName() {
        if (this.parent == null) {
            return this.getPrefix();
        }
        String parentString = this.parent.getLibraryAbsoluteName();
        if (parentString == null) {
            return this.getPrefix();
        }
        return String.valueOf(parentString) + "." + this.getPrefix();
    }

    public String toString() {
        return this.replacement;
    }

    public String export() {
        String parentString = this.parent.getLibraryAbsoluteName();
        parentString = parentString == null ? "" : parentString;
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<completion version=\"").append(LibraryManager.VERSION);
        sb.append("\" prefix=\"").append(this.replacement).append("\" ");
        sb.append("extends=\"").append(this.extendsLibString).append("\" ");
        sb.append("parent=\"").append(parentString).append("\" >\n");
        Iterator it = this.files.iterator();
        while (it.hasNext()) {
            LibraryFile file = (LibraryFile)it.next();
            if (file.getItems().size() == 0) continue;
            sb.append("\t<file path=\"").append(file.getPath());
            sb.append("\" creation=\"").append(file.getCreationDate()).append("\">\n");
            Iterator init = file.getItems().iterator();
            while (init.hasNext()) {
                LibraryItem item = (LibraryItem)init.next();
                sb.append(item.export());
            }
            sb.append("\t</file>\n");
        }
        sb.append("</completion>");
        return sb.toString();
    }

    public class LibraryFile {
        private long creationDate = -1L;
        private String path;
        private ArrayList fileItems;

        public LibraryFile(String path) {
            this.path = path;
            this.fileItems = new ArrayList();
        }

        public void setCreationDate(long date) {
            this.creationDate = date;
        }

        public String getPath() {
            return this.path;
        }

        public long getCreationDate() {
            return this.creationDate;
        }

        public void addItem(LibraryItem item) {
            this.fileItems.add(item);
            item.setFileOwner(this);
        }

        public ArrayList getItems() {
            return this.fileItems;
        }
    }
}

