/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.library.Library;
import com.interaktonline.jseclipse.library.LibraryExtractor;
import com.interaktonline.jseclipse.library.LibraryItem;
import com.interaktonline.jseclipse.library.LibraryParser;
import com.interaktonline.jseclipse.library.LibraryProject;
import com.interaktonline.jseclipse.library.LibrarySemaphore;
import com.interaktonline.jseclipse.library.LibraryVersionException;
import com.interaktonline.jseclipse.library.ResourceParser;
import com.interaktonline.jseclipse.xml.DomUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class LibraryManager {
    public static String VERSION = "1.5.0";
    protected long creationTime = 0L;
    protected String pathSuffix = "";
    private Map projects = new HashMap();
    protected FilenameFilter fileFilter;
    private LibraryProject globalProject = new LibraryProject(this, "");

    protected LibraryManager() {
    }

    public LibraryProject getGlobalProject() {
        return this.globalProject;
    }

    public void parseDynamicLibrary(IFile file) {
        ResourceParser rparser = new ResourceParser(this);
        rparser.setFile(file);
        rparser.start();
    }

    private LibraryProject createLibraryProject(String name) {
        LibraryProject project = new LibraryProject(this, name);
        this.projects.put(name, project);
        return project;
    }

    public LibraryProject getProject(String name) {
        LibraryProject project = (LibraryProject)this.projects.get(name);
        if (project == null) {
            return this.createLibraryProject(name);
        }
        return project;
    }

    public void clear() {
        this.projects.clear();
    }

    public void parseDynamicLibrary() {
        long now = new Date().getTime();
        if (this.creationTime != 0L && now - this.creationTime < 10000L) {
            return;
        }
        ResourceParser rparser = new ResourceParser(this);
        if (this.creationTime == 0L) {
            LibraryParser parser2 = new LibraryParser(this);
            parser2.setLibraryRoot(this.getLibraryPath());
            LibrarySemaphore semaphore = new LibrarySemaphore(0);
            parser2.setSemaphore(semaphore);
            parser2.start();
            rparser.setSemaphore(semaphore);
        }
        this.creationTime = new Date().getTime();
        rparser.start();
    }

    public FilenameFilter getFilenameFilter() {
        return this.fileFilter;
    }

    protected String getLibraryPath() {
        IPath loc = JavaScriptEditorPlugin.getDefault().getStateLocation();
        return String.valueOf(loc.toString()) + "/" + this.pathSuffix;
    }

    public void newLibraryFromDom(LibraryProject project, Document doc, boolean keepVersion) throws LibraryVersionException {
        String extendsString;
        Library lib;
        Element root = doc.getDocumentElement();
        String version = root.getAttribute("version");
        if (keepVersion && !version.equals(VERSION)) {
            throw new LibraryVersionException();
        }
        Library parent = project;
        String namespace = root.getAttribute("parent");
        String prefix = root.getAttribute("prefix");
        if (namespace.trim().length() != 0) {
            String[] path = namespace.split("\\.");
            parent = project.getOrCreateLibrary(path, 0);
        }
        if ((lib = parent.getLibrary(prefix)) == null) {
            lib = new Library();
            lib.setPrefix(prefix);
            parent.setLibrary(lib);
        }
        if ((extendsString = root.getAttribute("extends")) != null && extendsString.trim().length() != 0) {
            lib.setExtendsLibString(extendsString);
        }
        NodeList nl = root.getElementsByTagName("file");
        boolean recreate = false;
        if (nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Element el = (Element)nl.item(i);
                String fileName = el.getAttribute("path");
                File theFile = new File(fileName);
                if (!theFile.exists()) {
                    recreate = true;
                } else {
                    Library library = lib;
                    library.getClass();
                    Library.LibraryFile file = library.new Library.LibraryFile(fileName);
                    try {
                        long creation = Long.parseLong(el.getAttribute("creation"));
                        project.setLibCreation(file.getPath(), creation);
                        file.setCreationDate(creation);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    lib.addLibraryFile(file);
                    this.getItemsFromElement(el, lib, file);
                }
                ++i;
            }
        } else {
            this.getItemsFromElement(root, lib, null);
        }
        if (recreate) {
            throw new LibraryVersionException();
        }
    }

    private void getItemsFromElement(Element elem, Library lib, Library.LibraryFile file) {
        NodeList nl = elem.getElementsByTagName("item");
        int i = 0;
        while (i < nl.getLength()) {
            Element el = (Element)nl.item(i);
            LibraryItem li = new LibraryItem(lib);
            if (file != null) {
                file.addItem(li);
            }
            li.setReplacement(el.getAttribute("repl"));
            li.setDisplay(DomUtils.fromCharReferences(el.getAttribute("display")));
            try {
                li.setLocation(Integer.parseInt(el.getAttribute("chrno")));
            }
            catch (NumberFormatException numberFormatException) {}
            if (el.hasChildNodes()) {
                NodeList kids = el.getChildNodes();
                int j = 0;
                while (j < kids.getLength()) {
                    Node node = kids.item(j);
                    if (node instanceof CDATASection) {
                        CDATASection cdata = (CDATASection)node;
                        li.setAdditionalInfo(cdata.getData());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public abstract void parseStaticLibrary();

    public abstract LibraryExtractor getLibraryExtractor();
}

