/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.jseclipse.library.LibraryManager;
import com.interaktonline.jseclipse.library.LibraryProject;
import com.interaktonline.jseclipse.library.LibrarySemaphore;
import com.interaktonline.jseclipse.library.LibraryVersionException;
import com.interaktonline.jseclipse.xml.DomUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.w3c.dom.Document;

public class LibraryParser
extends Thread {
    private String libraryRoot = null;
    private URL urlLibRoot = null;
    private String[] files;
    private DomUtils domUtils = null;
    private LibraryManager manager;
    private LibrarySemaphore semaphore;
    private boolean keepVersion = true;
    private boolean users = false;

    public boolean isKeepVersion() {
        return this.keepVersion;
    }

    public void setKeepVersion(boolean keepVersion) {
        this.keepVersion = keepVersion;
    }

    public LibraryParser(LibraryManager manager) {
        super("Library parser " + manager.toString());
        this.manager = manager;
        this.domUtils = new DomUtils();
    }

    public void run() {
        new Date().getTime();
        this.loadLibraries();
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    public void setSemaphore(LibrarySemaphore semaphore) {
        this.semaphore = semaphore;
    }

    public void setLibraryRoot(String libroot) {
        this.libraryRoot = libroot;
    }

    public void setLibraryRoot(URL libroot, String[] files) {
        this.urlLibRoot = libroot;
        this.files = files;
    }

    private void loadLibraries() {
        if (this.libraryRoot != null) {
            if (this.isUsers()) {
                this.loadLibrariesUser();
            } else {
                this.loadLibrariesFiles();
            }
        } else {
            this.loadLibrariesURL();
        }
    }

    private void loadLibrariesURL() {
        int i = 0;
        while (i < this.files.length) {
            try {
                URL url = new URL(this.urlLibRoot, this.files[i]);
                Document doc = this.domUtils.loadXML(new BufferedInputStream(url.openStream()));
                this.manager.newLibraryFromDom(this.manager.getGlobalProject(), doc, false);
            }
            catch (LibraryVersionException libraryVersionException) {
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void loadLibrariesFiles() {
        File fLibRoot = new File(this.libraryRoot);
        if (!fLibRoot.exists()) {
            return;
        }
        File[] folders = fLibRoot.listFiles(new FolderFilter());
        int i = 0;
        while (i < folders.length) {
            LibraryProject project = this.manager.getProject(folders[i].getName());
            File[] allLibs = folders[i].listFiles(new XmlFilenameFilter());
            int j = 0;
            while (j < allLibs.length) {
                Document doc = this.domUtils.loadXML(allLibs[j].getAbsolutePath(), true);
                if (doc != null) {
                    try {
                        this.manager.newLibraryFromDom(project, doc, this.keepVersion);
                    }
                    catch (LibraryVersionException libraryVersionException) {
                        allLibs[j].delete();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void loadLibrariesUser() {
        File fLibRoot = new File(this.libraryRoot);
        if (!fLibRoot.exists()) {
            return;
        }
        LibraryProject project = this.manager.getGlobalProject();
        File[] allLibs = fLibRoot.listFiles(new XmlFilenameFilter());
        int j = 0;
        while (j < allLibs.length) {
            Document doc = this.domUtils.loadXML(allLibs[j].getAbsolutePath(), true);
            if (doc != null) {
                try {
                    this.manager.newLibraryFromDom(project, doc, this.keepVersion);
                }
                catch (LibraryVersionException libraryVersionException) {
                    allLibs[j].delete();
                }
            }
            ++j;
        }
    }

    public boolean isUsers() {
        return this.users;
    }

    public void setUsers(boolean users) {
        this.users = users;
    }

    static class XmlFilenameFilter
    implements FilenameFilter {
        XmlFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    }

    static class FolderFilter
    implements FileFilter {
        FolderFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

