/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.jseclipse.library.Library;
import com.interaktonline.jseclipse.library.LibraryManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class LibraryProject
extends Library {
    protected LibraryManager owner;
    private String project;
    private Map creation = new HashMap(128);
    private HashMap noParse = new HashMap(128);

    public LibraryProject(LibraryManager manager, String name) {
        this.owner = manager;
        this.project = name;
        this.loadNoParse();
    }

    public String getName() {
        return this.project;
    }

    public void setNoParse(String className, long modif) {
        this.noParse.put(className, new Long(modif));
    }

    public Long getNoParse(String className) {
        return (Long)this.noParse.get(className);
    }

    protected String getNoParseText() {
        StringBuffer sb = new StringBuffer();
        Set keySet = this.noParse.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            sb.append(key).append(':').append(this.noParse.get(key)).append("\r\n");
        }
        return sb.toString();
    }

    protected void setNoParseText(String text) {
        if (text == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text, "\r\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int ix = token.lastIndexOf(":");
            if (ix == -1) continue;
            this.noParse.put(token.substring(0, ix), new Long(token.substring(ix + 1)));
        }
    }

    public void setLibCreation(String prefix, long modif) {
        if (!this.creation.containsKey(prefix)) {
            this.creation.put(prefix, new Long(modif));
        }
    }

    public Long getLibCreation(String prefix) {
        return (Long)this.creation.get(prefix);
    }

    public void saveAll() {
        this.saveLibraries(this);
    }

    private void saveLibraries(Library parent) {
        Library[] libs = parent.getLibraries();
        int i = 0;
        while (i < libs.length) {
            Library lib = libs[i];
            if (lib.hasItems() && lib.mustSave()) {
                FileTools.saveToFile(String.valueOf(this.owner.getLibraryPath()) + this.getName() + "/", String.valueOf(lib.getLibraryAbsoluteName()) + ".xml", lib.export());
            }
            this.saveLibraries(lib);
            ++i;
        }
    }

    public void saveNoParse() {
        String libPath = String.valueOf(this.owner.getLibraryPath()) + this.project + "/";
        String text = this.getNoParseText();
        FileTools.saveToFile(libPath, "noparse.txt", text);
    }

    protected void loadNoParse() {
        String libPath = String.valueOf(this.owner.getLibraryPath()) + this.project + "/";
        this.setNoParseText(FileTools.getFileText(String.valueOf(libPath) + "noparse.txt"));
    }
}

