/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.jseclipse.library.LibraryExtractor;
import com.interaktonline.jseclipse.library.LibraryManager;
import com.interaktonline.jseclipse.library.LibraryProject;
import com.interaktonline.jseclipse.library.LibrarySemaphore;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ResourceParser
extends Thread {
    private IWorkspaceRoot workspace;
    private IFile file = null;
    private LibraryManager manager;
    private LibrarySemaphore semaphore;
    private LibraryExtractor extractor;
    public FilenameFilter fileFilter;
    public static FileFilter folderFilter = new FolderFilter();

    public ResourceParser(LibraryManager manager) {
        super("Resource parser " + manager);
        this.manager = manager;
        this.workspace = ResourcesPlugin.getWorkspace().getRoot();
        this.extractor = this.manager.getLibraryExtractor();
        this.fileFilter = this.manager.getFilenameFilter();
        this.setPriority(1);
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public void setSemaphore(LibrarySemaphore semaphore) {
        this.semaphore = semaphore;
    }

    public void run() {
        if (this.semaphore != null) {
            this.semaphore.acquire();
        }
        Logger logger = Logger.getLogger("com.interaktonline.jseditor.log");
        Date start = new Date();
        if (this.file != null) {
            logger.info("parsing file: " + this.file);
            this.extractor.parse(this.file, this.manager, this.manager.getProject(this.file.getProject().getName()));
        } else {
            IProject[] projects = this.workspace.getProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen()) {
                    logger.info("parsing project: " + projects[i].getName());
                    LibraryProject project = this.manager.getProject(projects[i].getName());
                    this.parseFilesFrom((IContainer)projects[i], project);
                    project.saveNoParse();
                    project.saveAll();
                }
                ++i;
            }
        }
        Date now = new Date();
        logger.info(this.manager + " parsing for: " + (now.getTime() - start.getTime()));
    }

    private void parseFilesFrom(IContainer resource, LibraryProject project) {
        IResource[] res = null;
        try {
            res = resource.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < res.length) {
            IResource tmp = res[i];
            if (tmp instanceof IFile) {
                if (this.fileFilter.accept(null, tmp.getName())) {
                    this.extractor.parse((IFile)tmp, this.manager, project);
                }
            } else if (tmp instanceof IFolder) {
                this.parseFilesFrom((IContainer)((IFolder)tmp), project);
            }
            ++i;
        }
    }

    static class FolderFilter
    implements FileFilter {
        private static String[] exclude = new String[]{".svn", "CVS", ".deps"};

        FolderFilter() {
        }

        private boolean isNotExcluded(File pathname) {
            String folder = pathname.getName();
            int i = 0;
            while (i < exclude.length) {
                if (folder.equals(exclude[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() && this.isNotExcluded(pathname);
        }
    }
}

