/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.library;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.core.text.FakeDocument;
import com.interaktonline.jseclipse.embed.JsContext;
import com.interaktonline.jseclipse.jsdom.JsDocNode;
import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.library.Library;
import com.interaktonline.jseclipse.library.LibraryExtractor;
import com.interaktonline.jseclipse.library.LibraryItem;
import com.interaktonline.jseclipse.library.LibraryManager;
import com.interaktonline.jseclipse.library.LibraryProject;
import com.interaktonline.jseclipse.text.interpreters.RhinoTreeParser;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Position;
import org.mozilla.javascript.ScriptOrFnNode;

public class RhinoLibraryExtractor
extends LibraryExtractor {
    private RhinoTreeParser fRhinoTreeParser;
    private JsContext jscx;
    private LibraryProject fProject;
    private Library refParent;
    private String[] path = new String[10];
    int pathEnd = 0;

    public RhinoLibraryExtractor() {
        this.jscx = JsContext.getInstance();
        this.fRhinoTreeParser = new RhinoTreeParser();
    }

    public void parse(IFile file, LibraryManager manager, LibraryProject project) {
        this.fProject = project;
        String theFilePath = file.getLocation().toString();
        Long creation = project.getLibCreation(theFilePath);
        if (creation != null && creation >= file.getLocalTimeStamp()) {
            return;
        }
        Long noParse = project.getNoParse(theFilePath);
        if (noParse != null && noParse.longValue() == file.getLocalTimeStamp()) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        FakeDocument document = FileTools.getFakeDocument(file);
        if (document == null) {
            return;
        }
        String text = document.get();
        if (text == null || text.trim().length() == 0) {
            return;
        }
        JsDocNode jsdoc = new JsDocNode("document", new Position(0, text.length()));
        String err = this.jscx.eval(text, false);
        if (err == null) {
            ScriptOrFnNode tree = this.jscx.getParsingTree();
            this.fRhinoTreeParser.setJsDocNode(jsdoc);
            this.fRhinoTreeParser.setDocument(document);
            this.fRhinoTreeParser.createFromTree(tree);
            if (jsdoc.getClassNodes().length == 0) {
                project.setNoParse(theFilePath, file.getLocalTimeStamp());
            }
            this.refParent = this.fProject;
            this.saveToLibrary(jsdoc, file);
            return;
        }
        project.setNoParse(theFilePath, file.getLocalTimeStamp());
    }

    private void saveToLibrary(JsNode node, IFile file) {
        if (node.getType() == JsNode.CLASS) {
            String theFilePath = file.getLocation().toString();
            this.path[this.pathEnd++] = node.getText();
            Library classLib = this.fProject.getLibrary(this.path, 0, this.pathEnd - 1);
            Library.LibraryFile theFile = null;
            if (classLib != null) {
                theFile = classLib.getLibraryFile(theFilePath);
                if (theFile != null) {
                    Iterator init = theFile.getItems().iterator();
                    while (init.hasNext()) {
                        LibraryItem item = (LibraryItem)init.next();
                        classLib.removeItem(item);
                    }
                    theFile.getItems().clear();
                } else {
                    Library library = classLib;
                    library.getClass();
                    theFile = library.new Library.LibraryFile(theFilePath);
                    classLib.addLibraryFile(theFile);
                }
                theFile.setCreationDate(file.getLocalTimeStamp());
            } else {
                classLib = new Library();
                classLib.setExtendsLibString(node.getExtendsString());
                classLib.setPrefix(node.getText());
                Library library = classLib;
                library.getClass();
                theFile = library.new Library.LibraryFile(theFilePath);
                classLib.addLibraryFile(theFile);
                theFile.setCreationDate(file.getLocalTimeStamp());
                this.refParent.setLibrary(classLib);
            }
            ArrayList kids = node.getChildNodes();
            int i = 0;
            while (i < kids.size()) {
                JsNode kid = (JsNode)kids.get(i);
                if (kid.getType() == JsNode.FUNCTION || kid.getType() == JsNode.THIS || kid.getType() == JsNode.VARIABLE) {
                    LibraryItem li = new LibraryItem();
                    li.setReplacement(String.valueOf(kid.getText()) + (kid.getType() == JsNode.FUNCTION ? "()" : ""));
                    li.setDisplay(kid.toString());
                    li.setLocation(kid.getLineno());
                    li.setAdditionalInfo(kid.getDoc());
                    li.setParent(classLib);
                    classLib.setItem(li);
                    theFile.addItem(li);
                }
                ++i;
            }
            classLib.setSave(true);
            this.refParent = classLib;
        }
        JsNode[] classes = node.getClassNodes();
        int i = 0;
        while (i < classes.length) {
            this.saveToLibrary(classes[i], file);
            ++i;
        }
        if (node.getType() == JsNode.CLASS) {
            this.refParent = this.refParent.getParent();
            --this.pathEnd;
        }
    }
}

