/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.preferences;

import com.interaktonline.core.fileutils.FileTools;
import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.editors.JSColorProvider;
import com.interaktonline.jseclipse.editors.JSConfiguration;
import com.interaktonline.jseclipse.editors.JSTextTools;
import com.interaktonline.jseclipse.preferences.PreferenceConstants;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SyntaxColoringPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ColorSelector colorSelector;
    private IPreferenceStore lPreferenceStore;
    private Color bgColor;
    private SourceViewer preview;
    private String fPropertyName;

    public SyntaxColoringPreferencePage() {
        this.setDescription("JSEclipse editor syntax coloring preferences.\n");
        this.initialize();
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        IPreferenceStore ps = JavaScriptEditorPlugin.getDefault().getPreferenceStore();
        if (this.lPreferenceStore == null) {
            this.lPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.interaktonline.jseclipse.preferences.syntax");
        }
        int i = 0;
        while (i < PreferenceConstants.STYLE_PREFS.length) {
            String name = PreferenceConstants.STYLE_PREFS[i];
            this.lPreferenceStore.setDefault(name, new String(ps.getDefaultString(name)));
            this.lPreferenceStore.setValue(name, new String(ps.getString(name)));
            ++i;
        }
        this.setPreferenceStore(this.lPreferenceStore);
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        Composite treeComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        treeComposite.setLayout((Layout)layout);
        treeComposite.setLayoutData((Object)new GridData(1808));
        Composite styleComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        styleComposite.setLayout((Layout)layout);
        styleComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(treeComposite, 16384);
        label.setText("Element:");
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        Tree tree = new Tree(treeComposite, 4);
        gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        this.fillTree(tree);
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object data = ((TreeItem)e.item).getData();
                if (data != null) {
                    SyntaxColoringPreferencePage.this.fPropertyName = data.toString();
                    SyntaxColoringPreferencePage.this.colorSelector.setEnabled(true);
                    SyntaxColoringPreferencePage.this.colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)SyntaxColoringPreferencePage.this.getPreferenceStore(), (String)SyntaxColoringPreferencePage.this.fPropertyName));
                } else {
                    SyntaxColoringPreferencePage.this.fPropertyName = null;
                    SyntaxColoringPreferencePage.this.colorSelector.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(styleComposite, 131072);
        label.setText("color:");
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.colorSelector = new ColorSelector(styleComposite);
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (SyntaxColoringPreferencePage.this.fPropertyName != null) {
                    SyntaxColoringPreferencePage.this.getPreferenceStore().setValue(SyntaxColoringPreferencePage.this.fPropertyName, StringConverter.asString((RGB)((RGB)event.getNewValue())));
                }
            }
        });
        this.colorSelector.setEnabled(false);
        Button colorButton = this.colorSelector.getButton();
        gd = new GridData(768);
        colorButton.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText("Preview:");
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        previewer.setLayoutData((Object)gd);
        return colorComposite;
    }

    private void fillTree(Tree tree) {
        TreeItem js = new TreeItem(tree, 16384);
        js.setText("JavaScript");
        TreeItem jd = new TreeItem(tree, 16384);
        jd.setText("JavaDoc");
        TreeItem jc = new TreeItem(tree, 16384);
        jc.setText("Comments");
        TreeItem kid = new TreeItem(js, 16384);
        kid.setText("keyword");
        kid.setData((Object)"keywordColor");
        kid = new TreeItem(js, 16384);
        kid.setText("word");
        kid.setData((Object)"wordColor");
        kid = new TreeItem(js, 16384);
        kid.setText("constant");
        kid.setData((Object)"constantColor");
        kid = new TreeItem(js, 16384);
        kid.setText("string");
        kid.setData((Object)"stringColor");
        kid = new TreeItem(js, 16384);
        kid.setText("regular expresion");
        kid.setData((Object)"regexpColor");
        kid = new TreeItem(jd, 16384);
        kid.setText("keyword");
        kid.setData((Object)"javadocKeywordColor");
        kid = new TreeItem(jd, 16384);
        kid.setText("tag");
        kid.setData((Object)"javadocTagColor");
        kid = new TreeItem(jd, 16384);
        kid.setText("link");
        kid.setData((Object)"javadocLinkColor");
        kid = new TreeItem(jd, 16384);
        kid.setText("default text");
        kid.setData((Object)"javadocDefaultColor");
        kid = new TreeItem(jc, 16384);
        kid.setText("multi-line comments");
        kid.setData((Object)"multilineCommentColor");
        kid = new TreeItem(jc, 16384);
        kid.setText("single-line comments");
        kid.setData((Object)"singlelineCommentColor");
    }

    private Control createPreviewer(Composite parent) {
        JSTextTools jstt = new JSTextTools();
        JSConfiguration svc = new JSConfiguration(this.getPreferenceStore());
        final JSColorProvider colorManager = JavaScriptEditorPlugin.getDefault().getJSColorProvider(this.getPreferenceStore());
        this.preview = new SourceViewer(parent, null, 2816);
        this.preview.configure((SourceViewerConfiguration)svc);
        this.preview.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.preview.setEditable(false);
        this.initializeViewerColors((ISourceViewer)this.preview);
        String content = FileTools.getResourceText("/com/interaktonline/jseclipse/preferences/preview.js");
        Document document = new Document(content);
        IDocumentPartitioner partitioner = jstt.getJsDocumentPartitioner();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(partitioner);
        this.preview.setDocument((IDocument)document);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String p = event.getProperty();
                if (p.equals("AbstractTextEditor.Color.Background") || p.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
                    SyntaxColoringPreferencePage.this.initializeViewerColors((ISourceViewer)SyntaxColoringPreferencePage.this.preview);
                }
                colorManager.handlePreferenceStoreChanged(event);
                SyntaxColoringPreferencePage.this.preview.invalidateTextPresentation();
            }
        });
        return this.preview.getControl();
    }

    void initializeViewerColors(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = null;
            if (!store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault")) {
                color = this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            }
            styledText.setBackground(color);
            if (this.bgColor != null) {
                this.bgColor.dispose();
            }
            this.bgColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    protected void performDefaults() {
        int i = 0;
        while (i < PreferenceConstants.STYLE_PREFS.length) {
            String name = PreferenceConstants.STYLE_PREFS[i];
            this.lPreferenceStore.setValue(name, new String(this.lPreferenceStore.getDefaultString(name)));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore ps = JavaScriptEditorPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < PreferenceConstants.STYLE_PREFS.length) {
            String name = PreferenceConstants.STYLE_PREFS[i];
            ps.setValue(name, new String(this.lPreferenceStore.getString(name)));
            ++i;
        }
        return true;
    }
}

