/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.preferences;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.preferences.PreferenceConstants;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class TypingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore lPreferenceStore;

    public TypingPreferencePage() {
        this.setDescription("JSEclipse editor typing preferences.\n");
        this.initialize();
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        IPreferenceStore ps = JavaScriptEditorPlugin.getDefault().getPreferenceStore();
        if (this.lPreferenceStore == null) {
            this.lPreferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.interaktonline.jseclipse.preferences.typing");
        }
        int i = 0;
        while (i < PreferenceConstants.TYPING_PREFS.length) {
            String name = PreferenceConstants.TYPING_PREFS[i];
            this.lPreferenceStore.setDefault(name, ps.getDefaultBoolean(name));
            this.lPreferenceStore.setValue(name, ps.getBoolean(name));
            ++i;
        }
        this.setPreferenceStore(this.lPreferenceStore);
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        editorComposite.setFont(parent.getFont());
        GridData gd = new GridData(768);
        editorComposite.setLayoutData((Object)gd);
        Label label = new Label(editorComposite, 16384);
        label.setText("Automatically close: ");
        label.setFont(parent.getFont());
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.createCheckbox(editorComposite, "Strings", "stringTypingAssist");
        this.createCheckbox(editorComposite, "(parantheses), [square brackets]", "paranthesesTypingAssist");
        this.createCheckbox(editorComposite, "{braces}", "bracesTypingAssist");
        this.createCheckbox(editorComposite, "Javadoc and multiline comments", "javadocTypingAssist");
        return colorComposite;
    }

    private Button createCheckbox(Composite parent, String label, String data) {
        Button checkBox = new Button(parent, 16416);
        GridData gd = new GridData();
        checkBox.setLayoutData((Object)gd);
        checkBox.setFont(parent.getFont());
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setSelection(this.getPreferenceStore().getBoolean(data));
        checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button cb = (Button)e.getSource();
                Object ldata = cb.getData();
                if (ldata != null) {
                    String fPropertyName = ldata.toString();
                    TypingPreferencePage.this.getPreferenceStore().setValue(fPropertyName, cb.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return checkBox;
    }

    protected void performDefaults() {
        int i = 0;
        while (i < PreferenceConstants.TYPING_PREFS.length) {
            String name = PreferenceConstants.TYPING_PREFS[i];
            this.lPreferenceStore.setValue(name, this.lPreferenceStore.getDefaultBoolean(name));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore ps = JavaScriptEditorPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < PreferenceConstants.TYPING_PREFS.length) {
            String name = PreferenceConstants.TYPING_PREFS[i];
            ps.setValue(name, this.lPreferenceStore.getBoolean(name));
            ++i;
        }
        return true;
    }
}

