/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text;

import com.interaktonline.jseclipse.text.JavascriptAutoEditStrategy;
import com.interaktonline.jseclipse.text.TextUtilities;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class BlockAutoEditStrategy
extends JavascriptAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String text = command.text;
        if (text == null) {
            return;
        }
        if (text.matches("\\r\\n|\\r|\\n")) {
            int caretOffset = command.offset - command.length;
            if (!this.blockStarted(document, caretOffset)) {
                return;
            }
            boolean blockEnded = this.blockEnded(document, caretOffset);
            int realix = this.getRealBlocStartOffset(document, caretOffset);
            String wPrefix = this.getWhitespaceStart(document, realix);
            StringBuffer sb = new StringBuffer().append(text).append(wPrefix).append(indentString);
            if (!blockEnded) {
                if (this.lineIsEmpty(document, caretOffset)) {
                    sb.append(text).append(wPrefix).append('}');
                }
            } else if (this.braketOnSameLine(document, caretOffset)) {
                sb.append(text).append(wPrefix);
            }
            command.text = sb.toString();
            command.length = 0;
            int jump = text.length() + wPrefix.length() + indentString.length();
            command.caretOffset = command.offset + jump;
            command.doit = true;
            command.owner = null;
            command.shiftsCaret = false;
        } else if (text.equals("}")) {
            try {
                IRegion line = document.getLineInformationOfOffset(command.offset);
                int ix = line.getOffset();
                int end = command.offset - 1;
                while (Character.isWhitespace(document.getChar(ix)) && ix < end) {
                    ++ix;
                }
                if (ix != end || !Character.isWhitespace(document.getChar(end))) {
                    return;
                }
                String pairStarting = this.getPairStarting(document, command.offset);
                if (pairStarting == null) {
                    return;
                }
                command.text = String.valueOf(pairStarting) + '}';
                command.length = command.offset - line.getOffset();
                command.offset = line.getOffset();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private int getRealBlocStartOffset(IDocument document, int offset) {
        int ix = offset - 1;
        try {
            IRegion line = document.getLineInformationOfOffset(offset);
            int end = line.getOffset();
            char c = document.getChar(ix);
            while ((c == ' ' || c == '\t' || c == '{') && c != ')' && ix >= end) {
                c = document.getChar(--ix);
            }
            if (c != ')') {
                return offset;
            }
            if ((ix = this.getPositionForOtherMatch(document, ix, ')', '(')) != -1) {
                return ix;
            }
        }
        catch (BadLocationException badLocationException) {}
        return offset;
    }

    private boolean lineIsEmpty(IDocument document, int offset) {
        int ix = offset;
        try {
            while (document.getChar(ix) == ' ' || document.getChar(ix) == '\t') {
                ++ix;
            }
            if (document.getChar(ix) == '\r' || document.getChar(ix) == '\n') {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private boolean braketOnSameLine(IDocument document, int offset) {
        int ix = offset;
        try {
            while (document.getChar(ix) == ' ' || document.getChar(ix) == '\t') {
                ++ix;
            }
            if (document.getChar(ix) == '}') {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private boolean blockEnded(IDocument document, int offset) {
        int preB = 0;
        try {
            preB = this.getBraketSurplus(document, 0, offset);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        int postB = 0;
        try {
            postB = this.getBraketSurplus(document, offset, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return preB + postB <= 0;
    }

    private int getBraketSurplus(IDocument document, int start, int end) throws BadLocationException {
        int ix = start;
        int B = 0;
        while (ix < end) {
            int partEnd = TextUtilities.skipPartition(document, ix, "__dftl_partition_content_type");
            if (partEnd > 0) {
                ix = partEnd;
                continue;
            }
            char c = document.getChar(ix);
            if (c == '{') {
                ++B;
            }
            if (c == '}') {
                --B;
            }
            ++ix;
        }
        return B;
    }

    private boolean blockStarted(IDocument document, int offset) {
        int ix = offset - 1;
        while (ix >= 0) {
            char c;
            if (!TextUtilities.isPartition(document, ix, "__dftl_partition_content_type")) {
                --ix;
                continue;
            }
            try {
                c = document.getChar(ix);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            if (c == '{') {
                return true;
            }
            if (c != ' ' && c != '\t') {
                return false;
            }
            --ix;
        }
        return false;
    }

    private String getPairStarting(IDocument document, int offset) {
        int blockStart = this.getPositionForOtherMatch(document, offset, '}', '{');
        if (blockStart == -1) {
            return null;
        }
        int realix = this.getRealBlocStartOffset(document, blockStart);
        return this.getWhitespaceStart(document, realix);
    }

    private int getPositionForOtherMatch(IDocument document, int start, char ch, char op) {
        String text = document.get();
        int i = start - 1;
        int inside = 0;
        while (i > 0) {
            if (text.charAt(i) == ch && TextUtilities.isPartition(document, i, "__dftl_partition_content_type")) {
                ++inside;
            } else if (text.charAt(i) == op && TextUtilities.isPartition(document, i, "__dftl_partition_content_type")) {
                if (inside > 0) {
                    --inside;
                } else {
                    return i;
                }
            }
            --i;
        }
        return -1;
    }
}

