/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text;

import com.interaktonline.core.structures.IntQueue;
import com.interaktonline.jseclipse.text.JavascriptAutoEditStrategy;
import java.util.Date;
import java.util.Map;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatter {
    private static int TOKEN_EOL = 0;
    private static int TOKEN_EXPR = 1;
    private static int TOKEN_BLOCK = 2;
    private StringBuffer content;
    private int leftMargin = 0;
    private int cnt = 0;
    private char ch = '\u0000';
    private IntQueue tokenQueue;
    private String lineDelimiter;
    private char[] buf = null;

    public TextEdit format2(String text, int offset, int length, int indentationLevel, String lineDelimiter, Map preferences) {
        this.lineDelimiter = lineDelimiter;
        this.content = new StringBuffer();
        String result = this.format(text);
        ReplaceEdit edit = new ReplaceEdit(0, text.length(), result);
        return edit;
    }

    public String format(String text) {
        new Date();
        this.tokenQueue = new IntQueue(32);
        this.cnt = 1;
        this.leftMargin = 0;
        this.buf = new char[text.length() - 1];
        text.getChars(0, text.length() - 1, this.buf, 0);
        this.ch = this.buf[0];
        this.parse();
        return this.content.toString();
    }

    private void parse() {
        this.processLineStart();
        while (!this.isEOF()) {
            switch (this.ch) {
                case '{': {
                    this.processBlockStart();
                    break;
                }
                case '}': {
                    this.processBlockEnd();
                    break;
                }
                case '(': {
                    this.processExpressionStart();
                    break;
                }
                case ')': {
                    this.processExpressionEnd();
                    break;
                }
                case ';': {
                    this.processSemicolon();
                    break;
                }
                case '/': {
                    this.processSlash();
                    break;
                }
                case '\n': 
                case '\r': {
                    this.processLineEnd();
                    break;
                }
                case '\"': 
                case '\'': {
                    this.processString();
                }
                default: {
                    this.next();
                }
            }
        }
        this.processLineEnd();
        this.insertNewLine();
    }

    private void processBlockStart() {
        char nextch;
        boolean onNewLine = true;
        boolean newLineAfter = true;
        if (onNewLine) {
            int token = this.tokenQueue.peek();
            if (token != TOKEN_EOL) {
                this.insertNewLine();
                this.insertLineStart();
            } else {
                this.tokenQueue.pop();
            }
        }
        this.next();
        this.increaseMargin();
        if (newLineAfter && !this.isEOL(nextch = this.buf[this.cnt + 1])) {
            this.insertNewLine();
            this.processLineStart();
        }
        this.tokenQueue.push(TOKEN_BLOCK);
    }

    private void processBlockEnd() {
        boolean onNewLine;
        if (this.tokenQueue.peek() == TOKEN_BLOCK) {
            this.tokenQueue.pop();
        }
        if (onNewLine = true) {
            this.insertNewLine();
            this.decreaseMargin();
            this.insertLineStart();
            this.next();
            this.insertNewLine();
            this.processLineStart();
        } else {
            this.decreaseMargin();
            this.next();
        }
    }

    private void processString() {
        char start = this.ch;
        boolean esc = false;
        while (this.cnt < this.buf.length) {
            this.next();
            if (!esc) {
                if (this.ch == '\\') {
                    esc = true;
                    continue;
                }
                if (this.ch != start) continue;
                return;
            }
            esc = false;
        }
    }

    private void processExpressionStart() {
        this.tokenQueue.push(TOKEN_EXPR);
        this.next();
    }

    private void processExpressionEnd() {
        if (this.tokenQueue.peek() == TOKEN_EXPR) {
            this.tokenQueue.pop();
        }
        this.next();
    }

    private void processSemicolon() {
        this.next();
        if (!this.isEOL(this.ch) && this.tokenQueue.peek() != TOKEN_EXPR) {
            this.insertNewLine();
            this.processLineStart();
        }
    }

    private void processLineStart() {
        if (this.tokenQueue.peek() == TOKEN_EOL) {
            this.tokenQueue.pop();
        }
        while ((this.ch == ' ' || this.ch == '\t') && this.cnt < this.buf.length) {
            this.skip();
        }
        if (this.ch == '}') {
            if (this.tokenQueue.peek() == TOKEN_BLOCK) {
                this.tokenQueue.pop();
            }
            this.decreaseMargin();
            this.insertLineStart();
            this.next();
        } else {
            this.insertLineStart();
        }
    }

    private void processLineEnd() {
        this.tokenQueue.push(TOKEN_EOL);
        while ((this.ch == '\r' || this.ch == '\n') && this.cnt < this.buf.length) {
            this.next();
        }
        this.processLineStart();
    }

    private void processSlash() {
        this.next();
    }

    private void insertNewLine() {
        this.content.append(this.lineDelimiter);
    }

    private void insertLineStart() {
        int i = 0;
        while (i < this.leftMargin) {
            this.content.append(JavascriptAutoEditStrategy.indentString);
            ++i;
        }
    }

    private void next() {
        this.content.append(this.ch);
        this.skip();
    }

    private void skip() {
        if (!this.isEOF()) {
            this.ch = this.buf[this.cnt++];
        }
    }

    private void increaseMargin() {
        ++this.leftMargin;
    }

    private void decreaseMargin() {
        --this.leftMargin;
        this.leftMargin = this.leftMargin < 0 ? 0 : this.leftMargin;
    }

    private boolean isEOF() {
        return this.cnt == this.buf.length;
    }

    private boolean isEOL(char chr) {
        return this.ch == '\r' || this.ch == '\n';
    }
}

