/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class CommentAutoEditStrategy
implements IAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String text = command.text;
        if (text == null) {
            return;
        }
        if (text.matches("\\r\\n|\\r|\\n")) {
            int caretOffset = command.offset - command.length;
            try {
                IRegion line = document.getLineInformationOfOffset(caretOffset);
                int ix = line.getOffset();
                int end = line.getOffset() + line.getLength();
                if (end == caretOffset) {
                    return;
                }
                StringBuffer sb = new StringBuffer();
                while (Character.isWhitespace(document.getChar(ix)) && ix < end) {
                    sb.append(document.getChar(ix++));
                }
                command.text = text + sb + "// ";
                command.length = 0;
                int jump = text.length() + sb.length() + 3;
                command.caretOffset = command.offset + jump;
                command.doit = true;
                command.owner = null;
                command.shiftsCaret = false;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

