/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text;

import com.interaktonline.jseclipse.embed.JsContext;
import com.interaktonline.jseclipse.jsdom.Comment;
import com.interaktonline.jseclipse.jsdom.Error;
import com.interaktonline.jseclipse.jsdom.JsDocNode;
import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.text.DocumentParsedEvent;
import com.interaktonline.jseclipse.text.IDocumentParsedListener;
import com.interaktonline.jseclipse.text.TextUtilities;
import com.interaktonline.jseclipse.text.interpreters.RhinoTreeParser;
import com.interaktonline.jseclipse.util.JsPluginImages;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.mozilla.javascript.ScriptOrFnNode;

public class JsDocument
extends Document {
    private ArrayList documentParsedListeners;
    private Pattern functions = Pattern.compile("function\\s+(\\w+)\\s*\\(");
    private Pattern backfunction = Pattern.compile("\\s*(\\w+)\\s*=\\s*function\\(");
    private Pattern lineNo = Pattern.compile("#([0-9]*)");
    private JsDocNode jsdoc;
    private Map tester;
    private boolean hasChanged;
    private List changesQueue = new ArrayList();
    private JsContext jscx;
    private RhinoTreeParser fRhinoTreeParser;

    protected void completeInitialization() {
        super.completeInitialization();
        this.documentParsedListeners = new ArrayList();
        this.jscx = JsContext.getInstance();
        this.fRhinoTreeParser = new RhinoTreeParser((IDocument)this);
    }

    public void addDocumentParsedListener(IDocumentParsedListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.documentParsedListeners.contains(listener)) {
            this.documentParsedListeners.add(listener);
        }
    }

    public void removeDocumentParsedListener(IDocumentParsedListener listener) {
        Assert.isNotNull((Object)listener);
        this.documentParsedListeners.remove(listener);
    }

    protected void fireDocumentParsed(DocumentParsedEvent event) {
        if (this.documentParsedListeners.size() > 0) {
            ArrayList list = new ArrayList(this.documentParsedListeners);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                IDocumentParsedListener l = (IDocumentParsedListener)it.next();
                l.documentWasParsed(event);
            }
        }
    }

    public void parseDocument() {
        this.parseAllDocument();
    }

    private void parseAllDocument() {
        new Date();
        this.jsdoc = new JsDocNode("document", new Position(0, this.getLength()));
        String text = this.get();
        String err = this.jscx.eval(text, true);
        if (err != null) {
            this.setError(err);
            this.tester = new HashMap();
            Matcher m = this.functions.matcher(text);
            this.addFunctions(m);
            m = this.backfunction.matcher(text);
            this.addFunctions(m);
        } else {
            ScriptOrFnNode tree = this.jscx.getParsingTree();
            this.fRhinoTreeParser.setJsDocNode(this.jsdoc);
            this.fRhinoTreeParser.createFromTree(tree);
        }
        this.appendComments();
        this.jsdoc.moveConstructorsToClasses();
        this.jsdoc.sortByPosition();
        DocumentParsedEvent dpe = new DocumentParsedEvent((IDocument)this);
        this.hasChanged = false;
        this.fireDocumentParsed(dpe);
    }

    private void appendComments() {
        try {
            ITypedRegion[] regions = this.computePartitioning(0, this.getLength());
            int single = 0;
            int singleOffset = -1;
            int singleLength = -1;
            int i = 0;
            while (i < regions.length) {
                ITypedRegion region = regions[i];
                String type = region.getType();
                if (type.equals("__javascript_singleline_comment")) {
                    int start = this.getLineOfOffset(region.getOffset());
                    int offset = this.getLineOffset(start);
                    if (offset == region.getOffset()) {
                        if (singleOffset == -1) {
                            singleOffset = offset;
                            singleLength = region.getLength();
                        } else {
                            singleLength += region.getLength();
                        }
                        ++single;
                    }
                } else {
                    Position p;
                    Region r;
                    Position p2;
                    if (single > 1 && (p2 = this.createProjectionPosition((IRegion)(r = new Region(singleOffset, singleLength)))) != null) {
                        Comment node = this.jsdoc.createComment(this.get(r.getOffset(), r.getLength()), p2);
                        this.jsdoc.addChild(node);
                    }
                    single = 0;
                    singleLength = -1;
                    singleOffset = -1;
                    if ((type.equals("__java_javadoc") || type.equals("__javascript_multiline_comment")) && (p = this.createProjectionPosition((IRegion)region)) != null) {
                        Comment node = this.jsdoc.createComment(this.get(region.getOffset(), region.getLength()), p);
                        this.jsdoc.addChild(node);
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private Position createProjectionPosition(IRegion region) {
        try {
            int start = this.getLineOfOffset(region.getOffset());
            int end = this.getLineOfOffset(region.getOffset() + region.getLength());
            if (start != end) {
                int offset = this.getLineOffset(start);
                int endOffset = this.getLineOffset(end);
                return new Position(offset, endOffset - offset);
            }
        }
        catch (BadLocationException x) {
            x.printStackTrace();
        }
        return null;
    }

    private void setError(String err) {
        Matcher l = this.lineNo.matcher(err);
        int lno = 1;
        if (l.find()) {
            String li = l.group(1);
            try {
                lno = Integer.parseInt(li);
                lno = this.getLineOffset(lno - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                lno = 1;
            }
        }
        Position p = new Position(lno, 0);
        Error jsn = this.jsdoc.createError(err, p);
        jsn.setImage(JsPluginImages.get("error.gif"));
        this.jsdoc.addChild(jsn);
    }

    private void addFunctions(Matcher m) {
        while (m.find()) {
            JsNode jsn;
            Position p;
            if (!TextUtilities.isPartition((IDocument)this, m.start(1), "__dftl_partition_content_type")) continue;
            if (this.tester.containsKey(m.group(1))) {
                p = new Position(m.start(1), 0);
                jsn = this.jsdoc.createError("Duplicate function '" + m.group(1) + "'", p);
                jsn.setImage(JsPluginImages.get("warning.gif"));
                this.jsdoc.addChild(jsn);
                continue;
            }
            this.tester.put(m.group(1), "");
            p = new Position(m.start(1), m.group(1).length());
            jsn = this.jsdoc.createNode(m.group(1), p);
            jsn.setImage(JsPluginImages.get("function.gif"));
            this.jsdoc.addChild(jsn);
        }
    }

    public synchronized JsDocNode getJsDocNode() {
        return this.jsdoc;
    }

    public void setJsDocNode(JsDocNode doc) {
        this.jsdoc = doc;
    }

    public List getChanges() {
        return this.changesQueue;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void resetChangedStatus() {
        this.hasChanged = false;
    }

    protected void doFireDocumentChanged2(DocumentEvent event) {
        super.doFireDocumentChanged2(event);
        this.changesQueue.add(event);
        this.hasChanged = true;
    }

    protected void fireDocumentPartitioningChanged(DocumentPartitioningChangedEvent event) {
        super.fireDocumentPartitioningChanged(event);
    }
}

