/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class JsMarkersFactory {
    public static String BREAKPOINT = "com.interaktonline.jseclipse.jsbreakpoint";
    private static JsMarkersFactory instance = new JsMarkersFactory();
    private IFile fFile;

    private JsMarkersFactory() {
    }

    public static JsMarkersFactory getInstance() {
        return instance;
    }

    public void setFile(IFile file) {
        this.fFile = file;
    }

    public String getResourceName() {
        return this.fFile.getName();
    }

    public void createMarker(Map attributes, String type) {
        try {
            MarkerUtilities.createMarker((IResource)this.fFile, (Map)attributes, (String)type);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IMarker createMarker(String type) {
        IMarker marker = null;
        try {
            marker = this.fFile.createMarker(type);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return marker;
    }

    public void deleteMarker(IMarker marker) {
        try {
            marker.delete();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void deleteAllMarkers(String type) {
        int depth = 2;
        try {
            this.fFile.deleteMarkers(type, true, depth);
        }
        catch (CoreException coreException) {}
    }

    public void deleteProblems() {
        this.deleteAllMarkers("org.eclipse.core.resources.problemmarker");
        this.deleteAllMarkers(BREAKPOINT);
    }

    public IMarker[] getMarkers(String type) {
        IMarker[] problems = null;
        int depth = 2;
        try {
            problems = this.fFile.findMarkers(type, true, depth);
        }
        catch (CoreException coreException) {}
        return problems;
    }

    public static boolean hasErrors(IFile file) {
        try {
            IMarker[] a = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            return a != null && a.length != 0;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }
}

