/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text;

import java.util.Arrays;

public class LanguageConstants {
    private static LanguageConstants instance;
    public static String[] jsConstants;
    public static String[] jskeywords;
    public static String[] jswords;

    static {
        jsConstants = new String[]{"false", "null", "true", "debugger"};
        jskeywords = new String[]{"function", "break", "prototype", "__proto__", "continue", "do", "for", "import", "new", "this", "void", "instanceof", "case", "default", "else", "function", "in", "return", "typeof", "throw", "try", "catch", "finally", "while", "comment", "delete", "export", "if", "label", "switch", "var", "with"};
        jswords = new String[]{"alert", "eval", "Link", "outerHeight", "scrollTo", "Anchor", "FileUpload", "location", "outerWidth", "Select", "Area", "find", "Location", "Packages", "self", "arguments", "focus", "locationbar", "pageXoffset", "setInterval", "Array", "Form", "Math", "pageYoffset", "setTimeout", "assign", "Frame", "menubar", "parent", "status", "blur", "frames", "MimeType", "parseFloat", "statusbar", "Boolean", "Function", "moveBy", "parseInt", "stop", "Button", "getClass", "moveTo", "Password", "String", "callee", "Hidden", "name", "personalbar", "Submit", "caller", "history", "NaN", "Plugin", "sun", "captureEvents", "History", "navigate", "print", "taint", "Checkbox", "home", "navigator", "prompt", "Text", "clearInterval", "Image", "Navigator", "Textarea", "clearTimeout", "Infinity", "netscape", "Radio", "toolbar", "close", "innerHeight", "Number", "ref", "top", "closed", "innerWidth", "Object", "RegExp", "toString", "confirm", "isFinite", "onBlur", "releaseEvents", "unescape", "constructor", "isNaN", "onError", "Reset", "untaint", "Date", "java", "onFocus", "resizeBy", "unwatch", "defaultStatus", "JavaArray", "onLoad", "resizeTo", "valueOf", "document", "JavaClass", "onUnload", "routeEvent", "watch", "Document", "JavaObject", "open", "scroll", "window", "Element", "JavaPackage", "opener", "scrollbars", "Window", "escape", "length", "Option", "scrollBy"};
    }

    private LanguageConstants() {
        Arrays.sort(jsConstants);
        Arrays.sort(jskeywords);
        Arrays.sort(jswords);
    }

    public static synchronized LanguageConstants getInstance() {
        if (instance == null) {
            instance = new LanguageConstants();
        }
        return instance;
    }

    public boolean isJsWord(String word) {
        if (Arrays.binarySearch(jsConstants, word) >= 0) {
            return true;
        }
        if (Arrays.binarySearch(jskeywords, word) >= 0) {
            return true;
        }
        return Arrays.binarySearch(jswords, word) >= 0;
    }
}

