/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class MultilineCommentAutoEditStrategy
implements IAutoEditStrategy {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean commentNotClosed(IDocument document, int offset) {
        int ix = offset;
        int end = document.getLength();
        try {
            while (true) {
                if (ix >= end) {
                    return true;
                }
                if (document.getChar(ix) == '*' && ix + 1 < end && document.getChar(ix + 1) == '/') {
                    return false;
                }
                if (document.getChar(ix) == '/' && ix + 1 < end) {
                    if (document.getChar(ix + 1) == '*') return true;
                    if (document.getChar(ix + 1) == '/') {
                        return true;
                    }
                }
                ++ix;
            }
        }
        catch (BadLocationException badLocationException) {}
        return true;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String text = command.text;
        if (text == null) {
            return;
        }
        if (text.matches("\\r\\n|\\r|\\n")) {
            int caretOffset = command.offset - command.length;
            try {
                IRegion line = document.getLineInformationOfOffset(caretOffset);
                StringBuffer sb = new StringBuffer();
                int ix = line.getOffset();
                int end = line.getOffset() + line.getLength();
                while (Character.isWhitespace(document.getChar(ix)) && ix < end) {
                    sb.append(document.getChar(ix++));
                }
                String closing = "";
                if (document.getChar(ix) == '/') {
                    sb.append(' ');
                    if (this.commentNotClosed(document, command.offset)) {
                        closing = String.valueOf(text) + sb.toString() + "*/";
                    }
                }
                command.text = text + sb + "* " + closing;
                command.length = 0;
                int jump = text.length() + sb.length() + 2;
                command.caretOffset = command.offset + jump;
                command.doit = true;
                command.owner = null;
                command.shiftsCaret = false;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

