/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text;

import com.interaktonline.jseclipse.text.JavascriptAutoEditStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;

public class StringAutoEditStrategy
extends JavascriptAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String text = command.text;
        if (text == null) {
            return;
        }
        if (text.matches("\\r\\n|\\r|\\n")) {
            int caretOffset = command.offset - command.length;
            try {
                ITypedRegion region = document.getPartition(caretOffset);
                char starter = document.getChar(region.getOffset());
                IRegion line = document.getLineInformationOfOffset(caretOffset);
                StringBuffer sb = new StringBuffer();
                int ix = line.getOffset();
                int end = line.getOffset() + line.getLength();
                while (Character.isWhitespace(document.getChar(ix)) && ix < end) {
                    sb.append(document.getChar(ix++));
                }
                if (document.getChar(ix) != starter) {
                    sb.append(indentString).append(indentString);
                }
                command.text = starter + " +" + text + sb + starter;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

