/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text.folding;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.editors.JsEditor;
import com.interaktonline.jseclipse.jsdom.JsDocNode;
import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.text.DocumentParsedEvent;
import com.interaktonline.jseclipse.text.IDocumentParsedListener;
import com.interaktonline.jseclipse.text.JsDocument;
import com.interaktonline.jseclipse.text.folding.IFoldingStructureProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSFoldingStructureProvider
implements IProjectionListener,
IFoldingStructureProvider,
IDocumentParsedListener {
    private ITextEditor fEditor;
    private ProjectionViewer fViewer;
    private IDocument fCachedDocument;
    private boolean fColapseComments = true;
    private boolean fColapseMethods = false;
    private List oldAnnotations = new ArrayList();
    private List newAnnotations = new ArrayList();
    static /* synthetic */ Class class$0;

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    private Map computeAdditions(JsNode node) {
        HashMap map = new HashMap();
        this.computeAdditions(node, map);
        return map;
    }

    private void computeAdditions(JsNode node, Map map) {
        if (node.getType() == JsNode.FUNCTION || node.getType() == JsNode.COMMENT || node.getType() == JsNode.METHOD) {
            JsProjectionAnnotation jpa = new JsProjectionAnnotation(node, node.getType() == JsNode.COMMENT && this.fColapseComments || node.getType() == JsNode.FUNCTION && this.fColapseMethods, false);
            map.put(jpa, node.getPosition());
            this.newAnnotations.add(jpa);
        } else if (node.hasChildrenExcluding(null)) {
            Iterator it = node.getChildNodes().iterator();
            while (it.hasNext()) {
                JsNode kid = (JsNode)it.next();
                this.computeAdditions(kid, map);
            }
        }
    }

    public void install(ITextEditor editor, ProjectionViewer viewer) {
        if (editor instanceof JsEditor) {
            this.fEditor = editor;
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            ((JsDocument)this.fCachedDocument).addDocumentParsedListener(this);
            this.fColapseComments = JavaScriptEditorPlugin.getDefault().getPreferenceStore().getBoolean("autofoldComments");
            this.fColapseMethods = JavaScriptEditorPlugin.getDefault().getPreferenceStore().getBoolean("autofoldMethods");
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        if (this.fEditor instanceof JsEditor) {
            this.initialize();
        }
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void documentWasParsed(DocumentParsedEvent event) {
        if (!this.isInstalled()) {
            return;
        }
        this.newAnnotations.clear();
        try {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            JsDocNode root = null;
            if (this.fCachedDocument instanceof JsDocument) {
                root = ((JsDocument)this.fCachedDocument).getJsDocNode();
            }
            if (root != null) {
                ProjectionAnnotationModel model;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                if ((model = (ProjectionAnnotationModel)this.fEditor.getAdapter((Class)clazz)) != null) {
                    Map additions = this.computeAdditions(root);
                    if (this.oldAnnotations == null || this.oldAnnotations.size() == 0) {
                        model.removeAllAnnotations();
                        model.replaceAnnotations(null, additions);
                        this.fColapseComments = false;
                        this.fColapseMethods = false;
                    } else {
                        this.modifyAnnotationModel(model, additions);
                    }
                    this.oldAnnotations.clear();
                    this.oldAnnotations.addAll(this.newAnnotations);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fCachedDocument = null;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fCachedDocument = null;
            return;
        }
    }

    private void modifyAnnotationModel(ProjectionAnnotationModel model, Map additions) {
        ArrayList<JsProjectionAnnotation> modifications = new ArrayList<JsProjectionAnnotation>();
        int i = 0;
        while (i < this.newAnnotations.size()) {
            JsProjectionAnnotation jpa = (JsProjectionAnnotation)((Object)this.newAnnotations.get(i));
            int[] ix = this.indexOf(jpa, this.oldAnnotations, 0);
            if (ix[0] != -1) {
                this.oldAnnotations.remove(ix[0]);
                additions.remove((Object)jpa);
            }
            if (ix[1] != -1) {
                this.oldAnnotations.remove(ix[1]);
                additions.remove((Object)jpa);
                modifications.add(jpa);
            }
            ++i;
        }
        Annotation[] dels = new Annotation[this.oldAnnotations.size()];
        i = 0;
        while (i < this.oldAnnotations.size()) {
            dels[i] = (Annotation)this.oldAnnotations.get(i);
            ++i;
        }
        Annotation[] mods = new Annotation[modifications.size()];
        i = 0;
        while (i < modifications.size()) {
            mods[i] = (Annotation)modifications.get(i);
            ++i;
        }
        model.modifyAnnotations(dels, additions, mods);
    }

    private int[] indexOf(JsProjectionAnnotation ann, List annotations, int from) {
        int[] ret = new int[]{-1, -1};
        int i = from;
        JsNode toSearch = ann.getNode();
        while (i < annotations.size()) {
            JsNode fromArr = ((JsProjectionAnnotation)((Object)annotations.get(i))).getNode();
            if (toSearch.getText().equals(fromArr.getText())) {
                ret[0] = i;
                return ret;
            }
            if (toSearch.getOffset() == fromArr.getOffset()) {
                ret[1] = i;
                return ret;
            }
            ++i;
        }
        return ret;
    }

    private static class JsProjectionAnnotation
    extends ProjectionAnnotation {
        private JsNode fNode;
        private boolean fIsComment;

        public JsProjectionAnnotation(JsNode node, boolean isCollapsed, boolean isComment) {
            super(isCollapsed);
            this.fIsComment = isComment;
            this.fNode = node;
        }

        public boolean isComment() {
            return this.fIsComment;
        }

        public void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }

        public JsNode getNode() {
            return this.fNode;
        }
    }
}

