/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text.interpreters;

import com.interaktonline.jseclipse.jsdom.Function;
import com.interaktonline.jseclipse.jsdom.JsDocNode;
import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.jsdom.Variable;
import com.interaktonline.jseclipse.util.JsPluginImages;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;

public class InterpreterCore {
    public static String NONE = "none";
    public static String OBJECTLIT = "objlit";
    private IDocument fDocument;
    private JsDocNode fDocNode;
    private int lineNo;
    private Map classes;
    private ScriptOrFnNode treeTop;

    public InterpreterCore(IDocument document, ScriptOrFnNode tree) {
        this.fDocument = document;
        this.treeTop = tree;
        this.classes = new HashMap();
    }

    public JsDocNode getFDocNode() {
        return this.fDocNode;
    }

    public void setFDocNode(JsDocNode docNode) {
        this.fDocNode = docNode;
    }

    JsNode processObjectLiteral(Node node) {
        Object propIds = node.getProp(12);
        Object[] propArr = null;
        int propIx = 0;
        if (propIds != null && propIds instanceof Object[]) {
            propArr = (Object[])propIds;
        }
        Position p = new Position(this.getLineOffset(this.lineNo), 0);
        JsNode classNode = this.fDocNode.createNode(OBJECTLIT, p);
        Node cursor = node.getFirstChild();
        while (cursor != null) {
            if (cursor.getType() == 105) {
                JsNode jsn = this.createFunctionNode(this.treeTop, cursor, null, false);
                classNode.addChild(jsn);
            } else {
                Variable var;
                int tmp;
                int lineno = this.lineNo;
                String name = "#" + this.getNodeTypeAsString(cursor.getType()) + propIx;
                if (propArr != null && propIx < propArr.length && (tmp = this.getLineForMember(name = propArr[propIx].toString(), lineno)) != -1) {
                    lineno = tmp;
                }
                if ((var = (Variable)classNode.getVarNode(name)) == null) {
                    var = this.createVariableNode(cursor, name, cursor, false, lineno);
                    classNode.addChild(var);
                }
            }
            ++propIx;
            cursor = cursor.getNext();
        }
        return classNode;
    }

    private Variable createVariableNode(Node node, String name, Node value, boolean isStatic, int lineno) {
        String valueString = this.getValueAsString(value, 0);
        int offset = this.getLineOffset(lineno - 1);
        Position p = new Position(offset, name.length());
        Variable varNode = this.fDocNode.createVariable(name, p);
        if (isStatic) {
            varNode.addModifier(JsNode.M_STATIC);
            varNode.setImage(JsPluginImages.get("static.gif"));
        } else {
            varNode.setImage(JsPluginImages.get("var.gif"));
        }
        if (node.getType() == 42) {
            varNode.setType(JsNode.THIS);
        } else {
            varNode.setType(JsNode.VARIABLE);
        }
        varNode.setLineno(lineno - 1);
        varNode.setValue(valueString);
        return varNode;
    }

    JsNode getClass(String className) {
        return (JsNode)this.classes.get(className);
    }

    void addClass(String className, JsNode classNode) {
        this.classes.put(className, classNode);
    }

    JsNode processPropRef(Node ref) {
        if (ref.getType() == 38) {
            return this.createClassNode(ref.getString());
        }
        if (ref.getType() == 33) {
            return this.processGetProp(ref);
        }
        return null;
    }

    JsNode processGetProp(Node node) {
        Node propRef = node.getFirstChild();
        Node propString = propRef.getNext();
        String propName = propString.getString();
        JsNode classNode = this.processPropRef(propRef);
        boolean assignToPrototype = propName.equals("prototype");
        if (!assignToPrototype) {
            JsNode cn = this.createClassNode(propName);
            if (classNode != null) {
                classNode.addChild(cn);
            } else {
                classNode = cn;
            }
        }
        return classNode;
    }

    public JsNode createClassNode(String className) {
        int offset = this.getLineOffset(this.lineNo - 1);
        Position p = new Position(offset, className.length());
        JsNode classNode = this.fDocNode.createNode(className, p);
        classNode.setImage(JsPluginImages.get("namespace.gif"));
        classNode.setType(JsNode.CLASS);
        classNode.setLineno(this.lineNo - 1);
        return classNode;
    }

    public JsNode createFunctionNode(ScriptOrFnNode ltreeTop, Node node, String name, boolean isStatic) {
        int fnIndex = node.getExistingIntProp(1);
        FunctionNode fn = ltreeTop.getFunctionNode(fnIndex);
        if (name == null) {
            name = fn.getFunctionName();
        }
        if (name.trim().length() == 0) {
            name = "anonymous";
        }
        int offset = this.getLineOffset(fn.getBaseLineno() - 1);
        int end = this.getLineOffset(fn.getEndLineno() - 1);
        int length = -1;
        length = end > offset ? end - offset : 0;
        Position lPosition = new Position(offset, length);
        Function jsn = null;
        jsn = this.fDocNode.createFunction(name, lPosition);
        if (isStatic) {
            jsn.addModifier(JsNode.M_STATIC);
        }
        jsn.setImage(JsPluginImages.get("function.gif"));
        jsn.setType(JsNode.FUNCTION);
        jsn.setLineno(fn.getBaseLineno() - 1);
        jsn.setDoc(this.getFunctionDocumentation(offset));
        int paramCount = fn.getParamCount();
        int i = 0;
        while (i < paramCount) {
            jsn.addParameter(fn.getParamOrVarName(i));
            ++i;
        }
        this.recCreateFromTree((ScriptOrFnNode)fn, (Node)fn, jsn);
        return jsn;
    }

    private JsNode recCreateFromTree(ScriptOrFnNode ltreeTop, Node n, JsNode rParent) {
        int storedLine = this.lineNo;
        Node cursor = n.getFirstChild();
        while (cursor != null) {
            if (cursor.getType() == 105) {
                JsNode jsn = this.createFunctionNode(ltreeTop, cursor, null, false);
                rParent.addChild(jsn);
            } else if (cursor.getType() == 129) {
                this.lineNo = cursor.getLineno();
                this.recCreateFromTree(ltreeTop, cursor, rParent);
            } else if (cursor.getType() == 118) {
                this.lineNo = cursor.getLineno();
            } else if (cursor.getType() == 34) {
                JsNode lthis = this.processThis(ltreeTop, cursor);
                if (lthis != null) {
                    rParent.addChild(lthis);
                }
            } else {
                this.recCreateFromTree(ltreeTop, cursor, rParent);
            }
            cursor = cursor.getNext();
        }
        this.lineNo = storedLine;
        return null;
    }

    JsNode processThis(ScriptOrFnNode ltreeTop, Node n) {
        Node propRef = n.getFirstChild();
        if (propRef.getType() != 42) {
            return null;
        }
        Node propString = propRef.getNext();
        String propName = propString.getString();
        Node propValue = propString.getNext();
        if (propValue.getType() == 105) {
            return this.createFunctionNode(ltreeTop, propValue, propName, false);
        }
        return this.createVariableNode(propRef, propName, propValue, false, this.lineNo);
    }

    String getArrayValueAsString(Node array) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        Node item = array.getFirstChild();
        while (item != null) {
            sb.append(this.getValueAsString(item, 0));
            item = item.getNext();
            if (item == null) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    String getValueAsString(Node value, int level) {
        String valueString = "";
        switch (value.getType()) {
            case 41: {
                valueString = "null";
                break;
            }
            case 38: {
                valueString = value.getString();
                break;
            }
            case 40: {
                if (level == 0) {
                    valueString = "\"" + value.getString() + "\"";
                    break;
                }
                valueString = value.getString();
                break;
            }
            case 39: {
                valueString = String.valueOf(value.getDouble());
                break;
            }
            case 43: {
                valueString = "false";
                break;
            }
            case 44: {
                valueString = "true";
                break;
            }
            case 63: {
                valueString = this.getArrayValueAsString(value);
                break;
            }
            case 30: {
                valueString = "new " + this.getValueAsString(value.getFirstChild(), level++) + "()";
                break;
            }
            case 64: {
                valueString = "{}";
                break;
            }
            case 33: {
                Node fkid = value.getFirstChild();
                valueString = String.valueOf(this.getValueAsString(fkid, level++)) + "." + this.getValueAsString(fkid.getNext(), level++);
                break;
            }
            case 37: {
                valueString = this.getValueAsString(value.getFirstChild(), level++);
            }
        }
        return valueString;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String getFunctionDocumentation(int offset) {
        int ix = offset - 1;
        int end = 0;
        try {
            while (Character.isWhitespace(this.fDocument.getChar(ix)) && ix > 0) {
                --ix;
            }
            if (this.fDocument.getChar(ix) == '/' && ix > 0 && this.fDocument.getChar(ix - 1) == '*') {
                end = ix;
                while (ix > 0) {
                    if (this.fDocument.getChar(ix) == '*' && this.fDocument.getChar(ix - 1) == '/') break;
                    --ix;
                }
                if (this.fDocument.getChar(ix) == '*' && this.fDocument.getChar(ix - 1) == '/') {
                    return this.fDocument.get(ix - 1, end - ix + 2);
                }
            } else {
                end = ix;
                boolean isDoc = false;
                while (true) {
                    IRegion line;
                    if ((line = this.fDocument.getLineInformationOfOffset(ix)) == null) {
                        return null;
                    }
                    ix = line.getOffset();
                    if (this.fDocument.getChar(ix) != '/' || this.fDocument.getChar(ix + 1) != '/') break;
                    --ix;
                    isDoc = true;
                }
                if (isDoc) {
                    return this.fDocument.get(ix, end - ix);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return null;
    }

    int getLineOffset(int plineno) {
        if (this.fDocument == null) {
            return 0;
        }
        try {
            return this.fDocument.getLineOffset(plineno);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private int getLineForMember(String name, int fromLine) {
        try {
            int offset = this.fDocument.getLineOffset(fromLine - 1);
            String text = this.fDocument.get();
            Pattern p = Pattern.compile(String.valueOf(name) + "\\s*:");
            Matcher m = p.matcher(text);
            if (m.find(offset)) {
                int ix = m.start();
                return this.fDocument.getLineOfOffset(ix) + 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    String getNodeTypeAsString(int type) {
        switch (type) {
            case 38: {
                return "NAME";
            }
            case 40: {
                return "STRING";
            }
            case 39: {
                return "NUMBER";
            }
            case 43: {
                return "BOOLEAN";
            }
            case 44: {
                return "BOOLEAN";
            }
            case 63: {
                return "ARRAY";
            }
            case 37: {
                return "CALL";
            }
        }
        return "#" + type;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }
}

