/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text.interpreters;

import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.text.interpreters.IJavaScriptInterpreter;
import com.interaktonline.jseclipse.text.interpreters.InterpreterCore;
import org.mozilla.javascript.Node;

public class PrototypeInterpreter
implements IJavaScriptInterpreter {
    private InterpreterCore core;
    private JsNode parent;
    private JsNode refClass;
    private static String PROTOTYPE_EXTEND_1_4 = "Object.extend";

    public PrototypeInterpreter(InterpreterCore interpreter) {
        this.core = interpreter;
    }

    public boolean interpret(Node node) {
        Node objectExtends = node.getFirstChild();
        String res = this.core.getValueAsString(node, 0);
        if (!res.equals(PROTOTYPE_EXTEND_1_4)) {
            return false;
        }
        this.parent = this.refClass = this.core.createClassNode(InterpreterCore.NONE);
        Node destination = objectExtends.getNext();
        Node source = destination.getNext();
        this.processDestination(destination);
        this.processSource(source);
        return true;
    }

    private void processSource(Node source) {
        if (source.getType() == 64) {
            JsNode classNode = this.core.processObjectLiteral(source);
            this.parent.setChildNodes(classNode.getChildNodes());
        } else if (source.getType() == 33) {
            Node first = source.getFirstChild();
            Node prot = first.getNext();
            if (prot.getType() == 40 && prot.getString().equals("prototype")) {
                String sourceStr = this.core.getValueAsString(first, 0);
                this.parent.setExtendsString(sourceStr);
            }
        } else {
            String sourceStr = this.core.getValueAsString(source, 0);
            this.parent.setExtendsString(sourceStr);
        }
    }

    private void processDestination(Node dest) {
        if (dest.getType() == 30) {
            Node ext = dest.getFirstChild();
            String extClass = this.core.getValueAsString(ext, 0);
            this.parent.setExtendsString(extClass);
        } else if (dest.getType() == 33 || dest.getType() == 38) {
            JsNode classNode;
            this.refClass = classNode = this.core.processPropRef(dest);
            this.parent = classNode;
            while (this.parent.hasChildrenExcluding(null)) {
                this.parent = this.parent.getChildNode(0);
            }
        } else if (dest.getType() == 37 && this.interpret(dest)) {
            JsNode obj = this.getGeneratedNode();
            if (obj.getText().equals(InterpreterCore.NONE)) {
                this.parent.mergeClass(obj);
            } else {
                this.parent.addClassNode(obj);
            }
            return;
        }
    }

    public JsNode getGeneratedNode() {
        return this.refClass;
    }
}

