/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.text.interpreters;

import com.interaktonline.jseclipse.jsdom.Function;
import com.interaktonline.jseclipse.jsdom.JsDocNode;
import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.jsdom.Variable;
import com.interaktonline.jseclipse.text.interpreters.IJavaScriptInterpreter;
import com.interaktonline.jseclipse.text.interpreters.InterpreterCore;
import com.interaktonline.jseclipse.text.interpreters.PrototypeInterpreter;
import com.interaktonline.jseclipse.util.JsPluginImages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptOrFnNode;

public class RhinoTreeParser {
    private static String JSECLIPSE_OBJECT = "js_eclipse_object";
    private static String PROTOTYPE_OBJECT = "Class.create";
    private static String PROTOTYPE_EXTEND_1_4 = "Object.extend";
    private static String DOJO_EXTEND = "dojo.lang.extend";
    private static String DOJO_W_EXTEND = "dojo.widget.defineWidget";
    private static String DOJO_DECLARE = "dojo.declare";
    private JsNode qooxdooParent = null;
    private IDocument fDocument;
    private JsDocNode fDocNode;
    private JsNode parent;
    private ScriptOrFnNode treeTop;
    private int lineno;
    private boolean assignToPrototype = false;
    private ArrayList references;
    private HashMap functions;
    private JsNode function;
    private List[] interpreters;
    private InterpreterCore core;

    public RhinoTreeParser(IDocument document) {
        this.fDocument = document;
        this.references = new ArrayList();
        this.functions = new HashMap();
        this.interpreters = new ArrayList[200];
    }

    public RhinoTreeParser() {
        this(null);
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void setJsDocNode(JsDocNode doc) {
        this.fDocNode = doc;
    }

    public void createFromTree(ScriptOrFnNode tree) {
        this.treeTop = tree;
        this.references.clear();
        this.functions.clear();
        this.core = new InterpreterCore(this.fDocument, tree);
        this.core.setFDocNode(this.fDocNode);
        this.addInterpreters();
        Node cursor = this.treeTop.getFirstChild();
        while (cursor != null) {
            this.parent = this.fDocNode;
            this.function = null;
            this.assignToPrototype = false;
            if (cursor.getType() == 105) {
                this.createFunctionNode(this.treeTop, cursor, null, true);
            } else if (cursor.getType() == 130) {
                this.lineno = cursor.getLineno();
                this.core.setLineNo(this.lineno);
                this.processExprResult(cursor);
            } else if (cursor.getType() == 118) {
                this.lineno = cursor.getLineno();
                this.core.setLineNo(this.lineno);
                this.processVar(cursor);
            } else if (cursor.getType() == 125) {
                this.processBlock(cursor);
            }
            cursor = cursor.getNext();
        }
        if (this.qooxdooParent != null) {
            this.resolveQxdReferences();
        } else {
            this.resolveReferences();
        }
        this.postProcessing(this.fDocNode);
    }

    private void addInterpreters() {
        ArrayList<PrototypeInterpreter> it = new ArrayList<PrototypeInterpreter>();
        it.add(new PrototypeInterpreter(this.core));
        this.interpreters[37] = it;
    }

    private void recCreateFromTree(ScriptOrFnNode ltreeTop, Node n, JsNode rParent) {
        int storedLine = this.lineno;
        Node cursor = n.getFirstChild();
        while (cursor != null) {
            JsNode lfunction = this.function;
            if (cursor.getType() == 105) {
                JsNode lparent = this.parent;
                this.parent = rParent;
                this.createFunctionNode(ltreeTop, cursor, null, false);
                this.parent = lparent;
            } else if (cursor.getType() == 129) {
                this.lineno = cursor.getLineno();
                this.recCreateFromTree(ltreeTop, cursor, rParent);
            } else if (cursor.getType() == 118) {
                this.lineno = cursor.getLineno();
            } else if (cursor.getType() == 34) {
                this.processThis(ltreeTop, cursor);
            } else {
                this.recCreateFromTree(ltreeTop, cursor, rParent);
            }
            this.function = lfunction;
            cursor = cursor.getNext();
        }
        this.lineno = storedLine;
    }

    private void postProcessing(JsNode node) {
        ArrayList kids = node.getChildNodes();
        int i = 0;
        while (i < kids.size()) {
            JsNode kid = (JsNode)kids.get(i);
            if (kid.getType() == JsNode.FUNCTION) {
                JsNode kidsParent;
                boolean isConstructor = false;
                JsNode theClass = node.getClassNode(kid.getText());
                if (theClass != null) {
                    isConstructor = true;
                    node.removeChild(kid);
                    theClass.addChild(kid);
                }
                if ((kidsParent = kid.getParent()).getType() == JsNode.CLASS) {
                    JsNode[] vars = kid.getVarNodes();
                    int j = 0;
                    while (j < vars.length) {
                        if (vars[j].getType() == JsNode.THIS) {
                            kid.removeChild(vars[j]);
                            kidsParent.addOrReplaceVarNode(vars[j], isConstructor);
                        }
                        ++j;
                    }
                }
            } else if (kid.getType() == JsNode.CLASS) {
                this.postProcessing(kid);
            }
            ++i;
        }
    }

    private void resolveReferences() {
        int i = 0;
        while (i < this.references.size()) {
            Variable var = (Variable)this.references.get(i);
            JsNode ref = (JsNode)this.functions.get(var.getValue());
            if (ref != null) {
                ref.getParent().removeChild(ref);
                ref.setText(var.getText());
                JsNode lparent = var.getParent();
                if (lparent != null) {
                    lparent.removeChild(var);
                    lparent.addChild(ref);
                }
            }
            ++i;
        }
    }

    private void resolveQxdReferences() {
        JsNode proto = this.fDocNode.getClassNode("proto");
        if (proto == null) {
            return;
        }
        ArrayList kids = proto.getChildNodes();
        int i = 0;
        while (i < kids.size()) {
            JsNode kid = (JsNode)kids.get(i);
            proto.removeChild(kid);
            if (kid.getType() == JsNode.CLASS) {
                ArrayList gkids = kid.getChildNodes();
                int j = 0;
                while (j < gkids.size()) {
                    JsNode gkid = (JsNode)gkids.get(j);
                    kid.removeChild(gkid);
                    this.qooxdooParent.addChild(gkid);
                    ++j;
                }
            } else {
                this.qooxdooParent.addChild(kid);
            }
            ++i;
        }
        this.fDocNode.removeChild(proto);
    }

    private void processBlock(Node n) {
        Node cursor = n.getFirstChild();
        while (cursor != null) {
            this.parent = this.fDocNode;
            this.function = null;
            this.assignToPrototype = false;
            if (cursor.getType() == 105) {
                this.createFunctionNode(this.treeTop, cursor, null, true);
            } else if (cursor.getType() == 130) {
                this.lineno = cursor.getLineno();
                this.core.setLineNo(this.lineno);
                this.processExprResult(cursor);
            } else if (cursor.getType() == 118) {
                this.lineno = cursor.getLineno();
                this.core.setLineNo(this.lineno);
                this.processVar(cursor);
            } else if (cursor.getType() == 125) {
                this.processBlock(cursor);
            }
            cursor = cursor.getNext();
        }
    }

    private void processVar(Node n) {
        Node kid = n.getFirstChild();
        if (kid.getType() == 38) {
            Node next = kid.getFirstChild();
            if (next == null) {
                return;
            }
            if (next.getType() == 64) {
                this.createClassNode(kid.getString());
                this.processObjectLiteral(next);
            } else if (next.getType() == 105) {
                this.createFunctionNode(this.treeTop, next, kid.getString(), false);
            } else if (next.getType() == 30) {
                Node nnext = next.getFirstChild();
                if (nnext.getType() == 105) {
                    this.createFunctionNode(this.treeTop, nnext, kid.getString(), false);
                } else {
                    this.createVariableNode(n, kid.getString(), next, true);
                }
            } else {
                this.createVariableNode(n, kid.getString(), next, true);
            }
        }
    }

    private void processExprResult(Node n) {
        Node kid = n.getFirstChild();
        switch (kid.getType()) {
            case 8: {
                this.processSetname(kid);
                break;
            }
            case 34: {
                this.processSetprop(kid);
                break;
            }
            case 66: {
                this.processSetref(kid);
                break;
            }
            case 37: {
                this.processCall("", kid);
            }
        }
    }

    private void processCall(String name, Node n) {
        if (this.interpreters[37] != null) {
            Iterator iter = this.interpreters[37].iterator();
            while (iter.hasNext()) {
                IJavaScriptInterpreter interpreter = (IJavaScriptInterpreter)iter.next();
                if (!interpreter.interpret(n)) continue;
                JsNode obj = interpreter.getGeneratedNode();
                if (obj.getText().equals(InterpreterCore.NONE)) {
                    this.parent.mergeClass(obj);
                } else {
                    this.parent.addClassNode(obj);
                }
                return;
            }
        }
        Node kid = n.getFirstChild();
        String res = this.getValueAsString(n, 0);
        if (res == null) {
            return;
        }
        if (res.equals(JSECLIPSE_OBJECT)) {
            this.createClassNode(name);
        } else if (res.equals(DOJO_EXTEND)) {
            Node object = kid.getNext();
            if (object.getType() == 33) {
                this.processGetProp(object);
            } else if (object.getType() == 38) {
                this.createClassNode(object.getString());
            } else {
                return;
            }
            this.processObjectLiteral(object.getNext());
        } else if (res.equals(DOJO_W_EXTEND)) {
            try {
                Node object = kid.getNext();
                if (object.getType() == 40) {
                    StringTokenizer st = new StringTokenizer(object.getString(), ".");
                    while (st.hasMoreTokens()) {
                        this.createClassNode(st.nextToken());
                    }
                } else {
                    return;
                }
                Node extends_w = object.getNext();
                if (extends_w == null) {
                    return;
                }
                this.parent.setExtendsString(this.getValueAsString(extends_w, 0));
                Node function_w = extends_w.getNext();
                if (function_w == null) {
                    return;
                }
                if (function_w.getNext() == null) {
                    return;
                }
                this.processObjectLiteral(function_w.getNext());
            }
            catch (Exception exception) {}
        } else if (res.equals(DOJO_DECLARE)) {
            try {
                Node object = kid.getNext();
                if (object.getType() == 40) {
                    StringTokenizer st = new StringTokenizer(object.getString(), ".");
                    while (st.hasMoreTokens()) {
                        this.createClassNode(st.nextToken());
                    }
                } else {
                    return;
                }
                Node extends_w = object.getNext();
                if (extends_w == null) {
                    return;
                }
                this.parent.setExtendsString(this.getValueAsString(extends_w, 0));
                if (extends_w.getNext() == null) {
                    return;
                }
                this.processObjectLiteral(extends_w.getNext());
            }
            catch (Exception exception) {}
        } else {
            Node next = kid.getNext();
            if (next == null) {
                return;
            }
            if (this.isPrototypeExtend(kid)) {
                if (next.getType() == 64) {
                    this.processObjectLiteral(next);
                } else if (next.getNext() != null && next.getNext().getType() == 64) {
                    this.processObjectLiteral(next.getNext());
                }
            } else if (this.isQooxdooExtend(kid)) {
                Node className = next.getNext();
                if (className == null || className.getType() != 40) {
                    return;
                }
                this.createClassNode(className.getString());
                this.parent.setExtendsString(next.getString());
                this.qooxdooParent = this.parent;
            }
        }
    }

    private boolean isPrototypeExtend(Node node) {
        String res = this.getValueAsString(node, 0);
        if (res.equals(PROTOTYPE_EXTEND_1_4)) {
            Node newNode = node.getNext();
            if (newNode == null) {
                return false;
            }
            if (newNode.getFirstChild() == null) {
                return false;
            }
            String parentClass = this.getValueAsString(newNode.getFirstChild(), 1);
            this.parent.setExtendsString(parentClass);
            return true;
        }
        Node kid = node.getFirstChild();
        if (kid == null) {
            return false;
        }
        Node end = kid.getNext();
        if (end != null && kid.getType() == 30 && end.getString().equals("extend")) {
            String parentClass = this.getValueAsString(kid.getFirstChild(), 1);
            this.parent.setExtendsString(parentClass);
            return true;
        }
        return false;
    }

    private boolean isQooxdooExtend(Node node) {
        Node kid = node.getFirstChild();
        if (kid == null) {
            return false;
        }
        Node extend = kid.getNext();
        return extend != null && extend.getType() == 40 && extend.getString().equals("extend");
    }

    private void processSetref(Node n) {
        Node kid = n.getFirstChild();
        if (kid.getType() == 69) {
            Node kkid = kid.getFirstChild();
            if (kkid.getType() != 33) {
                return;
            }
            this.processGetProp(kkid);
            kkid = kid.getNext();
            if (kkid.getType() == 33 && (kkid = kkid.getFirstChild()).getType() == 38) {
                this.parent.setExtendsString(kkid.getString());
            }
        }
    }

    private void processSetname(Node n) {
        Node kid = n.getFirstChild();
        if (kid.getType() == 48) {
            Node next = kid.getNext();
            if (next.getType() == 105) {
                this.createFunctionNode(this.treeTop, next, kid.getString(), true);
            } else if (next.getType() == 64) {
                this.createClassNode(kid.getString());
                this.processObjectLiteral(next);
            } else if (next.getType() == 37) {
                this.processCall(kid.getString(), next);
            }
        }
    }

    private void processThis(ScriptOrFnNode ltreeTop, Node n) {
        Node propRef = n.getFirstChild();
        if (propRef.getType() != 42) {
            return;
        }
        Node propString = propRef.getNext();
        String propName = propString.getString();
        Node propValue = propString.getNext();
        this.parent = this.function.getParent();
        if (propValue.getType() == 105) {
            this.createClassNodeFromFunction();
            JsNode lfunction = this.function;
            this.createFunctionNode(ltreeTop, propValue, propName, false);
            this.function = lfunction;
        } else {
            if (this.function.hasModifier(JsNode.M_STATIC)) {
                this.createClassNodeFromFunction();
            }
            this.createVariableNode(propRef, propName, propValue, false);
        }
        this.parent = this.parent.getParent();
    }

    private void processSetprop(Node n) {
        Node propRef = n.getFirstChild();
        Node propString = propRef.getNext();
        String propName = propString.getString();
        Node propValue = propString.getNext();
        this.processPropRef(propRef);
        if (propValue.getType() == 105) {
            this.createFunctionNode(this.treeTop, propValue, propName, !this.assignToPrototype);
        } else if (propValue.getType() == 64) {
            this.assignToPrototype = propName.equals("prototype");
            if (!this.assignToPrototype) {
                this.createClassNode(propName);
            }
            this.processObjectLiteral(propValue);
        } else if (propValue.getType() == 37) {
            if (propValue.getFirstChild().getType() == 105) {
                this.createFunctionNode(this.treeTop, propValue.getFirstChild(), propName, !this.assignToPrototype);
            } else {
                this.assignToPrototype = propName.equals("prototype");
                if (this.assignToPrototype) {
                    this.processCall("", propValue);
                }
            }
        } else if (propValue.getType() == 30) {
            if (propName.equals("prototype")) {
                Node kid = propValue.getFirstChild();
                if (kid.getType() == 38) {
                    this.parent.setExtendsString(kid.getString());
                } else if (kid.getType() == 33) {
                    this.parent.setExtendsString(this.getPropString(kid));
                }
            } else {
                Node kid = propValue.getFirstChild();
                if (kid.getType() == 105) {
                    this.createFunctionNode(this.treeTop, kid, propName, !this.assignToPrototype);
                }
            }
        } else if (propValue.getType() == 38) {
            JsNode varNode = this.createVariableNode(n, propName, propValue, false);
            if (varNode != null) {
                this.references.add(varNode);
            }
        } else if (propRef.getType() == 38) {
            this.createVariableNode(n, propName, propValue, true);
        }
    }

    private String getPropString(Node node) {
        Node propRef = node.getFirstChild();
        Node propString = propRef.getNext();
        String propName = propString.getString();
        String refString = null;
        refString = propRef.getType() == 38 ? propRef.getString() : this.getPropString(propRef);
        return String.valueOf(refString) + "." + propName;
    }

    private void processGetProp(Node node) {
        Node propRef = node.getFirstChild();
        Node propString = propRef.getNext();
        String propName = propString.getString();
        this.processPropRef(propRef);
        this.assignToPrototype = propName.equals("prototype");
        if (!this.assignToPrototype) {
            this.createClassNode(propName);
        }
    }

    private void processPropRef(Node ref) {
        if (ref.getType() == 38) {
            this.createClassNode(ref.getString());
        } else if (ref.getType() == 33) {
            this.processGetProp(ref);
        }
    }

    private void processObjectLiteral(Node node) {
        Object propIds = node.getProp(12);
        Object[] propArr = null;
        int propIx = 0;
        if (propIds != null && propIds instanceof Object[]) {
            propArr = (Object[])propIds;
        }
        Node cursor = node.getFirstChild();
        while (cursor != null) {
            if (cursor.getType() == 105) {
                JsNode lparent = this.parent;
                this.createFunctionNode(this.treeTop, cursor, null, false);
                this.parent = lparent;
            } else {
                int tmp;
                int lline = this.lineno;
                String name = "#" + this.getNodeTypeAsString(cursor.getType()) + propIx;
                if (propArr != null && propIx < propArr.length && (tmp = this.getLineForMember(name = propArr[propIx].toString(), this.lineno)) != -1) {
                    this.lineno = tmp;
                }
                JsNode lfunction = this.function;
                this.function = null;
                this.createVariableNode(cursor, name, cursor, false);
                this.function = lfunction;
                this.lineno = lline;
            }
            ++propIx;
            cursor = cursor.getNext();
        }
    }

    private String getArrayValueAsString(Node array) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        Node item = array.getFirstChild();
        while (item != null) {
            sb.append(this.getValueAsString(item, 0));
            item = item.getNext();
            if (item == null) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    private String getValueAsString(Node value, int level) {
        String valueString = "";
        switch (value.getType()) {
            case 41: {
                valueString = "null";
                break;
            }
            case 38: {
                valueString = value.getString();
                break;
            }
            case 40: {
                if (level == 0) {
                    valueString = "\"" + value.getString() + "\"";
                    break;
                }
                valueString = value.getString();
                break;
            }
            case 39: {
                valueString = String.valueOf(value.getDouble());
                break;
            }
            case 43: {
                valueString = "false";
                break;
            }
            case 44: {
                valueString = "true";
                break;
            }
            case 63: {
                valueString = this.getArrayValueAsString(value);
                break;
            }
            case 30: {
                valueString = "new " + this.getValueAsString(value.getFirstChild(), level++) + "()";
                break;
            }
            case 64: {
                valueString = "{}";
                break;
            }
            case 47: {
                valueString = null;
                break;
            }
            case 33: {
                Node fkid = value.getFirstChild();
                valueString = String.valueOf(this.getValueAsString(fkid, level++)) + "." + this.getValueAsString(fkid.getNext(), level++);
                break;
            }
            case 37: {
                valueString = this.getValueAsString(value.getFirstChild(), level++);
                if (!PROTOTYPE_OBJECT.equals(valueString)) break;
                valueString = JSECLIPSE_OBJECT;
                break;
            }
            default: {
                valueString = null;
            }
        }
        return valueString;
    }

    private JsNode createVariableNode(Node node, String name, Node value, boolean isStatic) {
        Variable varNode = (Variable)this.parent.getVarNode(name);
        String valueString = this.getValueAsString(value, 0);
        if (valueString != null && valueString.equals(JSECLIPSE_OBJECT)) {
            this.createClassNode(name);
            return null;
        }
        int offset = this.getLineOffset(this.lineno - 1);
        Position p = new Position(offset, name.length());
        if (varNode == null) {
            varNode = this.fDocNode.createVariable(name, p);
            if (isStatic) {
                varNode.addModifier(JsNode.M_STATIC);
                varNode.setImage(JsPluginImages.get("static.gif"));
            } else {
                varNode.setImage(JsPluginImages.get("var.gif"));
            }
            if (node.getType() == 42) {
                varNode.setType(JsNode.THIS);
            } else {
                varNode.setType(JsNode.VARIABLE);
            }
            varNode.setLineno(this.lineno - 1);
            if (this.function == null) {
                this.parent.addVarNode(varNode);
            } else {
                this.function.addVarNode(varNode);
            }
        }
        if (varNode.getValue() == null) {
            varNode.setValue(valueString);
        }
        return varNode;
    }

    private void createFunctionNode(ScriptOrFnNode ltreeTop, Node node, String name, boolean isStatic) {
        int fnIndex = node.getExistingIntProp(1);
        FunctionNode fn = ltreeTop.getFunctionNode(fnIndex);
        if (name == null && (name = fn.getFunctionName()).trim().length() != 0 && this.parent instanceof Function) {
            this.transformFunctionParentToClass();
        }
        if (name.trim().length() == 0) {
            name = "anonymous";
        }
        int offset = this.getLineOffset(fn.getBaseLineno() - 1);
        int end = this.getLineOffset(fn.getEndLineno() - 1);
        int length = -1;
        length = end > offset ? end - offset : 0;
        Position lPosition = new Position(offset, length);
        Function jsn = null;
        jsn = this.fDocNode.createFunction(name, lPosition);
        if (isStatic) {
            jsn.addModifier(JsNode.M_STATIC);
        }
        jsn.setImage(JsPluginImages.get("function.gif"));
        jsn.setType(JsNode.FUNCTION);
        jsn.setLineno(fn.getBaseLineno() - 1);
        jsn.setDoc(this.getFunctionDocumentation(offset));
        int paramCount = fn.getParamCount();
        int i = 0;
        while (i < paramCount) {
            jsn.addParameter(fn.getParamOrVarName(i));
            ++i;
        }
        this.parent.addChild(jsn);
        this.functions.put(name, jsn);
        this.function = jsn;
        this.recCreateFromTree((ScriptOrFnNode)fn, (Node)fn, this.function);
    }

    private int getLineForMember(String name, int fromLine) {
        try {
            int offset = this.fDocument.getLineOffset(fromLine - 1);
            String text = this.fDocument.get();
            Pattern p = Pattern.compile(String.valueOf(name) + "\\s*:");
            Matcher m = p.matcher(text);
            if (m.find(offset)) {
                int ix = m.start();
                return this.fDocument.getLineOfOffset(ix) + 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getFunctionDocumentation(int offset) {
        int ix = offset - 1;
        int end = 0;
        try {
            while (Character.isWhitespace(this.fDocument.getChar(ix)) && ix > 0) {
                --ix;
            }
            if (this.fDocument.getChar(ix) == '/' && ix > 0 && this.fDocument.getChar(ix - 1) == '*') {
                end = ix;
                while (ix > 0) {
                    if (this.fDocument.getChar(ix) == '*' && this.fDocument.getChar(ix - 1) == '/') break;
                    --ix;
                }
                if (this.fDocument.getChar(ix) == '*' && this.fDocument.getChar(ix - 1) == '/') {
                    return this.fDocument.get(ix - 1, end - ix + 2);
                }
            } else {
                end = ix;
                boolean isDoc = false;
                while (true) {
                    IRegion line;
                    if ((line = this.fDocument.getLineInformationOfOffset(ix)) == null) {
                        return null;
                    }
                    ix = line.getOffset();
                    if (this.fDocument.getChar(ix) != '/' || this.fDocument.getChar(ix + 1) != '/') break;
                    --ix;
                    isDoc = true;
                }
                if (isDoc) {
                    return this.fDocument.get(ix, end - ix);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return null;
    }

    private void createClassNode(String className) {
        if (this.parent.getText().equals(className)) {
            return;
        }
        JsNode classNode = this.parent.getClassNode(className);
        if (classNode == null) {
            int offset = this.getLineOffset(this.lineno - 1);
            Position p = new Position(offset, className.length());
            classNode = this.fDocNode.createNode(className, p);
            classNode.setImage(JsPluginImages.get("namespace.gif"));
            classNode.setType(JsNode.CLASS);
            classNode.setLineno(this.lineno - 1);
            this.parent.addClassNode(classNode);
        }
        this.parent = classNode;
    }

    private void transformFunctionParentToClass() {
        JsNode lParent = this.parent;
        this.parent = this.parent.getParent();
        String newClass = lParent.getText();
        this.createClassNode(newClass);
        this.parent.setLineno(lParent.getLineno());
        this.parent.setOffset(lParent.getOffset());
        lParent.getParent().removeChild(lParent);
        this.parent.addChild(lParent);
        lParent.removeModifier(JsNode.M_STATIC);
    }

    private void createClassNodeFromFunction() {
        String newClass = this.function.getText();
        this.createClassNode(newClass);
        if (this.function.getParent() != this.parent) {
            this.parent.setLineno(this.function.getLineno());
            this.parent.setOffset(this.function.getOffset());
            this.function.getParent().removeChild(this.function);
            this.parent.addChild(this.function);
            this.function.removeModifier(JsNode.M_STATIC);
        }
    }

    private int getLineOffset(int plineno) {
        if (this.fDocument == null) {
            return 0;
        }
        try {
            return this.fDocument.getLineOffset(plineno);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private String getNodeTypeAsString(int type) {
        switch (type) {
            case 38: {
                return "NAME";
            }
            case 40: {
                return "STRING";
            }
            case 39: {
                return "NUMBER";
            }
            case 43: {
                return "BOOLEAN";
            }
            case 44: {
                return "BOOLEAN";
            }
            case 63: {
                return "ARRAY";
            }
        }
        return "";
    }
}

