/*
 * Decompiled with CFR 0.152.
 */
package com.interaktonline.jseclipse.views.contentoutline;

import com.interaktonline.jseclipse.JavaScriptEditorPlugin;
import com.interaktonline.jseclipse.editors.JsEditor;
import com.interaktonline.jseclipse.jsdom.JsDocNode;
import com.interaktonline.jseclipse.jsdom.JsNode;
import com.interaktonline.jseclipse.text.DocumentParsedEvent;
import com.interaktonline.jseclipse.text.IDocumentParsedListener;
import com.interaktonline.jseclipse.text.JsDocument;
import com.interaktonline.jseclipse.text.JsMarkersFactory;
import com.interaktonline.jseclipse.views.contentoutline.ContentProvider;
import com.interaktonline.jseclipse.views.contentoutline.ExpandFirstLevelAction;
import com.interaktonline.jseclipse.views.contentoutline.HideVariablesAction;
import com.interaktonline.jseclipse.views.contentoutline.JsLabelProvider;
import com.interaktonline.jseclipse.views.contentoutline.ToggleSortAction;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;

public class JsContentOutlineView
extends ContentOutlinePage
implements IDocumentParsedListener,
IPartListener {
    private TextEditor editor;
    protected LabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private boolean isTreeCreated = false;
    private ViewerSorter fSorter;
    private ViewerSorter fDefaultSorter;
    private ViewerFilter fHideFields;
    private static Button non_commercial;
    private Composite theParent;
    private boolean ignoreSelection = false;
    private JsNode oldNodeSelection;
    private IPreferenceStore fstore;
    static /* synthetic */ Class class$0;

    public JsContentOutlineView(TextEditor editor) {
        this.editor = editor;
        this.fstore = JavaScriptEditorPlugin.getDefault().getPreferenceStore();
    }

    public void setInput(IEditorInput input) {
    }

    public Control getControl() {
        return this.getTreeViewer().getControl();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().addFilter((ViewerFilter)new JsHideComments());
        IPageSite site = this.getSite();
        IToolBarManager tbm = site.getActionBars().getToolBarManager();
        tbm.add((IAction)new HideVariablesAction(this));
        tbm.add((IAction)new ExpandFirstLevelAction(this));
        tbm.add((IAction)new ToggleSortAction(this));
        if (!this.isTreeCreated) {
            this.getTreeViewer().setUseHashlookup(true);
            this.createTree();
            this.isTreeCreated = true;
        }
    }

    private void createNoncommercialButton() {
        if (this.theParent.isDisposed()) {
            return;
        }
        non_commercial = new Button(this.theParent, 0x1000000);
        non_commercial.setText("Non-Commercial JSEclipse");
        GridData gd = new GridData(768);
        non_commercial.setLayoutData((Object)gd);
        non_commercial.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchBrowserSupport br = dwindow.getWorkbench().getBrowserSupport();
                try {
                    URL url = new URL("http://www.interaktonline.com/Products/Eclipse/JSEclipse/Buy/?from=eclipse");
                    IWebBrowser browser = br.getExternalBrowser();
                    browser.openURL(url);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createTree() {
        this.reload();
        this.setSort(this.isSort());
    }

    public void reload(JsDocNode root) {
        if (this.contentProvider == null) {
            this.contentProvider = new ContentProvider(root);
            this.getTreeViewer().setContentProvider((IContentProvider)this.contentProvider);
        }
        if (this.labelProvider == null) {
            this.labelProvider = new JsLabelProvider();
            this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        if (this.getTreeViewer().getContentProvider() != null) {
            this.getTreeViewer().setInput((Object)root);
        }
    }

    public void reload() {
        JsDocNode di = this.getJsDocument();
        this.reload(di);
    }

    public JsDocNode getJsDocument() {
        try {
            JsDocNode doc = null;
            IEditorPart iep = this.getSite().getPage().getActiveEditor();
            this.getSite().getPage().addPartListener((IPartListener)this);
            ITextEditor ite = (ITextEditor)iep;
            JsDocument jsdoc = (JsDocument)ite.getDocumentProvider().getDocument((Object)iep.getEditorInput());
            if (jsdoc == null) {
                return this.createFakeRoot();
            }
            jsdoc.addDocumentParsedListener(this);
            doc = jsdoc.getJsDocNode();
            if (doc != null) {
                return doc;
            }
            return this.createFakeRoot();
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.createFakeRoot();
        }
    }

    private JsDocNode createFakeRoot() {
        JsDocNode doc = new JsDocNode("Can not parse the documet.", new Position(0, 0));
        return doc;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (this.ignoreSelection) {
            this.ignoreSelection = false;
            return;
        }
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.editor.resetHighlightRange();
        } else {
            JsNode segment = (JsNode)((IStructuredSelection)selection).getFirstElement();
            int start = segment.getOffset();
            int length = segment.getTextLength();
            try {
                this.editor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.editor.resetHighlightRange();
            }
        }
    }

    public void documentWasParsed(DocumentParsedEvent event) {
        if (this.getTreeViewer().getTree().isDisposed()) {
            return;
        }
        JsDocument jsdoc = (JsDocument)event.getDocument();
        JsNode oldDoc = (JsNode)this.getTreeViewer().getInput();
        if (oldDoc != null && oldDoc.getChildNodes().size() != 0) {
            IFile theFile;
            IEditorInput iEditorInput = this.editor.getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (JsMarkersFactory.hasErrors(theFile = (IFile)iEditorInput.getAdapter((Class)clazz))) {
                jsdoc.setJsDocNode((JsDocNode)oldDoc);
                return;
            }
        }
        JsDocNode doc = jsdoc.getJsDocNode();
        Object[] fExpanded = this.getTreeViewer().getExpandedElements();
        ArrayList<Object> arr = new ArrayList<Object>(fExpanded.length);
        int i = 0;
        while (i < fExpanded.length) {
            arr.add(fExpanded[i]);
            ++i;
        }
        ISelection oldSelection = this.getTreeViewer().getSelection();
        this.oldNodeSelection = null;
        this.oldNodeSelection = !oldSelection.isEmpty() ? (JsNode)((IStructuredSelection)oldSelection).getFirstElement() : null;
        if (this.getTreeViewer().getContentProvider() != null) {
            this.update(doc, event);
        }
        if (this.isExpand()) {
            this.getTreeViewer().expandToLevel(2);
        }
    }

    private void update(JsNode doc, DocumentParsedEvent event) {
        JsNode oldDoc = (JsNode)this.getTreeViewer().getInput();
        this.merge(oldDoc, doc);
    }

    private void merge(JsNode oldNode, JsNode newNode) {
        if (!oldNode.getText().equals(newNode.getText())) {
            oldNode.setText(newNode.getText());
            this.getTreeViewer().update((Object)oldNode, null);
        }
        if (oldNode.getOffset() != newNode.getOffset()) {
            oldNode.setOffset(newNode.getOffset());
        }
        ArrayList kids = oldNode.getChildNodes();
        ArrayList newKids = newNode.getChildNodes();
        Diff diff = new Diff((Collection)kids, (Collection)newKids, (Comparator)new JsNode.TextComparator());
        List diffOut = diff.diff();
        int offset = 0;
        int oldDif = 0;
        int newDif = 0;
        boolean mustSelect = false;
        int i = 0;
        while (i < diffOut.size()) {
            int astart;
            Difference dif = (Difference)diffOut.get(i);
            int dstart = dif.getDeletedStart() + offset;
            int j = oldDif;
            while (j < dstart) {
                JsNode node = (JsNode)kids.get(j);
                if (node.hasChildrenExcluding(null)) {
                    JsNode nn = (JsNode)newKids.get(newDif);
                    this.merge(node, nn);
                }
                ++newDif;
                ++j;
            }
            if (dif.getDeletedEnd() != -1) {
                int dend;
                int j2 = dend = dif.getDeletedEnd() + offset;
                while (j2 >= dstart) {
                    JsNode node = (JsNode)oldNode.removeChild(j2);
                    if (node.equals(this.oldNodeSelection)) {
                        mustSelect = true;
                    }
                    this.getTreeViewer().remove((Object)node);
                    --j2;
                }
            }
            newDif = astart = dif.getAddedStart();
            if (dif.getAddedEnd() != -1) {
                int aend = dif.getAddedEnd();
                newDif = aend + 1;
                int j3 = astart;
                while (j3 <= aend) {
                    JsNode newKid = (JsNode)newKids.get(j3);
                    oldNode.addChild(newKid, dstart);
                    this.getTreeViewer().add((Object)oldNode, (Object)newKid);
                    if (mustSelect) {
                        this.ignoreSelection = true;
                        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newKid));
                        mustSelect = false;
                    }
                    ++dstart;
                    ++offset;
                    ++j3;
                }
            }
            oldDif = dstart;
            ++i;
        }
        i = oldDif;
        while (i < kids.size()) {
            JsNode node = (JsNode)kids.get(i);
            if (node.hasChildrenExcluding(null)) {
                JsNode nn = (JsNode)newKids.get(newDif);
                this.merge(node, nn);
            }
            ++newDif;
            ++i;
        }
    }

    protected void hideFields(boolean hide) {
        boolean fHide = hide;
        this.fstore.setValue("contentOutlineHideVars", fHide);
        if (fHide) {
            if (this.fHideFields == null) {
                this.fHideFields = new JsHideProperties();
            }
            this.getTreeViewer().addFilter(this.fHideFields);
        } else {
            this.getTreeViewer().removeFilter(this.fHideFields);
        }
    }

    protected boolean isHide() {
        return this.fstore.getBoolean("contentOutlineHideVars");
    }

    protected void setSort(boolean sort) {
        boolean fSort = sort;
        this.fstore.setValue("contentOutlineSort", fSort);
        if (sort) {
            if (this.fSorter == null) {
                this.fSorter = new JsOutlineSorter();
            }
            this.getTreeViewer().setSorter(this.fSorter);
        } else {
            if (this.fDefaultSorter == null) {
                this.fDefaultSorter = new JsDefaultOutlineSorter();
            }
            this.getTreeViewer().setSorter(this.fDefaultSorter);
        }
    }

    protected boolean isSort() {
        return this.fstore.getBoolean("contentOutlineSort");
    }

    protected boolean isExpand() {
        return this.fstore.getBoolean("contentOutlineExpand");
    }

    protected void setExpand(boolean expand) {
        boolean fExpand = expand;
        this.fstore.setValue("contentOutlineExpand", fExpand);
        if (fExpand) {
            this.getTreeViewer().expandToLevel(2);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (non_commercial == null) {
            return;
        }
        if (this.theParent.isDisposed()) {
            return;
        }
        if (part instanceof ITextEditor) {
            if (part instanceof JsEditor) {
                if (non_commercial.isDisposed()) {
                    this.createNoncommercialButton();
                    this.theParent.layout();
                }
            } else {
                non_commercial.dispose();
                this.theParent.layout();
            }
        }
    }

    public void partClosed(IWorkbenchPart part) {
        this.contentProvider = null;
        this.labelProvider = null;
        this.isTreeCreated = false;
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void update() {
        this.getControl().setRedraw(false);
        this.getTreeViewer().setInput((Object)this.getJsDocument());
        this.getTreeViewer().expandToLevel(2);
        this.getControl().setRedraw(true);
    }

    private class JsOutlineSorter
    extends ViewerSorter {
        private JsOutlineSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof JsNode) || !(e2 instanceof JsNode)) {
                return super.compare(viewer, e1, e2);
            }
            JsNode n1 = (JsNode)e1;
            JsNode n2 = (JsNode)e2;
            int type = n1.getType() - n2.getType();
            if (type != 0) {
                return type;
            }
            String name1 = ((JsNode)e1).getText();
            String name2 = ((JsNode)e2).getText();
            return this.getCollator().compare(name1, name2);
        }
    }

    private class JsDefaultOutlineSorter
    extends ViewerSorter {
        private JsDefaultOutlineSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof JsNode) || !(e2 instanceof JsNode)) {
                return super.compare(viewer, e1, e2);
            }
            JsNode n1 = (JsNode)e1;
            JsNode n2 = (JsNode)e2;
            return n1.getType() - n2.getType();
        }
    }

    private class JsHideProperties
    extends ViewerFilter {
        private JsHideProperties() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof JsNode)) {
                return false;
            }
            JsNode node = (JsNode)element;
            return node.getType() != JsNode.VARIABLE && node.getType() != JsNode.THIS;
        }
    }

    private class JsHideComments
    extends ViewerFilter {
        private JsHideComments() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof JsNode)) {
                return false;
            }
            JsNode node = (JsNode)element;
            return node.getType() != JsNode.COMMENT;
        }
    }
}

