package se.kth.math;

public class Interval {

	private double left;
	private double right;

	/**
	 * Creates an interval with endpoints left and right
	 * @param left
	 * @param right
	 * @throws IllegalArgumentException if right is smaller than left
	 */
	public Interval(double left, double right) {
		if (left > right) {
			throw new IllegalArgumentException("The left endpoint must be smaller than the right endpoint");
		}
		this.left = left;
		this.right = right;
	}
	
	public double getMidpoint() {
		return (left + right)/2;
	}
	
	public Interval getLeftHalfInterval() {
		return new Interval(left, getMidpoint());
	}

	public Interval getRightHalfInterval() {
		return new Interval(getMidpoint(), right);
	}
	
	public double length() {
		return right - left;
	}
	
	public double getLeftEndpoint() {
		return left;
	}
	
	public double getRightEndpoint() {
		return right;
	}
}
