package se.kth.math;

public class ValueInBetweenSolver {

	private OneVariableFunction function;
	
	public ValueInBetweenSolver(OneVariableFunction function) {
		this.function = function;
	}
	
	/**
	 * Finds the solution of the equation f(x)=value, where value is in between f(a) and f(b). Here f denotes the 
	 * {@link OneVariableFunction}, a the left endpoint of the {@link Interval} and b the right endpoint of the {@link Interval}.
	 * 
	 * @param value
	 * @param errorSize The size of accepted error
	 * @param interval
	 * @return the solution
	 * @throws IllegalArgumentException if value is not in between f(a) and f(b).
	 */
	public double solve(double value, double errorSize, Interval interval) {
		if (!isValueInBetween(interval, value)) {
			throw new IllegalArgumentException("The equation can not be solved with this method. Change the value.");
		}
		if (interval.length()/2 < errorSize) {
			return interval.getMidpoint();
		}
		if (isSolutionInTheRightIntervall(interval, value)) {
			System.out.print("R");
			return solve(value, errorSize, interval.getRightHalfInterval());
		} else {
			System.out.print("L");
			return solve(value, errorSize, interval.getLeftHalfInterval());
		}
	}
	
	private boolean isSolutionInTheRightIntervall(Interval interval, double value) {
		Interval rightInterval = new Interval(interval.getMidpoint(), interval.getRightEndpoint());
		return isValueInBetween(rightInterval, value);
	}

	private boolean isValueInBetween(Interval interval, double value) {
		double bound1 = function.getValue(interval.getLeftEndpoint());
		double bound2 = function.getValue(interval.getRightEndpoint());
		if (bound1 < bound2) {
			return ((bound1 <= value) && (value <= bound2));
		}
		return ((bound2 <= value) && (value <= bound1));
	}
		
}
