package se.kth.math;

import junit.framework.Assert;

import org.junit.Test;

public class ValueInBetweenSolverTest {

	private ValueInBetweenSolver valueInBetweenSolver;
	
	@Test
	public void testWithASin() {
		valueInBetweenSolver = new ValueInBetweenSolver(new OneVariableFunction() {
			
			public double getValue(double x) {
				return Math.sin(x);
			}
			
		});
		double errorSize = 0.001;
		double solution = valueInBetweenSolver.solve(0.3, errorSize, new Interval(0,1));
		System.out.println("Solution: " + solution);
		Assert.assertEquals(0.30469265, solution, errorSize);
	}

	@Test (expected = IllegalArgumentException.class)
	public void testWithAStrangeInterval() {
		valueInBetweenSolver = new ValueInBetweenSolver(new OneVariableFunction() {
			
			public double getValue(double x) {
				return x;
			}
			
		});
		double errorSize = 0.001;
		double solution = valueInBetweenSolver.solve(0.3, errorSize, new Interval(2,1));
		System.out.println("Solution: " + solution);
	}

	@Test
	public void testWithAnExponential() {
		valueInBetweenSolver = new ValueInBetweenSolver(new OneVariableFunction() {
			
			public double getValue(double x) {
				return Math.exp(x);
			}
			
		});
		double errorSize = 0.0001;
		double solution = valueInBetweenSolver.solve(13, errorSize, new Interval(0,5));
		System.out.println("Solution: " + solution);
		Assert.assertEquals(2.56495, solution, errorSize);
	}
	
	@Test
	public void testApproximationOfE() {
		valueInBetweenSolver = new ValueInBetweenSolver(new OneVariableFunction() {
			
			public double getValue(double x) {
				return x;
			}
			
		});
		double errorSize = 0.000001;
		double solution = valueInBetweenSolver.solve(Math.E, errorSize, new Interval(0,3));
		System.out.println("Solution: " + solution);
		Assert.assertEquals(Math.E, solution, errorSize);
	}
	
	@Test
	public void testDiscontinuousFunction() {
		valueInBetweenSolver = new ValueInBetweenSolver(new OneVariableFunction() {
			
			public double getValue(double x) {
				if (x <= 1) {
					return 1 + x;
				} 
				return 2 + x;
			}
			
		});
		double errorSize = 0.0001;
		double solution = valueInBetweenSolver.solve(2.5, errorSize, new Interval(0,2));
		System.out.println("Not a solution: " + solution);
	}
		
	
}
