package se.kth.anderslm.graph;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Align;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;

public class BasicGraphicsView extends View {
	
	private int n = 0; // # of calls to onDraw
	private Drawable cross;
	private int colorLightGrey = Color.parseColor("#AAAAAA");

	public BasicGraphicsView(Context context) {
		super(context);
		
		// Represent the images as Drawables
		Resources resources = context.getResources();
		cross = (Drawable) resources.getDrawable(R.drawable.cross);
	}
	
	@Override
	protected void onDraw(Canvas canvas) {
		Log.i("BasicGraphicsView", "onDraw called");
		
		// Current size of this view
		int w = this.getWidth(), h = this.getHeight();
		int offset = (h - w)/2;  // Assuming portrait
		
		// Background
		Paint bgPaint = new Paint();
		bgPaint.setColor(colorLightGrey);
		canvas.drawPaint(bgPaint);
		
		// Fill a rectangle
		Paint rectPaint = new Paint();
		rectPaint.setColor(Color.WHITE);
		canvas.drawRect(0, offset, w, h-offset, rectPaint);
		
		// A grid (assuming width < height, i.e. portrait)
		int step = w/3;
		Paint gridPaint = new Paint();
		gridPaint.setColor(Color.BLACK);
		for(int i = 0; i <= 3; i++) {
			// vertical lines
			canvas.drawLine(i*step, offset, i*step, offset+w, gridPaint);
			// horizontal lines
			canvas.drawLine(0, offset+i*step, w, offset+i*step, gridPaint);
		}
		
		// Image
		int x = step/2, y = offset+step/2;
		int iw = cross.getIntrinsicWidth();
		int ih = cross.getIntrinsicHeight();
		Rect bounds = new Rect(x-iw/2, y-ih/2, x+iw/2, y+ih/2);
		Log.i("TicTacToeView", "bounds = " + bounds);
		cross.setBounds(bounds);
		cross.draw(canvas);
		
		// Text
		Paint textPaint = new Paint();
		Typeface face = Typeface.create(Typeface.SERIF, Typeface.BOLD);
		textPaint.setTextSize(42);
		textPaint.setTypeface(face);
		textPaint.setTextAlign(Align.CENTER);
		textPaint.setColor(Color.RED);
		canvas.drawText("Calls to onDraw = " + ++n, w/2, h/2, textPaint);
	}
}
