#************************************************************************
#**  template.clip: Absolute pathnames, included by all CLIP makefiles **
#************************************************************************
-b

#*************************************************************************
#*
#* Edition History
#*   date    comments                                           by  Index
#* -------- --------------------------------------------------- --- -----
#* 23.OCT.97 New                                                JD  I1.0
#*************************************************************************

DEV_ROOT			=		R:
ISA_RELEASE			=		3.32_I1.00_OEM
ISA_INDEX			=		I1.00
DEV_ISA_ROOT		=		$(DEV_ROOT)/ISaGRAF_$(ISA_RELEASE)

PEP_ROOT			=		P:/PEP
MWOS_ROOT			=		P:/MWOS

# Pdr #99030010 : EEPROM support
EEPROM_SUPPORT		=		EEPROM_SUPPORT

HISTORY_DIR			=		HISTORY

include $(PEP_ROOT)/template.pep

ISA_WDS				=		ISaWDS
SRC_ISA				=		$(ISA_WDS)/OEM
COMMON_ISA			=		$(ISA_WDS)/IMAGES/COMMON
CMDS_COMMON_PAK		=		$(COMMON_ISA)/PAK_OBJS/COMMAND
INET_COMMON_PAK		=		$(COMMON_ISA)/PAK_OBJS/INET
OS9NET_COMMON_PAK	=		$(COMMON_ISA)/PAK_OBJS/OS9NET
PBL2_COMMON_PAK		=		$(COMMON_ISA)/PAK_OBJS/PBL2
PBL7_COMMON_PAK		=		$(COMMON_ISA)/PAK_OBJS/PBL7
DPMASTER_COMMON_PAK =		$(COMMON_ISA)/PAK_OBJS/DPMASTER
FASTRAK_COMMON_PAK 	=		$(COMMON_ISA)/PAK_OBJS/FASTRAK
CANOPEN_COMMON_PAK 	=		$(COMMON_ISA)/PAK_OBJS/CANOPEN
SYSGO_COMMON_PAK	=		$(COMMON_ISA)/SYSGO

PEP_ISA_TOOLS		=		$(ISA_WDS)/TOOLS/CMDS
PEP_ADC_DATA		=		$(ISA_WDS)/TOOLS/DATA
PEP_ADC_OBJS		=		$(ISA_WDS)/TOOLS/PAK_OBJS
PEP_ISA_LIB			=		$(ISA_WDS)/TOOLS/LIB

SMART_IMAGE			=		$(ISA_WDS)/IMAGES/SMART
VIUC_IMAGE			=		$(ISA_WDS)/IMAGES/VIUC
VM30_IMAGE			=		$(ISA_WDS)/IMAGES/VM30
VM42_IMAGE			=		$(ISA_WDS)/IMAGES/VM42
VM62_IMAGE			=		$(ISA_WDS)/IMAGES/VM62
VSBC32_IMAGE		=		$(ISA_WDS)/IMAGES/VSBC32

ROM_OBJS			=		ROM/BOBJS
SYSGO_OBJS			=		SYSGO/OBJS
SYSGO_TXT			=		SYSGO/TXT

ISA_CMDS			=		$(SRC_ISA)/CMDS
ISA_68000_CMDS		=		$(SRC_ISA)/CMDS/68000
ISA_68020_CMDS		=		$(SRC_ISA)/CMDS/68020
ISA_CPU32_CMDS		=		$(SRC_ISA)/CMDS/CPU32
PB_CMDS				=	   	$(SRC_ISA)/CMDS/PROFIBUS
PB_68000_CMDS		=	   	$(SRC_ISA)/CMDS/PROFIBUS/68000
PB_68020_CMDS		=	   	$(SRC_ISA)/CMDS/PROFIBUS/68020
PB_CPU32_CMDS		=	   	$(SRC_ISA)/CMDS/PROFIBUS/CPU32
CAN_CMDS			=	   	$(SRC_ISA)/CMDS/CANOPEN
CAN_68000_CMDS		=	   	$(SRC_ISA)/CMDS/CANOPEN/68000
CAN_68020_CMDS		=	   	$(SRC_ISA)/CMDS/CANOPEN/68020
CAN_CPU32_CMDS		=	   	$(SRC_ISA)/CMDS/CANOPEN/CPU32
SRV_CMDS			=		$(SRC_ISA)/CMDS/SERVER
C_CMDS				=		$(SRC_ISA)/CMDS/C

ISA_SUBMOD			=		$(SRC_ISA)/SUBMOD

CJI_DEFS			=	   	$(SRC_ISA)/DEFS
68K_DEFS			=	   	$(SRC_ISA)/DEFS/68K
USER_DEFS			=		$(SRC_ISA)/DEFS/USER

ISA_LIB				=		$(SRC_ISA)/LIB
ISA_68000_LIB		=		$(SRC_ISA)/LIB/68000
ISA_68020_LIB		=		$(SRC_ISA)/LIB/68020
ISA_CPU32_LIB		=		$(SRC_ISA)/LIB/CPU32

LIB_MAKE			=		$(SRC_ISA)/MAKEFILE/LIB
LIB_68000_MAKE		=		$(SRC_ISA)/MAKEFILE/LIB/68000
LIB_68020_MAKE		=		$(SRC_ISA)/MAKEFILE/LIB/68020
LIB_CP32_MAKE		=		$(SRC_ISA)/MAKEFILE/LIB/CPU32
C_LIB_MAKE			=		$(SRC_ISA)/MAKEFILE/LIB/C
PROG_MAKE			=		$(SRC_ISA)/MAKEFILE/PROG
PROG_68000_MAKE		=		$(SRC_ISA)/MAKEFILE/PROG/68000
PROG_68020_MAKE		=		$(SRC_ISA)/MAKEFILE/PROG/68020
PROG_CPU32_MAKE		=		$(SRC_ISA)/MAKEFILE/PROG/CPU32
C_PROG_MAKE			=		$(SRC_ISA)/MAKEFILE/PROG/C
SUBMOD_MAKE			=		$(SRC_ISA)/MAKEFILE/SUBMOD

PAK_OBJS			=		$(SRC_ISA)/PAK_OBJS

PEP_SRC				=		$(SRC_ISA)/PEP
PEP_ADI3			=		$(SRC_ISA)/PEP/ADI3
PEP_DEFS			=		$(SRC_ISA)/PEP/DEFS
PEP_PB_DEFS			=		$(SRC_ISA)/PEP/DEFS/PROFIBUS
PEP_PB_DP_DEFS		=		$(SRC_ISA)/PEP/DEFS/PROFIBUS/DP
PEP_PB_DPM_DEFS		=		$(SRC_ISA)/PEP/DEFS/PROFIBUS/DP/MASTER
PEP_CAN_DEFS		=		$(SRC_ISA)/PEP/DEFS/CANOPEN
PEP_USER_DEFS		=		$(SRC_ISA)/PEP/DEFS/USER
PEP_IO				=		$(SRC_ISA)/PEP/IO
PEP_PB				=	    $(SRC_ISA)/PEP/PROFIBUS
PEP_PB_DP			=	    $(SRC_ISA)/PEP/PROFIBUS/DP
PEP_PB_DPS			=	    $(SRC_ISA)/PEP/PROFIBUS/DP/SLAVE
PEP_PB_DPM			=	    $(SRC_ISA)/PEP/PROFIBUS/DP/MASTER
PEP_CAN				=	    $(SRC_ISA)/PEP/CANOPEN
PEP_SUBMOD			=		$(SRC_ISA)/PEP/SUBMOD
PEP_USER			=		$(SRC_ISA)/PEP/USER

ISA_SRC				=	    $(SRC_ISA)/SRC

ISA_USER			=		$(SRC_ISA)/USER

DEV_ISA_WDS			=		$(DEV_ISA_ROOT)/$(ISA_WDS)
DEV_COMMON_ISA		=		$(DEV_ISA_ROOT)/$(COMMON_ISA)

DEV_CMDS_COMMON_PAK		=	$(DEV_ISA_ROOT)/$(CMDS_COMMON_PAK)
DEV_INET_COMMON_PAK		=	$(DEV_ISA_ROOT)/$(INET_COMMON_PAK)
DEV_OS9NET_COMMON_PAK	=	$(DEV_ISA_ROOT)/$(OS9NET_COMMON_PAK)
DEV_PBL2_COMMON_PAK		=	$(DEV_ISA_ROOT)/$(PBL2_COMMON_PAK)
DEV_PBL7_COMMON_PAK		=	$(DEV_ISA_ROOT)/$(PBL7_COMMON_PAK)
DEV_DPMASTER_COMMON_PAK =	$(DEV_ISA_ROOT)/$(DPMASTER_COMMON_PAK)
DEV_FASTRAK_COMMON_PAK 	=	$(DEV_ISA_ROOT)/$(FASTRAK_COMMON_PAK)
DEV_SYSGO_COMMON_PAK 	=	$(DEV_ISA_ROOT)/$(SYSGO_COMMON_PAK)

DEV_PEP_ISA_TOOLS	=		$(DEV_ISA_ROOT)/$(PEP_ISA_TOOLS)
DEV_PEP_ISA_LIB		=		$(DEV_ISA_ROOT)/$(PEP_ISA_LIB)

DEV_PEP_ADC_DATA	=		$(DEV_ISA_ROOT)/$(PEP_ADC_DATA)
DEV_PEP_ADC_OBJS	=		$(DEV_ISA_ROOT)/$(PEP_ADC_OBJS)

DEV_SMART_IMAGE		=		$(DEV_ISA_ROOT)/$(SMART_IMAGE)
DEV_VIUC_IMAGE		=		$(DEV_ISA_ROOT)/$(VIUC_IMAGE)
DEV_VM30_IMAGE		=		$(DEV_ISA_ROOT)/$(VM30_IMAGE)
DEV_VM42_IMAGE		=		$(DEV_ISA_ROOT)/$(VM42_IMAGE)
DEV_VM62_IMAGE		=		$(DEV_ISA_ROOT)/$(VM62_IMAGE)
DEV_VSBC32_IMAGE	=		$(DEV_ISA_ROOT)/$(VSBC32_IMAGE)

DEV_ISA_CMDS		=		$(DEV_ISA_ROOT)/$(ISA_CMDS)
DEV_ISA_68000_CMDS	=		$(DEV_ISA_ROOT)/$(ISA_68000_CMDS)
DEV_ISA_68020_CMDS	=		$(DEV_ISA_ROOT)/$(ISA_68020_CMDS)
DEV_ISA_CPU32_CMDS	=		$(DEV_ISA_ROOT)/$(ISA_CPU32_CMDS)

DEV_PB_CMDS			=		$(DEV_ISA_ROOT)/$(PB_CMDS)
DEV_PB_68000_CMDS	=		$(DEV_ISA_ROOT)/$(PB_68000_CMDS)
DEV_PB_68020_CMDS	=		$(DEV_ISA_ROOT)/$(PB_68020_CMDS)
DEV_PB_CPU32_CMDS	=		$(DEV_ISA_ROOT)/$(PB_CPU32_CMDS)

DEV_CAN_CMDS		=		$(DEV_ISA_ROOT)/$(CAN_CMDS)
DEV_CAN_68000_CMDS	=		$(DEV_ISA_ROOT)/$(CAN_68000_CMDS)
DEV_CAN_68020_CMDS	=		$(DEV_ISA_ROOT)/$(CAN_68020_CMDS)
DEV_CAN_CPU32_CMDS	=		$(DEV_ISA_ROOT)/$(CAN_CPU32_CMDS)

DEV_SRV_CMDS		=		$(DEV_ISA_ROOT)/$(SRV_CMDS)
DEV_C_CMDS			=		$(DEV_ISA_ROOT)/$(C_CMDS)

DEV_ISA_SUBMOD		=		$(DEV_ISA_ROOT)/$(ISA_SUBMOD)

DEV_CJI_DEFS		=	   	$(DEV_ISA_ROOT)/$(CJI_DEFS)
DEV_68K_DEFS		=	   	$(DEV_ISA_ROOT)/$(68K_DEFS)
DEV_USER_DEFS		=		$(DEV_ISA_ROOT)/$(USER_DEFS)

DEV_ISA_LIB			=		$(DEV_ISA_ROOT)/$(ISA_LIB)
DEV_ISA_68000_LIB	=		$(DEV_ISA_ROOT)/$(ISA_68000_LIB)
DEV_ISA_68020_LIB	=		$(DEV_ISA_ROOT)/$(ISA_68020_LIB)
DEV_ISA_CPU32_LIB	=		$(DEV_ISA_ROOT)/$(ISA_CPU32_LIB)

DEV_LIB_MAKE		=		$(DEV_ISA_ROOT)/$(LIB_MAKE)
DEV_PROG_MAKE		=		$(DEV_ISA_ROOT)/$(PROG_MAKE)
DEV_SUBMOD_MAKE		=		$(DEV_ISA_ROOT)/$(SUBMOD_MAKE)

DEV_PAK_OBJS		=		$(DEV_ISA_ROOT)/$(PAK_OBJS)

DEV_PEP				=		$(DEV_ISA_ROOT)/$(PEP_SRC)
DEV_PEP_ADI3		=		$(DEV_ISA_ROOT)/$(PEP_ADI3)
DEV_PEP_DEFS		=		$(DEV_ISA_ROOT)/$(PEP_DEFS)
DEV_PEP_PB_DEFS		=		$(DEV_ISA_ROOT)/$(PEP_PB_DEFS)
DEV_PEP_PB_DPM_DEFS	=		$(DEV_ISA_ROOT)/$(PEP_PB_DPM_DEFS)
DEV_PEP_CAN_DEFS	=		$(DEV_ISA_ROOT)/$(PEP_CAN_DEFS)
DEV_PEP_USER_DEFS	=		$(DEV_ISA_ROOT)/$(PEP_USER_DEFS)
DEV_PEP_IO			=		$(DEV_ISA_ROOT)/$(PEP_IO)
DEV_PEP_PB			=		$(DEV_ISA_ROOT)/$(PEP_PB)
DEV_PEP_CAN			=		$(DEV_ISA_ROOT)/$(PEP_CAN)
DEV_PEP_PB_DPS		=		$(DEV_ISA_ROOT)/$(PEP_PB_DPS)
DEV_PEP_PB_DPM		=		$(DEV_ISA_ROOT)/$(PEP_PB_DPM)
DEV_PEP_SUBMOD		=		$(DEV_ISA_ROOT)/$(PEP_SUBMOD)
DEV_PEP_USER		=		$(DEV_ISA_ROOT)/$(PEP_USER)

DEV_ISA_SRC			=		$(DEV_ISA_ROOT)/$(ISA_SRC)

DEV_ISA_USER		=		$(DEV_ISA_ROOT)/$(ISA_USER)

KER_REV				=		310
KERSM_REV			=		293
KERCM_REV			=		303
NET_REV				=		16
TST_REV				=		58
SPY_ATTREV			=		8002

ADI3_REV			=		6
GETCXC_REV			=		4
STPRG_REV			=		11
STPRGSM_REV			=		12
TESTADI3_REV		=		12
TID_REV				=		4
ISADPM_REV			=		7
ISACAN_REV			=		20
ISASERV_REV			=		9

PB2_C_REV			=		19
PB2_M_REV			=		18
PB2_S_REV			=		19
STPB2_REV			=		18

RT2_REV				=		2
RT3_REV				=		2
RT4_REV				=		3
RT5_REV				=		3
RT6_REV				=		2
RT7_REV				=		2
TSY_REV				=		2

FBLMOD_REV			=		4
USPMOD_REV			=		4

GEN68K_LIB_REV		=		2
GRCNPEP0_LIB_REV	=		5
GRFBPEP0_LIB_REV	=		7
GRFBPEPS_LIB_REV	=		7
GRUSPEP0_LIB_REV	=		5
ISACNV_LIB_REV		=		4
ISAFBL_LIB_REV		=		5
ISAFBLSM_LIB_REV	=		5
ISAIO_LIB_REV		=		2
ISAKER_LIB_REV		=		5
ISAKER_C_LIB_REV	=		5
ISAKERPB_LIB_REV	=		4
ISANET_LIB_REV		=		4
ISANET_C_LIB_REV	=		4
ISAOEM_LIB_REV		=		23
ISAOEMPB_LIB_REV	=		5
ISAOEMSM_LIB_REV	=		6
ISAOEMCM_LIB_REV	=		18
ISASYS_LIB_REV		=		4
ISATST_LIB_REV		=		4
ISATST_C_LIB_REV	=		4
ISAUSP_LIB_REV		=		3
SUBMOD_LIB_REV		=		4
ISAL7SRV_LIB_REV	=		3