function varargout = AliasingDemo(varargin)
% ALIASINGDEMO MATLAB code for AliasingDemo.fig
%      ALIASINGDEMO, by itself, creates a new ALIASINGDEMO or raises the existing
%      singleton*.
%
%      H = ALIASINGDEMO returns the handle to a new ALIASINGDEMO or the handle to
%      the existing singleton*.
%
%      ALIASINGDEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in ALIASINGDEMO.M with the given input arguments.
%
%      ALIASINGDEMO('Property','Value',...) creates a new ALIASINGDEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before AliasingDemo_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to AliasingDemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help AliasingDemo

% Last Modified by GUIDE v2.5 27-Mar-2013 16:25:36

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @AliasingDemo_OpeningFcn, ...
                   'gui_OutputFcn',  @AliasingDemo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before AliasingDemo is made visible.
function AliasingDemo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to AliasingDemo (see VARARGIN)

% Choose default command line output for AliasingDemo
handles.output = hObject;

% Draw everything
DrawDemo(handles);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes AliasingDemo wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = AliasingDemo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on slider movement.
function freqslider_Callback(hObject, eventdata, handles)
% hObject    handle to freqslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

% Draw everything

DrawDemo(handles);


% --- Executes during object creation, after setting all properties.
function freqslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to freqslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


function DrawDemo(handles)

f = get(handles.freqslider,'Value');

N = 20;
n = 0:N;
t = linspace(0,N,400);

% Draw time axes
cla(handles.timeaxes); hold(handles.timeaxes,'on');
plot(handles.timeaxes,t,cos(2*pi*f*t),'k');
if(f > 0.5) % Draw aliased cosine
    fa = 1-f;
    plot(handles.timeaxes,t,cos(2*pi*fa*t),'r');
end;
stem(handles.timeaxes,n,cos(2*pi*f*n),'k','LineWidth',2);
set(handles.timeaxes,'XLim',[0 N]);
set(handles.timeaxes,'YLim',[-1 1]);
set(handles.timeaxes,'XTick',n);

% Draw frequency axes
cla(handles.freqaxes); hold(handles.freqaxes,'on');
if((abs(f-0.0) < 1e-3) || (abs(f-0.5) < 1e-3) || (abs(f-1.0) < 1e-3) || (abs(f-1.5) < 1e-3))
    h = 1;
else
    h = 0.5;
end;
fp = [f -f (1-f) -(1-f) (2-f) -(2-f)];
stem(handles.freqaxes,fp,h*ones(size(fp)),'k','LineWidth',2,'Marker','^','MarkerFaceColor','k');
set(handles.freqaxes,'XLim',[-1 1]);
set(handles.freqaxes,'YLim',[0 1.2]);
plot(handles.freqaxes,-[0.5 0.5],[0 1.2],'k--');
plot(handles.freqaxes,[0.5 0.5],[0 1.2],'k--');


% Settings for time axes
set(handles.timeaxes,'Box','on');
txt = xlabel(handles.timeaxes,'n'); set(txt,'FontSize',20);
txt = ylabel(handles.timeaxes,'x[n] = cos(2{\pi}fn)'); set(txt,'FontSize',20);
txt = title(handles.timeaxes,'Time (sample) domain'); set(txt,'FontSize',20);


% Settings for frequency axes
set(handles.freqaxes,'Box','on');
txt = xlabel(handles.freqaxes,'\nu'); set(txt,'FontSize',20);
txt = ylabel(handles.freqaxes,'X(\nu)'); set(txt,'FontSize',20);
txt = title(handles.freqaxes,'Normalized frequency domain'); set(txt,'FontSize',20);
