function varargout = PAMDemo(varargin)
% PAMDEMO MATLAB code for PAMDemo.fig
%      PAMDEMO, by itself, creates a new PAMDEMO or raises the existing
%      singleton*.
%
%      H = PAMDEMO returns the handle to a new PAMDEMO or the handle to
%      the existing singleton*.
%
%      PAMDEMO('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in PAMDEMO.M with the given input arguments.
%
%      PAMDEMO('Property','Value',...) creates a new PAMDEMO or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before PAMDemo_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to PAMDemo_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help PAMDemo

% Last Modified by GUIDE v2.5 27-Mar-2013 17:24:30

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @PAMDemo_OpeningFcn, ...
                   'gui_OutputFcn',  @PAMDemo_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before PAMDemo is made visible.
function PAMDemo_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to PAMDemo (see VARARGIN)

% Choose default command line output for PAMDemo
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

DrawDemo(handles)

% UIWAIT makes PAMDemo wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = PAMDemo_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in shiftpulse.
function shiftpulse_Callback(hObject, eventdata, handles)
% hObject    handle to shiftpulse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of shiftpulse

DrawDemo(handles);

% --- Executes on selection change in pulse.
function pulse_Callback(hObject, eventdata, handles)
% hObject    handle to pulse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns pulse contents as cell array
%        contents{get(hObject,'Value')} returns selected item from pulse

DrawDemo(handles)


% --- Executes on button press in reconst.
function reconst_Callback(hObject, eventdata, handles)
% hObject    handle to reconst (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of reconst

DrawDemo(handles)


% --- Executes during object creation, after setting all properties.
function pulse_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pulse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function DrawDemo(handles)

n = -3:3;
x = [0.1 1.4 0.3 0.1 -0.2 -1.6 -0.8];
col = ['r','g','b','r','g','b','r'];
t = linspace(-3.5,3.5,1000);

% Chose pulse form
pv = get(handles.pulse,'Value');
if(pv == 1)
    pfun = @PulseFunctionBox;
end;
if(pv == 2)
    pfun = @PulseFunctionTriangle;
end;
if(pv == 3)
    pfun = @PulseFunctionGauss;
end;
if(pv == 4)
    pfun = @PulseFunctionSinc;
end;


% Draw time axes
cla(handles.timeaxes); hold(handles.timeaxes,'on');
%stem(handles.timeaxes,n,x,'k','LineWidth',2);
xr = 0; % Build reconstruction
for k=1:length(x)
    xc = x(k)*pfun(t-n(k)); % Contribution
    if(get(handles.shiftpulse,'Value') == 1)
        plot(handles.timeaxes,t,xc,col(k),'LineWidth',0.5);
        stem(handles.timeaxes,n(k),x(k),col(k),'LineWidth',2);
    else
        stem(handles.timeaxes,n(k),x(k),'k','LineWidth',2);
    end;
    xr = xr + xc;
end;
if(get(handles.reconst,'Value') == 1)
    plot(handles.timeaxes,t,xr,'k','LineWidth',2);
end;
    
% Draw pulse axes
cla(handles.pulseaxes); hold(handles.pulseaxes,'on');
plot(handles.pulseaxes,t,pfun(t),'k','LineWidth',2);

% Settings for time axes
set(handles.timeaxes,'Box','on');
txt = xlabel(handles.timeaxes,'n, t'); set(txt,'FontSize',20);
txt = ylabel(handles.timeaxes,'x[n], x(t)'); set(txt,'FontSize',20);
txt = title(handles.timeaxes,'Time domain samples and reconstruction (T=1)'); set(txt,'FontSize',20);
set(handles.timeaxes,'XLim',[-3.5 3.5]);
set(handles.timeaxes,'YLim',[-2 2]);

% Settings for frequency axes
set(handles.pulseaxes,'Box','on');
txt = xlabel(handles.pulseaxes,'t'); set(txt,'FontSize',20);
txt = ylabel(handles.pulseaxes,'p(t)'); set(txt,'FontSize',20);
txt = title(handles.pulseaxes,'Reconstruction pulse'); set(txt,'FontSize',20);
set(handles.pulseaxes,'XLim',[-3.5 3.5]);
set(handles.pulseaxes,'YLim',[-2 2]);
grid(handles.pulseaxes,'on');

function p = PulseFunctionBox(t)
p = (t >= 0) .* (t < 1);

function p = PulseFunctionTriangle(t)
p = ((t >= -1).*(t < 0)).*(1+t) + ((t >= 0).*(t < 1)).*(1-t);

function p = PulseFunctionGauss(t)
p = exp(-t.^2);

function p = PulseFunctionSinc(t)
p = sinc(t);

