package se.kth.android.projectred;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.TextView;

public class MainActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		Button bSend = (Button) findViewById(R.id.bSend);
		Button bCapture = (Button) findViewById(R.id.bCapture);
		Button bTest = (Button) findViewById(R.id.bTest);
		
		bSend.setOnClickListener(new View.OnClickListener() { 
			public void onClick(View v) { 
				Intent myIntent = new Intent(MainActivity.this,ActivitySend.class); 
				MainActivity.this.startActivity(myIntent); 
				} 
			}); 
		
		bCapture.setOnClickListener(new View.OnClickListener() { 
			public void onClick(View v) { 
				Intent myIntent = new Intent(MainActivity.this,ActivityCapture.class); 
				MainActivity.this.startActivity(myIntent); 
				} 
			}); 
		
		bTest.setOnClickListener(new View.OnClickListener() { 
			public void onClick(View v) { 
				Intent myIntent = new Intent(MainActivity.this,TestScreen .class); 
				MainActivity.this.startActivity(myIntent); 
				} 
			}); 
		
		} 
				
		
	

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}

	 @Override
	    public boolean onOptionsItemSelected(MenuItem item) {
	        switch (item.getItemId()) {
	 
	        case R.id.action_read:
	        	 
		 		loadFileList();
		 		showDialog(DIALOG_LOAD_FILE);
	        	break;
	        	
	        case R.id.action_write:
	        	 
		 		loadFileList();
		 		showDialog(DIALOG_WRITE_FILE);
	        	break;
	        case R.id.action_settings:
	        	
	            Intent i = new Intent(this, ActivitySettings.class);
	            startActivity(i);
	            break;
	 
	        }
	 
	        return true;
	    }
	 
	 
	 
	 

	 	// Stores names of traversed directories
	 	ArrayList<String> str = new ArrayList<String>();

	 	// Check if the first level of the directory structure is the one showing
	 	private Boolean firstLvl = true;

	 	private static final String TAG = "F_PATH";

	 	private Item[] fileList;
	 	private File path = new File(Environment.getExternalStorageDirectory() + "");
	 	private String chosenFile;
	 	private String currentFolder;
	 	private static final int DIALOG_LOAD_FILE = 1000;
	 	private static final int DIALOG_WRITE_FILE = 1001;

	 	ListAdapter adapter;

	


	 	private void loadFileList() {
	 		try {
	 			path.mkdirs();
	 		} catch (SecurityException e) {
	 			Log.e(TAG, "unable to write on the sd card ");
	 		}

	 		// Checks whether path exists
	 		if (path.exists()) {
	 			FilenameFilter filter = new FilenameFilter() {
	 				@Override
	 				public boolean accept(File dir, String filename) {
	 					File sel = new File(dir, filename);
	 					// Filters based on whether the file is hidden or not
	 					return (sel.isFile() || sel.isDirectory())
	 							&& !sel.isHidden();

	 				}
	 			};

	 			String[] fList = path.list(filter);
	 			fileList = new Item[fList.length];
	 			for (int i = 0; i < fList.length; i++) {
	 				fileList[i] = new Item(fList[i], R.drawable.file_icon);

	 				// Convert into file path
	 				File sel = new File(path, fList[i]);

	 				// Set drawables
	 				if (sel.isDirectory()) {
	 					fileList[i].icon = R.drawable.directory_icon;
	 					Log.d("DIRECTORY", fileList[i].file);
	 				} else {
	 					Log.d("FILE", fileList[i].file);
	 				}
	 			}

	 			if (!firstLvl) {
	 				Item temp[] = new Item[fileList.length + 1];
	 				for (int i = 0; i < fileList.length; i++) {
	 					temp[i + 1] = fileList[i];
	 				}
	 				temp[0] = new Item("Up", R.drawable.directory_up);
	 				fileList = temp;
	 			}
	 		} else {
	 			Log.e(TAG, "path does not exist");
	 		}

	 		adapter = new ArrayAdapter<Item>(this,
	 				android.R.layout.select_dialog_item, android.R.id.text1,
	 				fileList) {
	 			@Override
	 			public View getView(int position, View convertView, ViewGroup parent) {
	 				// creates view
	 				View view = super.getView(position, convertView, parent);
	 				TextView textView = (TextView) view
	 						.findViewById(android.R.id.text1);

	 				// put the image on the text view
	 				textView.setCompoundDrawablesWithIntrinsicBounds(
	 						fileList[position].icon, 0, 0, 0);

	 				// add margin between image and text (support various screen
	 				// densities)
	 				int dp5 = (int) (5 * getResources().getDisplayMetrics().density + 0.5f);
	 				textView.setCompoundDrawablePadding(dp5);

	 				return view;
	 			}
	 		};

	 	}

	 	private class Item {
	 		public String file;
	 		public int icon;

	 		public Item(String file, Integer icon) {
	 			this.file = file;
	 			this.icon = icon;
	 		}

	 		@Override
	 		public String toString() {
	 			return file;
	 		}
	 	}

	 	@Override
	 	protected Dialog onCreateDialog(int id) {
	 		Dialog dialog = null;
	 		AlertDialog.Builder builder = new Builder(this);
	 		 final int currentdialog=id;

	 		if (fileList == null) {
	 			Log.e(TAG, "No files loaded");
	 			dialog = builder.create();
	 			return dialog;
	 		}

	 		switch (id) {
	 		case DIALOG_LOAD_FILE:
	 		case DIALOG_WRITE_FILE:
	 			if(DIALOG_LOAD_FILE==id) builder.setTitle("Choose your file");
	 			else {
	 				builder.setTitle("Choose your folder");
	 				builder.setNeutralButton("Select", new OnClickListener() {
						
						@Override
						public void onClick(DialogInterface dialog, int which) {
							Log.d(TAG,"chosen one:" +currentFolder);
							AlertDialog.Builder alert = new AlertDialog.Builder(MainActivity.this);

							alert.setTitle("Enter File name");
							

							// Set an EditText view to get user input 
							final EditText input = new EditText(MainActivity.this);
							alert.setView(input);

							alert.setPositiveButton("Ok", new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dialog, int whichButton) {
							  String value = input.getText().toString();
								Log.d(TAG,"chosen one value:" +currentFolder+"/"+value);
								SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(MainActivity.this);
		 						sharedPref.edit().putString(PSettings.KEY_WRITEFILE, currentFolder+"/"+value).commit();
		 						
							  }
							});

							alert.show();
							
						}
					});
	 			}
	 			
	 			builder.setAdapter(adapter, new DialogInterface.OnClickListener() {
	 				@Override
	 				public void onClick(DialogInterface dialog, int which) {
	 					
	 					chosenFile = fileList[which].file;
	 					File sel = new File(path + "/" + chosenFile);
	 					if (sel.isDirectory()) {
	 						currentFolder=sel.toString();
	 						firstLvl = false;

	 						// Adds chosen directory to list
	 						str.add(chosenFile);
	 						fileList = null;
	 						path = new File(sel + "");

	 						loadFileList();

	 						removeDialog(currentdialog);
	 						showDialog(currentdialog);
	 						Log.d(TAG, path.getAbsolutePath());

	 					}

	 					// Checks if 'up' was clicked
	 					else if (chosenFile.equalsIgnoreCase("up") && !sel.exists()) {

	 						// present directory removed from list
	 						String s = str.remove(str.size() - 1);

	 						// path modified to exclude present directory
	 						path = new File(path.toString().substring(0,
	 								path.toString().lastIndexOf(s)));
	 						fileList = null;

	 						// if there are no more directories in the list, then
	 						// its the first level
	 						if (str.isEmpty()) {
	 							firstLvl = true;
	 						}
	 						loadFileList();

	 						removeDialog(currentdialog);
	 						showDialog(currentdialog);
	 						Log.d(TAG, path.getAbsolutePath());

	 					}
	 					// File picked
	 					else {
	 						if(currentdialog==DIALOG_WRITE_FILE) {
	 							removeDialog(currentdialog);
	 							showDialog(currentdialog);
	 							return;
	 						}
	 						Log.d(TAG,"1 " + sel);
	 						
	 						SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(MainActivity.this);
	 						sharedPref.edit().putString(PSettings.KEY_READFILE, sel.toString()).commit();
	 						
	 					}

	 				}
	 			});
	 			break;
	 		}
	 		dialog = builder.show();
	 		return dialog;
	 	}

	 }

