package se.kth.android.projectred.QR;

import java.util.Arrays;

import org.opencv.imgproc.Imgproc;

import android.util.Log;

public class FinderPatternFinder {

	FinderPattern fPattern[] = new FinderPattern[3];
	boolean img[][];
	boolean flag;
	byte counter_pattern;
	// For center
	int center_point[] = new int[100];
	int pattern_size[] = new int[100];
	int num;

	double distance(FinderPattern p1, FinderPattern p2){
		/*Distance between FinderPatterns
		 * Attention it's the square of the distance
		 * @Thomas
		 */
		return Math.pow((p1.row-p2.row),2)+Math.pow((p1.col-p2.col), 2);
	}
	
	void sortPatterns(){
		/*Sorts the FinderPatterns so they are in the following order: 1	2
		 * @Thomas
		 * 															   3
		 */
		
		//Find the two points on the diagonal: Longest distance between the points
		double dist=0;
		int pDiag[] = new int[2];
		int pTopLeft = 0;
		int pTopRight;
		int pBottomLeft;
		for (int i=0;i<3;i++){
			for(int j=0;j<3;j++){
				if (distance(fPattern[i],fPattern[j])>dist){
					dist=distance(fPattern[i],fPattern[j]);
					pDiag[0]=i;
					pDiag[1]=j;
				}
			}
		}
		//Find the Point on the top left: not on the diagonal
		Arrays.sort(pDiag);
		for (int i=0;i<3;i++){
			if (Arrays.binarySearch(pDiag, i) < 0){
				pTopLeft=i;
			}
		}
		
		//determine top right
		//TODO: Assuming it's the right way around
		if (fPattern[pDiag[0]].row<fPattern[pDiag[1]].row){
			pTopRight=pDiag[1];
			pBottomLeft=pDiag[0];
		}else{
			pTopRight=pDiag[0];
			pBottomLeft=pDiag[1];
		}
		
		//Sort them accordingly
		FinderPattern temp[]=fPattern.clone();
		
		fPattern[0]=temp[pTopLeft];
		fPattern[1]=temp[pTopRight];
		fPattern[2]=temp[pBottomLeft];
		
			
	}
	
	FinderPatternFinder(boolean[][] imgBW) {

		img = imgBW;
		flag = false;
		counter_pattern = 1;
	}

	boolean find() {
		/*
		 * Main function
		 * 
		 * @Thomas
		 */
		byte patternNR = 0;
		for (int row = 0; row < img.length; row++) {
			// Go through rows
			if (center(getRow(row)) > 0) {
				//Log.d("1234", "Found something in row:" + row + " at " + center_point[0]);
				// check every hit
				int center_row[]=center_point.clone();
				int num_row=num;
				for (int x = 0; x < num_row; x++) {
					
					if(center(getCol(center_row[x]))>0){
						//Found somethin in Collum
						for (int y=0;y<num;y++){
							int distance=center_point[y]-row;
							if (distance==0){
								int center_col[]=center_point.clone();
								Log.i("1234", "CENTER: " + center_row[x] + " " + center_col[y]+ "  distance " + distance);
								//Save Point
								if (patternNR<3){
									fPattern[patternNR++] = new FinderPattern(center_row[x],center_col[y],pattern_size[y]);
									//fPattern[patternNR].row=center_col[y];
									//fPattern[patternNR].col=center_row[x];
									//fPattern[patternNR].center_size=pattern_size[y];
									//patternNR++;
								}else
									return false; //Found too many points
							}
						}
					}
				}
			}
		}
		if (patternNR==3){
				sortPatterns();
				return true;
		}else
			return false;
	}

	boolean[] getRow(int row) {
		/*Returns a row
		 * @Thomas
		 */
	//	boolean[] r = new boolean[img[0].length];
	//	for (int i = 0; i < img[0].length; i++)
	//		r[i] = img[row][i];
	//	return r;
		return img[row];
	}

	boolean[] getCol(int col) {
		/*Returns a colum
		 * @Thomas
		 */
		boolean[] r = new boolean[img.length];
		for (int i = 0; i < img.length; i++)
			r[i] = img[i][col];
		return r;

	}

	int center(boolean row_image[]) {
		/*
		 * finds the center of the 11311 ratio returns the number of centers
		 * found
		 * 
		 * @Thomas
		 */
		num = 0; // Counter of points found

		Ratio ratio = new Ratio(row_image,true);

		for (int j = 0; j < ratio.getLength() - 4; j++) {
			// Go through the row to check for ratio
			if (ratio.isPattern(j)) {
				center_point[num] = ratio.findCenterPixel(j);
				pattern_size[num++] = ratio.getLength(); //TODO WRONG

			}
		}

		return num;
	}

}
