/**
 * NON STANDARD VERSION OF ReadFromFile.java
 * Thread that reads a text file, chunks it into n-byte long pieces (n depends on the version, here v2),
 * encodes the data, numbers the frames, and adds the generated boolean matrix in a queue. 
 * The queue is processed by the UI thread for displaying the QR codes on the screen.
 * Thread instantiated in ActivitySend, encode function.
 * Author : Claire
 * Date : May 2013
 */
package se.kth.android.projectred.QR.NSColors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import se.kth.android.projectred.ActivitySend;
import se.kth.android.projectred.ImgSizePar;
import android.os.Environment;
import android.util.Log;

public class ReadFromFileColorful extends Thread {
	//String fileName;
	//File dir;
	String path;
	int nbBytes;
	FileInputStream file;
	byte data[];
	EncoderColorful encoder;
	int DATA_CHUNK_SIZE = ImgSizePar.DATA_CHUNK_SIZE_COLOR;
	int SIZE_VERSION;
	int FINDERSIZE;

	public ReadFromFileColorful(String name, int findersize, int sizeversion) {
		this.FINDERSIZE = findersize;
		this.SIZE_VERSION = sizeversion;
		data = new byte[DATA_CHUNK_SIZE + 1]; // 1 byte for the frame number, 12 bytes of data
		
		//this.fileName = name;
		//this.dir = new File(Environment.getExternalStorageDirectory().getPath()+"/sendings/");
		this.path = name;
	}
	
	public void run () {
		try {
			
			file = new FileInputStream(path);
			nbBytes = file.available();

			int counter = (int) nbBytes / DATA_CHUNK_SIZE; 
			int remainder = nbBytes % DATA_CHUNK_SIZE;
			int frameNumber = 0; // For data retransmission, include frame numbering -> first byte in the data array
			
			for(int i = 0 ; i < counter ; i++) {
				
				data[0] = (byte) frameNumber;
				file.read(data, 1, DATA_CHUNK_SIZE); // offset to 1, 12 bytes of real data	
				
				encoder = new EncoderColorful (data, SIZE_VERSION, FINDERSIZE);
				
				ActivitySend.addProgressMessageColorful("Progress: " + frameNumber + " / " + counter);
				
				ActivitySend.addSymbolColorful(encoder.GetSymbol());
				frameNumber++;
			}
			
			// End of the file, remains less than 12 bytes of data		
			byte [] dataRemaining = new byte [remainder+1]; // first byte is the frame number
			dataRemaining [0] = (byte) counter; // the last frame
			file.read(dataRemaining, 1, remainder);
			
			encoder = new EncoderColorful (dataRemaining, SIZE_VERSION, FINDERSIZE);
			
			ActivitySend.addProgressMessageColorful("Progress: " + counter + " / " + counter);
			ActivitySend.addProgressMessageColorful("Transmission completed. " + counter + " frames transmitted.");
			
			ActivitySend.addSymbolColorful(encoder.GetSymbol());		

			file.close();
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
