/**
 * Thread that removes boolean matrices from a queue. This queue is synchronized and shared by the ReadQR and DecodeAndDisplayQR threads.
 * The matrices are decoded and depending on the number of errors, the best matrix among several matrices having the same number is kept.
 * The decoded data is written on a text file on the SD card.
 * Thread launched on ActivityCapture, decode function.
 * Author : Claire
 * Date : May 2013
 */
package se.kth.android.projectred.QR.nonStandard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import se.kth.android.projectred.ActivityCapture;
import se.kth.android.projectred.QR.QRDecoderV2;

import android.os.Environment;
import android.util.Log;

public class DecodeAndDisplayNS extends Thread {
	// Variables
	QueueNS queue;
	RectDecoder decoder;
	FileOutputStream fileOut;
	//String fileName;
	//File dir;
	String path;
	byte[] data;
	String lastMsg;
	ArrayList<Integer> frameNumber;
	ArrayList<Integer> errorNumber;
	byte[] bestData;
	int bestError;
	int FINDERSIZE;
	int CHUNK_SIZE;
	int currentFrame;
	byte sameFrame;

	// Constructor
	public DecodeAndDisplayNS (String name, QueueNS q, int findersize, int version) {		
		this.FINDERSIZE = findersize;
		this.queue = q;
		//data = new byte[CHUNK_SIZE];
		lastMsg = null;
		this.frameNumber = new ArrayList<Integer>();
		this.errorNumber = new ArrayList<Integer>();
		if (version == 1) { // square
			CHUNK_SIZE = 221;
			bestData = new byte [CHUNK_SIZE];
		}
		else { // rectangular
			CHUNK_SIZE = 641;
			bestData = new byte [CHUNK_SIZE];
		}

		//this.fileName = name;
		//this.dir = new File(Environment.getExternalStorageDirectory().getPath()+"/recordings/");
		//dir.mkdir();
		this.path = name;
	}

	public void run () {
		Log.d ("DEBUG", "DEBUG decode and display running");

		try {

			fileOut = new FileOutputStream(path);

			while (!queue.getStopValue()) { // true when stop button is pressed by user

				if (!queue.isEmpty()) { 
					// Decode the data removed from the queue

					decoder = new RectDecoder (queue.dequeue(), FINDERSIZE);

					String outputMsg = decoder.getMsgString();
					data = decoder.GetMessage(); 

					int errorNb = decoder.getNumberErrors();

					if(outputMsg != null  && (errorNb != -1)) {
						if (data [0] == data [data.length - 1]) {

							if(frameNumber.isEmpty()) { // First frame we decode							
								frameNumber.add((int) data [0]);
								errorNumber.add(errorNb);

								lastMsg = outputMsg; // record last message
								bestData = data; // first data set as best data
								bestError = errorNb;
								currentFrame=(int) data [0];
							}
							else { 
								if(frameOK(data[0])){
									frameNumber.add(currentFrame);
									errorNumber.add(errorNb);					

									// if the data has not been read already
									if (frameNumber.get(frameNumber.size() - 1) != frameNumber.get(frameNumber.size() - 2)) { // write the data only if different, otherwise the same QR has been read twice
										// write the best previous frame recorded
										fileOut.write(bestData, 1, bestData.length - 2);
										int frame = frameNumber.get(frameNumber.size() - 1);
										ActivityCapture.addSuccessWarnNS("" + frame);
										Log.d("DEBUG", "DEBUG write data " + (bestData.length-2) + " of " + sameFrame + " FrameNR: " + frameNumber.get(frameNumber.size() - 1) + " Errors:" +bestError);
										

										// set the data as the best data
										bestData = data;
										bestError = errorNb;
										sameFrame=1;
									}
									// if the same data is read several times
									else {
										sameFrame++;
										// keep the data with the least error numbers
										if (errorNumber.get(frameNumber.size() - 1) < bestError) {
											bestData = data;
											bestError = errorNb;
										}
									}
									lastMsg = outputMsg; // record last message
								}
								else
									Log.e("DEBUG","DEBUG Frame corrupt FrameNR!!!" + (int) data [0]);

							}
						}
					}else if (errorNb == -1)
						Log.e("DEBUG","DEBUG Frame BROKEN");
						
				}

				// if queue empty, wait for new elements
				else {
					queue.waitForElement();
				}

			}

			if (bestData != null) {
				fileOut.write(bestData, 1, bestData.length - 2);
				int frame = frameNumber.get(frameNumber.size() - 1);
				ActivityCapture.addSuccessWarnNS("" + frame);
			}
			Log.d("DEBUG", "DEBUG write last data " + bestData.length + " Errors:" +bestError);			

			fileOut.close();

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	boolean frameOK(byte frameNR){
		int nr= (int) frameNR;
		if (nr < 0)
			nr+=256;

		if (( nr==(frameNumber.get(frameNumber.size() - 1) )) || (nr==(frameNumber.get(frameNumber.size() - 1)+1))){
			currentFrame=nr;
			return true;
		}else if(nr==0&&frameNumber.get(frameNumber.size() - 1)==255 ){ //TODO:
			currentFrame=nr;
			return true;
		}else
			return false;
	}
}
