package se.kth.android.projectred.QR.nonStandard;

public class InitSymbol {
	int size;
	int row, column;
	boolean [][] matrix;
	boolean [][] finder;
	// static final int  FINDERSIZE=3;
	
	InitSymbol(int size, int FINDERSIZE){
		
		matrix = new boolean [size][size];
		
		// Define the finder pattern.
		finder = new boolean [FINDERSIZE*7][FINDERSIZE*7];
		for(row = 1*FINDERSIZE; row < 6*FINDERSIZE; row++){
			for(column = 1*FINDERSIZE; column < 6*FINDERSIZE; column++){
				finder [row][column] = true;
			}
		}
		for(row = 2*FINDERSIZE; row < 5*FINDERSIZE; row++){
			for(column = 2*FINDERSIZE; column < 5*FINDERSIZE; column++){
				finder [row][column] = false;
			}
		}
		
		// Place the finder pattern. 
		for(row = 0; row < 7*FINDERSIZE; row++){
			for(column = 0; column < 7*FINDERSIZE; column++){
				matrix [row][column] = finder [row][column];
				matrix [row + size - 7*FINDERSIZE][column] = finder [row][column];
				matrix [row][column + size - 7*FINDERSIZE] = finder [row][column];
				matrix [row + size - 7*FINDERSIZE][column + size - 7*FINDERSIZE] = finder [row][column];
 			}
		}
		
		// Place the separator around the finder patterns.
		for(row = 0; row < (7*FINDERSIZE+1); row++){
			matrix [row][7*FINDERSIZE] = true;
			matrix [row][size - (7*FINDERSIZE+1)] = true;
		}
		for(row = size - (7*FINDERSIZE+1); row < size; row++){
			matrix [row][(7*FINDERSIZE)] = true;
			matrix [row][size - (7*FINDERSIZE+1)] = true;
		}
		for(column = 0; column < (7*FINDERSIZE+1); column++){
			matrix [(7*FINDERSIZE)][column] = true;
			matrix [size - (7*FINDERSIZE+1)][column] = true;
		}
		for(column = size - (7*FINDERSIZE+1); column < size; column++){
			matrix [(7*FINDERSIZE)][column] = true;
			matrix [size - (7*FINDERSIZE+1)][column] = true;
		}
	}
	
	boolean [][] GetMatrix(){
		return matrix;
	}
	
}
