/**
 * Thread that removes boolean matrices from a queue. This queue is synchronized and shared by the ReadQR and DecodeAndDisplayQR threads.
 * The matrices are decoded and depending on the number of errors, the best matrix among several matrices having the same number is kept.
 * The decoded data is written on a text file on the SD card.
 * Thread launched on ActivityCapture, decode function.
 * Author : Claire
 * Date : May 2013
 */
package se.kth.android.projectred.QR;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import se.kth.android.projectred.ActivityCapture;
import se.kth.android.projectred.QR.QRDecoderV2;

import android.os.Environment;
import android.util.Log;

public class DecodeAndDisplayQR extends Thread {
	// Variables
	Queue queue;
	QRDecoderV2 decoder;
	FileOutputStream fileOut;
	//String fileName;
	File dir;
	String path;
	byte[] data;
	String lastMsg;
	ArrayList<Integer> frameNumber;
	ArrayList<Integer> errorNumber;
	byte[] bestData;
	int bestError;
	int currentFrame;
	
	// Constructor
	public DecodeAndDisplayQR (String name, Queue q) {
		this.queue = q;
		//data = new byte[13];
		lastMsg = null;
		this.frameNumber = new ArrayList<Integer>();
		this.errorNumber = new ArrayList<Integer>();
		
		//this.fileName = name;
		//this.dir = new File(name);
		//dir.mkdir();
		this.path = name;
	}
	
	public void run () {
		try {

			fileOut = new FileOutputStream(path);
		
			while (!queue.getStopValue()) { // true when stop button is pressed by user
				
				if (!queue.isEmpty()) { 
					// Decode the data removed from the queue
					decoder = new QRDecoderV2(queue.dequeue());
					decoder.readFormat();
					decoder.removeMask();
					decoder.restoreData();
					String outputMsg = decoder.decodeData();
					data = decoder.returnValue();
					int errorNb = decoder.getNumberErrors();

					if(outputMsg != null && (errorNb != -1)) {

						if(frameNumber.isEmpty()) { // First frame we decode
							
							frameNumber.add((int) data [0]);
							errorNumber.add(errorNb);
							
							lastMsg = outputMsg; // record last message
							bestData = data; // first data set as best data
							bestError = errorNb;
							currentFrame=data[0];
						}
						else { 
							Log.d("DEBUG", "DEBUG data " + (int)data[0]);
							//if(frameOK(data[0])){
								frameNumber.add((int)data[0]);
								errorNumber.add(errorNb);					
								
								// if the data has not been read already
								if (frameNumber.get(frameNumber.size() - 1) != frameNumber.get(frameNumber.size() - 2)) { // write the data only if different, otherwise the same QR has been read twice
									// write the best previous frame recorded
									fileOut.write(bestData, 1, bestData.length - 1);
									int frame = frameNumber.get(frameNumber.size() - 1);
									ActivityCapture.addSuccessWarnV2("" + frame);
									Log.d("DEBUG", "DEBUG write data " + bestData.length + "FrameNR:" + frameNumber.get(frameNumber.size() - 1));
	
									// set the data as the best data
									bestData = data;
									bestError = errorNb;
								}
								// if the same data is read several times
								else {
									// keep the data with the least error numbers
									if (errorNumber.get(frameNumber.size() - 1) < bestError) {
										bestData = data;
										bestError = errorNb;
									}
								}
								lastMsg = outputMsg; // record last message
							//}
						}
					}
				}
				
				// if queue empty, wait for new elements
				else {
					queue.waitForElement();
					Log.d("DEBUG", "DEBUG waiting for elements");
				}
			}
			
			fileOut.write(bestData, 1, bestData.length - 1);
			int frame = frameNumber.get(frameNumber.size() - 1);
			ActivityCapture.addSuccessWarnV2("" + frame);
			Log.d("DEBUG", "DEBUG write last data " + bestData.length);

			fileOut.close();
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	boolean frameOK(byte frameNR){
		int nr= (int) frameNR;
		if (nr < 0)
			nr+=256;

		if (( nr==(frameNumber.get(frameNumber.size() - 1) )) || (nr==(frameNumber.get(frameNumber.size() - 1)+1))){
			currentFrame=nr;
			return true;
		}else if(nr==0&&frameNumber.get(frameNumber.size() - 1)==255 ){ //TODO:
			currentFrame=nr;
			return true;
		}else
			Log.d("DEBUG", "DEBUG not ok!");
			return false;
	}
}
