package se.kth.android.projectred.QR.NSColors;

import java.util.ArrayList;

import se.kth.android.projectred.QR.ReedSolomon;

import android.util.Log;

public class DecoderColorful {
	int size;
	ReedSolomon rs = new ReedSolomon();
	ArrayList<Byte> data_output = new ArrayList<Byte>();
	int errorNb = 0;
	
	// Convert integer to byte.
	byte int2byte(int input){
		byte sign = 1;
		byte output = 0;
		
		if(input > 128){
			sign = -1;
			input = input - 128; 
		}
		else if(input == 128){
			output = -128;
			input = input - 128;
		}
		else{
			sign = 1;
		}
		
		for(int i = 6; i >= 0; i--){
			if(input >= (byte)Math.pow(2, i)){
				output += (byte)Math.pow(2, i);
				input = input - (int)Math.pow(2, i);
			}
		}
		
		output = (byte)(output*sign);
		
		return output;
	}
	// End function
	
	boolean[] getcolors(byte color){
		boolean[] data = new boolean[3];
		if(color == -120 || color == 0){
			data[0] = false;
			data[1] = false;
			data[2] = false;
		}
		else if(color == -90){
			data[0] = true;
			data[1] = false;
			data[2] = false;
		}
		else if(color == -60){
			data[0] = false;
			data[1] = true;
			data[2] = false;
		}
		else if(color == -30){
			data[0] = true;
			data[1] = true;
			data[2] = false;
		}
		else if(color == 30){
			data[0] = false;
			data[1] = false;
			data[2] = true;
		}
		else if(color == 60){
			data[0] = true;
			data[1] = false;
			data[2] = true;
		}
		else if(color == 90){
			data[0] = false;
			data[1] = true;
			data[2] = true;
		}
		else if(color == 120){
			data[0] = true;
			data[1] = true;
			data[2] = true;
		}
		return data;
	}
	
	public DecoderColorful(byte[][] symbol_received, int FINDERSIZE){
		
		size = symbol_received.length;
		
		GetParColorful parameters = new GetParColorful(size, FINDERSIZE);
		GenFlagColorful flag = new GenFlagColorful(size, FINDERSIZE);
		
		boolean[] data_received_boolean = new boolean[8*parameters.num_codetotal];
		
		int row=size-1;
		int column=size-1;
		int col_ptr = size - column;
		int indx=0;
		int k;
		boolean[] buffer_bits = new boolean [3];
		
		// Read the bits from the received symbol.
		// Output: the interleaved boolean sequence.
		for(k=0;k<(size*(size));k++){
			// UP
			if((col_ptr%4 == 1)||(col_ptr%4 == 2)){
				if (flag.isAvailable(row, column)){
					// Transfer the byte value to three boolean bits.
					buffer_bits = getcolors(symbol_received[row][column]);
					for(int i=0; i<3; i++){
						data_received_boolean[indx+i] = buffer_bits[i]; 
					}
					indx = indx + 3;
				}
				// UPRIGHT
				if (col_ptr%4 == 1){
					column--;
					col_ptr = size - column;
				}
				// UPLEFT
				else if(col_ptr%4 == 2){
					column++;
					col_ptr = size - column;
					row--;
					// Out of upper-bound detection
					if(row < 0){
						row = 0;
						column = column - 2;
						col_ptr = size - column;
					}
				}
			}
			// DOWN
			else if ((col_ptr%4 == 3)||(col_ptr%4 == 0)){
				if (flag.isAvailable(row, column)){
					// Transfer the byte value to three boolean bits.
					buffer_bits = getcolors(symbol_received[row][column]);
					for(int i=0; i<3; i++){
						data_received_boolean[indx+i] = buffer_bits[i]; 
					}
					indx = indx + 3;
				}
				// DOWNRIGHT
				if(col_ptr%4 == 3){
					column--;
					col_ptr = size - column;
				}
				// DOWNLEFT
				else if(col_ptr%4 == 0){
					column++;
					col_ptr = size - column;
					row++;
					// Out of lower-bound detection.
					if (row==size){
						row = size-1;
						column = column-2;
						col_ptr = size - column;
					}
				}
			}
		}
		// End
		
		// Convert the boolean sequence into integer sequence.
		int[] data_received_int = new int[parameters.num_codetotal];
		for (int i = 0 ; i < parameters.num_codetotal ; i++) {
			boolean [] temp = new boolean [8];
			
			for(int j = 8*i ; j < 8*(i+1) ; j++) {
				temp[j-8*i] = data_received_boolean[j];
			}
			
			if (temp[0] == false){
				for(int pos = 1; pos<8; pos++){
					if(temp[pos]==true){
						data_received_int[i] += Math.pow(2, 7-pos); 
					}
				}
			}
			else if(temp[0] == true){
				for(int pos = 1; pos<8; pos++){
					if(temp[pos]==true){
						data_received_int[i] += Math.pow(2, 7-pos); 
					}
				}
				data_received_int[i] = 128 - data_received_int[i];
				data_received_int[i] = -data_received_int[i];
			}
			
			
			/*
			int pos = 0;
			for(int j = 8*i ; j < 8*(i+1) ; j++) {
				boolean temp = data_received_boolean[j];
				if (temp == true) { 
					// True is 1.
					data_received_int[i] += Math.pow(2, 7-pos); 
				}
				pos++;
			}
			*/
		}
		
		// Release the interleaving.
		int num_blocks = (int) Math.floor(parameters.num_codeD/20);
		int num_codeD_remain = parameters.num_codeD%20;
		
		// For blocks from 1 to N-1, the length of block is 20; 
		// For the block N, the length is 20+remain.
		int[][] blocks = new int[num_blocks][40+2*num_codeD_remain];
		int pointer = 0;
		
		for(column=0; column<40+2*num_codeD_remain; column++){
			if(column<20){
				for(row=0; row<num_blocks; row++){
					blocks[row][column] = data_received_int[pointer];
					pointer = pointer+1;
				}
			}
			if((column>=20) && (column<20+num_codeD_remain)){
				blocks[num_blocks-1][column] = data_received_int[pointer];
				pointer = pointer+1;
			}
			if((column>=20+num_codeD_remain) && (column<40+num_codeD_remain)){
				for(row=0; row<num_blocks; row++){
					blocks[row][column] = data_received_int[pointer];
					pointer = pointer+1;
				}
			}
			if((column>=40+num_codeD_remain) && (column<40+2*num_codeD_remain)){
				blocks[num_blocks-1][column] = data_received_int[pointer];
				pointer = pointer+1;
			}	
		}
		// End releasing the interleaving.
		
		// Apply the RS decoding for each block.
		int[] datacodewords_rec = new int[parameters.num_codeD];
		for(row = 0; row < num_blocks; row++){
			if(row < num_blocks-1){
				int[] temp_in = new int [40];
				
				for(column = 0; column < 20; column++){
					temp_in[column] = blocks[row][column];
				}
				
				for(column = 20+num_codeD_remain; column < 40+num_codeD_remain; column++){
					temp_in[column-num_codeD_remain] = blocks[row][column];
				}
				
				// RS decoding.
				int [] syndrome = rs.rsCalcSyndrome(temp_in, 20);
				int [] position = rs.rsFindErrors(syndrome, temp_in.length);				
				int [] codewordsData;
				
				if (position != null) { // There are errors to correct
					if (position.length == 0) {
						this.errorNb = 0;
						codewordsData = rs.rsCorrectErrata(temp_in, syndrome, position);	
					}
					else {
						this.errorNb = position.length;
						codewordsData = rs.rsCorrectErrata(temp_in, syndrome, position);
					}
				}
				
				else  { // No errors to correct or cannot find positions of errors
					this.errorNb = -1;
					codewordsData = new int[temp_in.length];
					for(int i = 0 ; i < temp_in.length ; i++) {
						codewordsData[i] = temp_in[i];
					}
				}
				// End RS decoding.
				
				// Cut the data codewords part. 
				int[] temp_out = new int [20];
				for(int i = 0; i < 20; i++){
					temp_out[i] = codewordsData[i];
					datacodewords_rec[20*row+i] = temp_out[i];
				}
		
			}
			
			else if(row == num_blocks-1){
				int[] temp_in = new int [40+num_codeD_remain*2];
				
				temp_in = blocks[row];
				
				// RS decoding.
				int [] syndrome = rs.rsCalcSyndrome(temp_in, 20+num_codeD_remain);
				int [] position = rs.rsFindErrors(syndrome, temp_in.length);				
				int [] codewordsData;
				
				if (position != null) { // There are errors to correct
					if (position.length == 0) {
						this.errorNb = 0;
						codewordsData = rs.rsCorrectErrata(temp_in, syndrome, position);	
					}
					else {
						this.errorNb = position.length;
						codewordsData = rs.rsCorrectErrata(temp_in, syndrome, position);
					}
				}
				
				else  { // No errors to correct or cannot find positions of errors
					this.errorNb = -1;
					codewordsData = new int[temp_in.length];
					for(int i = 0 ; i < temp_in.length ; i++) {
						codewordsData[i] = temp_in[i];
					}
				}
				// End RS decoding.
				
				// Cut the data codewords part. 
				int[] temp_out = new int [20+num_codeD_remain];
				for(int i = 0; i < 20+num_codeD_remain; i++){
					temp_out[i] = codewordsData[i];
					datacodewords_rec[20*row+i] = temp_out[i];
				}
				
			}
		}
		// End the RS decoding for each block.
		
		byte[] datacodewords_byte = new byte[parameters.num_codeD];
		for(int i = 0; i<parameters.num_codeD; i++){
			//datacodewords_byte[i] = int2byte(datacodewords_rec[i]);
			datacodewords_byte[i] = (byte)(datacodewords_rec[i]);
		}
		
		int length = datacodewords_byte[0] + 128*datacodewords_byte[1];
		
		if (datacodewords_byte.length > length) {
			for(int i = 0; i<length; i++){
				data_output.add(datacodewords_byte[i+2]);
			}
		}
		else {
			data_output = null;
		}
		
	}
	
	public int getNumberErrors () {
		return this.errorNb;
	}
	
	public String getMsgString(){
		String msg = null;;
		if (data_output != null) {
			if (data_output.size () != 0) {
				StringBuilder msgStr = new StringBuilder();
				for(int i = 0 ; i < data_output.size() ; i++){
					int temp = (int) data_output.get(i);
					if (temp < 0) {
						temp += 256;
					}
					msgStr.append ((char) temp);
				}
				msg = msgStr.toString();
			}
			else {
				msg = null; 
			}
		}
		return msg;
	}
	
	public byte [] GetMessage(){
		byte [] temp;
		if (data_output != null) {
			temp = new byte [data_output.size()];
			for(int i = 0 ; i < data_output.size() ; i++) {
				temp[i] = data_output.get(i);
			}
		} else {
			temp = null;
		}
		return temp;
	}	
}
