package se.kth.android.projectred.QR.NSColors;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingDeque;

import org.opencv.core.Mat;

public class QueueColorful {
	
	private ArrayList<byte[][]> queue;
	boolean stop;
	
	public QueueColorful () {
		this.queue = new ArrayList<byte[][]>();
		this.stop = false;
	}
	
	public synchronized void elementAdded() {
		notify();
	}
	
	public synchronized void waitForElement() {
		try {
			wait();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	public ArrayList<byte[][]> getQueue () {
		return this.queue;
	}
	
	public void enqueue(byte[][] b) {
		this.queue.add(b);
	}
	
	public byte[][] dequeue() {
		return this.queue.remove(0);
	}
	
	public boolean isEmpty() {
		return this.queue.isEmpty();
	}
	
	public void stop () {
		this.stop = true;
	}
	
	public boolean getStopValue () {
		return this.stop;
	}

}
