package se.kth.android.projectred.QR.nonStandard;

public class RectInitSymbol {
	int size; //must be an EVEN number
	int sizeH;
	int sizeV;
	int row, column;
	boolean [][] matrix;
	boolean [][] finder;
	// static final int  FINDERSIZE=3;
	
	RectInitSymbol (int sizeH, int sizeV, int FINDERSIZE){
		
		matrix = new boolean [sizeV][sizeH];
		
		// Define the finder pattern.
		finder = new boolean [FINDERSIZE*7][FINDERSIZE*7];
		for(row = 1*FINDERSIZE; row < 6*FINDERSIZE; row++){
			for(column = 1*FINDERSIZE; column < 6*FINDERSIZE; column++){
				finder [row][column] = true;
			}
		}
		for(row = 2*FINDERSIZE; row < 5*FINDERSIZE; row++){
			for(column = 2*FINDERSIZE; column < 5*FINDERSIZE; column++){
				finder [row][column] = false;
			}
		}
		
		// Place the finder pattern. 
		for(row = 0; row < 7*FINDERSIZE; row++){
			for(column = 0; column < 7*FINDERSIZE; column++){
				matrix [row][column] = finder [row][column];
				matrix [row + sizeV - 7*FINDERSIZE][column] = finder [row][column];
				matrix [row][column + sizeH - 7*FINDERSIZE] = finder [row][column];
				matrix [row + sizeV - 7*FINDERSIZE][column + sizeH - 7*FINDERSIZE] = finder [row][column];
 			}
		}
		
		// Place the separator around the finder patterns.
		for(row = 0; row < (7*FINDERSIZE+1); row++){
			matrix [row][7*FINDERSIZE] = true;
			matrix [row][sizeH - (7*FINDERSIZE+1)] = true;
		}
		for(row = sizeV - (7*FINDERSIZE+1); row < sizeV; row++){
			matrix [row][(7*FINDERSIZE)] = true;
			matrix [row][sizeH - (7*FINDERSIZE+1)] = true;
		}
		for(column = 0; column < (7*FINDERSIZE+1); column++){
			matrix [(7*FINDERSIZE)][column] = true;
			matrix [sizeV - (7*FINDERSIZE+1)][column] = true;
		}
		for(column = sizeH - (7*FINDERSIZE+1); column < sizeH; column++){
			matrix [(7*FINDERSIZE)][column] = true;
			matrix [sizeV - (7*FINDERSIZE+1)][column] = true;
		}
	}
	
	boolean [][] GetMatrix(){
		return matrix;
	}
	
}
