package se.kth.android.projectred;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.util.Log;



public class PSettings extends Activity implements OnSharedPreferenceChangeListener {
	/*This Class is used to read the Settings
	 * It needs the Application Context.
	 * So the usage from an Activity is:
	 * 
	 * PSettings set = new PSettings(this.getApplicationContext());
	 *	boolean test = set.MultiFrame;
	 * 
	 * @Thomas
	 */
	
	private static Context context;
	
	static final String KEY_DEBUG = "Debug";
	public boolean debug;
	
	static final String KEY_MULTIFRAME = "MultiFrame";
	public boolean multiFrame;
	
	static final String KEY_MSG = "strMessage";
	public String message;
	
	static final String KEY_VERSION = "Version";
	public int version; // 0 for version 2 ; 1 for non-standard black & white ; 2 for non-standard colors
	
	static final String KEY_RESOLUTION = "Resolution";
	public int resolution;
	
	static final String KEY_MODULESX = "ModulesX";
	public static int modulesX;
	
	static final String KEY_MODULESY = "ModulesY";
	public static int modulesY;
	
	static final String KEY_FINDERSIZE = "FINDERSIZE";
	public int finderSize;
	
	public static final String KEY_READFILE = "readFile";
	public String readFile;
	
	public static final String KEY_WRITEFILE = "writeFile";
	public String writeFile;
	
	

public PSettings(Context context){
	SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(context);
	getPrefs(sharedPref);
	if (debug){
		Log.d("Settings", "Displaying stored Settings: ");
		Log.d("Settings", KEY_DEBUG +" : "+ debug);
		Log.d("Settings", KEY_MULTIFRAME +" : "+ multiFrame);
		Log.d("Settings", KEY_MSG +" : "+ message);
		Log.d("Settings", KEY_VERSION +" : "+ version);
		Log.d("Settings", KEY_RESOLUTION +" : "+ resolution);
		Log.d("Settings", KEY_MODULESX +" : "+ modulesX);
		Log.d("Settings", KEY_MODULESX +" : "+ modulesY);
		Log.d("Settings", KEY_FINDERSIZE +" : "+ finderSize);
		Log.d("Settings", KEY_READFILE +" : "+ readFile);
		Log.d("Settings", KEY_WRITEFILE +" : "+ writeFile);
		}
	}
	
	
	void getPrefs(SharedPreferences sharedPref){
		
		debug = sharedPref.getBoolean(KEY_DEBUG, true);
		multiFrame = sharedPref.getBoolean(KEY_MULTIFRAME,false);
		message  = sharedPref.getString(KEY_MSG, "Hello World!");
		version = Integer.parseInt(sharedPref.getString(KEY_VERSION, "0"));
		resolution = Integer.parseInt(sharedPref.getString(KEY_RESOLUTION, "0"));
		modulesX =  Integer.parseInt(sharedPref.getString(KEY_MODULESX, "100"));
		modulesY =  Integer.parseInt(sharedPref.getString(KEY_MODULESY, "100"));
		finderSize = Integer.parseInt(sharedPref.getString(KEY_FINDERSIZE, "1"));
		readFile = sharedPref.getString(KEY_READFILE, "testMessage.txt");
		writeFile = sharedPref.getString(KEY_WRITEFILE, "TextOut.txt");
	}
	
	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
	
		getPrefs(sharedPreferences);
		
	}
}
