/**
 * Thread that removes boolean matrices from a queue. This queue is synchronized and shared by the ReadQR and DecodeAndDisplayQR threads.
 * The matrices are decoded and depending on the number of errors, the best matrix among several matrices having the same number is kept.
 * The decoded data is written on a text file on the SD card.
 * Thread launched on ActivityCapture, decode function.
 * Author : Claire
 * Date : May 2013
 */
package se.kth.android.projectred.QR.NSColors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import se.kth.android.projectred.ActivityCapture;

import android.os.Environment;
import android.util.Log;

public class DecodeAndDisplayColorful extends Thread {

	// Variables
	QueueColorful queueColorful;
	DecoderColorful decoderColorful;
	FileOutputStream fileOut;
	//String fileName;
	//File dir;
	String path;
	byte[] data;
	String lastMsg;
	ArrayList<Integer> frameNumber;
	ArrayList<Integer> errorNumber;
	byte[] bestData;
	int bestError;
	int FINDERSIZE;
	int CHUNK_SIZE = 831; // maximum value for one color QR
	int currentFrame;
	byte sameFrame;

	// Constructor
	public DecodeAndDisplayColorful (String name, QueueColorful q, int findersize) {

		this.FINDERSIZE = findersize;
		this.queueColorful = q;
		//data = new byte[CHUNK_SIZE];
		lastMsg = null;
		this.frameNumber = new ArrayList<Integer>();
		this.errorNumber = new ArrayList<Integer>();

		//this.fileName = name;
		//this.dir = new File(Environment.getExternalStorageDirectory().getPath()+"/recordings/");
		//dir.mkdir();
		this.path = name;
	}

	public void run () {
		try {

			fileOut = new FileOutputStream(path);

			while (!queueColorful.getStopValue()) {

				if (!queueColorful.isEmpty()) { 

					// Decode the data removed from the queue
					decoderColorful = new DecoderColorful (queueColorful.dequeue(), FINDERSIZE);

					String outputMsg = decoderColorful.getMsgString();
					data = decoderColorful.GetMessage();

					int errorNb = decoderColorful.getNumberErrors();

					if((outputMsg != null) && (errorNb != -1)) {

						if(frameNumber.isEmpty()) { // First frame we decode

							frameNumber.add((int) data [0]);
							errorNumber.add(errorNb);

							lastMsg = outputMsg; // record last message
							bestData = data; // first data set as best data
							bestError = errorNb;
							currentFrame=frameNumber.get(frameNumber.size()-1);
						}
						else { 
							//check if frame number is ok: same or 
							if(frameOK(data[0])){
								frameNumber.add(currentFrame);

								errorNumber.add(errorNb);					

								// if the data has not been read already
								if (frameNumber.get(frameNumber.size() - 1) != frameNumber.get(frameNumber.size() - 2)) { // write the data only if different, otherwise the same QR has been read twice
									// write the best previous frame recorded
									fileOut.write(bestData, 1, bestData.length - 1);
									int frame = frameNumber.get(frameNumber.size() - 1);
									ActivityCapture.addSuccessWarnColorful("" + frame);
									Log.d("DEBUG", "DEBUG write data " + bestData.length + " of " + sameFrame + " FrameNR: " + frameNumber.get(frameNumber.size() - 1));

									// set the data as the best data
									bestData = data;
									bestError = errorNb;
									sameFrame=1;
								}
								// if the same data is read several times
								else {
									sameFrame++;
									// keep the data with the least error numbers
									if (errorNumber.get(frameNumber.size() - 1) < bestError) {
										bestData = data;
										bestError = errorNb;
									}
								}
								lastMsg = outputMsg; // record last message										
							}else
								Log.e("DEBUG","DEBUG Frame corrupt FrameNR!!!" + (int) data [0]);
						}
					}
				}

				// if queue empty, wait for new elements
				else {
					queueColorful.waitForElement();
				}
			}

			// write the last piece of data
			fileOut.write(bestData, 1, bestData.length - 1); 
			int frame = frameNumber.get(frameNumber.size() - 1);
			ActivityCapture.addSuccessWarnColorful("" + frame);
			Log.d("DEBUG", "DEBUG write last data " + bestData.length);

			fileOut.close();

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	boolean frameOK(byte frameNR){
		int nr= (int) frameNR;
		if (nr < 0)
			nr+=256;

		if (( nr==(frameNumber.get(frameNumber.size() - 1) )) || (nr==(frameNumber.get(frameNumber.size() - 1)+1))){
			currentFrame=nr;
			return true;
		}else if(nr==0&&frameNumber.get(frameNumber.size() - 1)==255 ){ //TODO:
			currentFrame=nr;
			return true;
		}else
			return false;
	}
}
