/**
 * Thread that reads a text file, chunks it into n-byte long pieces (n depends on the version, here v2),
 * encodes the data, numbers the frames, and adds the generated boolean matrix in a queue. 
 * The queue is processed by the UI thread for displaying the QR codes on the screen.
 * Thread instantiated in ActivitySend, encode function.
 * Author : Claire
 * Date : May 2013
 */
package se.kth.android.projectred.QR;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import se.kth.android.projectred.ActivitySend;

public class ReadFromFile extends Thread {
	
	// VARIABLES 
	String fileName;
	File dir;
	String path;
	int nbBytes;
	FileInputStream file;
	byte data[];
	int mask;
	QRencoderV2 encoder;
	int DATA_CHUNK_SIZE = 12; // 12 bytes of data per QR for version 2 is the max value

	//CONSTRUCTOR
	public ReadFromFile (String name, int mask) {
		
		data = new byte[DATA_CHUNK_SIZE + 1]; // 1 byte for the frame number, 12 bytes of data
		
		// Get the file
		this.path = name;
		//this.dir = new File(Environment.getExternalStorageDirectory().getPath()+"/sendings/");
		//this.path = new String(dir + "/" + fileName);
		
		this.mask = mask;
	}
	
	public void run () {
		try {
			
			file = new FileInputStream(path);
	        
			nbBytes = file.available();
			
			int counter = (int) nbBytes / DATA_CHUNK_SIZE; 
			int remainder = nbBytes % DATA_CHUNK_SIZE;
			int frameNumber = 0; // For data retransmission, include frame numbering -> first byte in the data array
			
			for(int i = 0 ; i < counter ; i++) {
				
				data[0] = (byte) frameNumber; // set first byte to frame number
				file.read(data, 1, DATA_CHUNK_SIZE); // offset to 1, 12 bytes of real data	
				
				// encode the data
				encoder = new QRencoderV2(data);
				encoder.dataPlacement();
				encoder.applyMask(this.mask);
				encoder.addFormatInfo();
				
				// display progress information on the screen
				ActivitySend.addProgressMessageV2("Progress: " + frameNumber + " / " + counter);
				
				// add the data to the buffer
				ActivitySend.addSymbol(encoder.getQR_mat());
				
				frameNumber++;
			}
			
			// End of the file, remains less than 12 bytes of data		
			byte [] dataRemaining = new byte [remainder+1]; // first byte is the frame number
			
			dataRemaining [0] = (byte) counter; // the last frame
			file.read(dataRemaining, 1, remainder);
			
			// encode the data
			encoder = new QRencoderV2(dataRemaining);
			encoder.dataPlacement();
			encoder.applyMask(this.mask);
			encoder.addFormatInfo();
			
			ActivitySend.addProgressMessageV2("Progress: " + counter + " / " + counter);
			ActivitySend.addProgressMessageV2("Transmission completed. " + counter + " frames transmitted.");

			ActivitySend.addSymbol(encoder.getQR_mat());
										
			file.close();
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
