package se.kth.android.projectred.QR.nonStandard;

import java.io.File;
import java.io.FileOutputStream;

import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Size;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;



import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.Color;
import android.os.Environment;
import android.util.Log;

public class QRreaderNS {
	/* From the Camera image to the symbols as a boolean matrix
	 * 
	 * example flow:
	 * QRreader decoder = new QRreader(fMat); //Create new Object with input image (grayscale)
	 * decoder.preProcessing(); //Applies Blur and Median filtering
	 * decoder.makebBW(); //Thresholding: creates boolean matrix
	 * boolean success = decoder.findQR(); //Find the fPatterns -> affine transform -> aPattern
	 *	if (success)						//returns if it found a qr code
	 *		decoder.findbits();				//create the bits matrix which contains the symbol values
	 */

	// CONSTANT
	
	int STEP = 5;
	int MODULES;
	int FINDERSIZE;

	// VARIABLES

	public boolean[][] bits;
	Mat frame;
	Mat bw = new Mat();
	boolean[][] bBW;
	boolean[][] bClean;
	Mat clean = new Mat();
	public FinderPatternFinder finder;
	//AlignmentPatternFinder align;
	Mat afTrans = new Mat();

	public QRreaderNS (Mat nFrame, int findersize, int sizeVersion) {
		//Get Settings
	//	PSettings pSet = new PSettings();
	//	MODULES = pSet.getModules();
	//	FINDERSIZE = pSet.getFinderSize();
		//destroy settings
	//	pSet=null;
	//TODO: BLUB	
		frame = nFrame;
		this.FINDERSIZE = findersize;
		this.MODULES = sizeVersion;
		bits = new boolean[MODULES][MODULES];
	}
	
	public boolean[][] getMatrix () {
		return this.bits;
	}

	public void updateFrame(Mat nFrame) {
		frame = nFrame;
	}

	public void saveBM(String filename) {
		/*
		 * Creates and saves a Bitmap from bBM
		 * 
		 * @Thomas
		 */

		// Create Bitmap from bBW
		int h = bBW.length;
		int w = bBW[0].length;
		Bitmap bm = Bitmap.createBitmap(w, h, Config.ARGB_8888);
		for (int y = 0; y < h; y++) {
			for (int x = 0; x < w; x++) {
				if (bBW[y][x] == false) {
					bm.setPixel(x, y, Color.BLACK);
				} else
					bm.setPixel(x, y, Color.WHITE);
			}
		}
		// Create Filename
		if (filename == null)
			filename = "bBW.jpg";

		File dir = new File(Environment.getExternalStorageDirectory().getPath()
				+ "/AAAdebug/");
		String path = new String(dir + "/" + filename);

		// Write File
		try {
			FileOutputStream out = new FileOutputStream(path);
			bm.compress(Bitmap.CompressFormat.PNG, 90, out);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void preProcessing() {
		/*
		 * Median Blur and thresholding
		 * 
		 * @Thomas
		 */
		
		 int FKERNEL = 1; //Uneven number 1,3,5,...
		 int ADPTHRES = 399; //Uneven number 7,9,11,...
		//determine FKERNAL and ADPTHRES
		int col=frame.cols();
		int row=frame.rows();
		int size;
		if (col<row)
			size=col;
		else
			size=row;
		ADPTHRES=size/3;
		if (ADPTHRES%2==0)
			ADPTHRES++;
		
		Imgproc.medianBlur(frame, bw, FKERNEL);
		// Imgproc.threshold(frame1, frame2, 20, 255, Imgproc.THRESH_BINARY);
		Imgproc.adaptiveThreshold(bw, bw, 255, Imgproc.ADAPTIVE_THRESH_MEAN_C,
				Imgproc.THRESH_BINARY, ADPTHRES, 0);
		;
	}

	void perspective(FinderPattern[] fPattern) {
		/*
		 * Calculate the Perspective Transformation Matrix
		 * 
		 * @Thomas
		 */
		Point source[] = new Point[4];
		Point goal[] = new Point[4];
 
	
		int center = 2*FINDERSIZE+(int)Math.floor((3*FINDERSIZE)/2);
		//Set the goal
		goal[0] = new Point((center)*STEP, (center)*STEP);
		goal[1] = new Point((MODULES-center-1)*STEP, (center)*STEP);
		goal[2] = new Point((center)*STEP, (MODULES-center-1)*STEP);
		goal[3] = new Point((MODULES-center-1)*STEP,(MODULES-center-1)*STEP);

		// Set the destination
		for (int i = 0; i < 4; i++) {
			source[i] = new Point(fPattern[i].row, fPattern[i].col);
		}

		MatOfPoint2f src = new MatOfPoint2f();
		src.fromArray(source);
		MatOfPoint2f gl = new MatOfPoint2f();
		gl.fromArray(goal);
		//Calculate transformation Matrix
		afTrans = Imgproc.getPerspectiveTransform(src, gl);
	}

	Mat applyPerspective(Mat m) {
		Mat dst = new Mat();
		Size size = new Size(MODULES*STEP, MODULES*STEP);
		//Apply Transformation
		Imgproc.warpPerspective(m, dst, afTrans, size);
		return dst;
	}

	public void saveMat(String filename) {
		/*
		 * Saves the stored Mat to the sdCard as a PNG file
		 * 
		 * @Thomas
		 */

		if (filename == null)
			filename = "mat.PNG";

		File dir = new File(Environment.getExternalStorageDirectory().getPath()
				+ "/AAAdebug/");
		String path = new String(dir + "/" + filename);
		if (frame != null)
			Highgui.imwrite(path, bw);

	}

	public boolean findQR() {
		/*
		 * Find's the patterns
		 * 
		 * @Thomas
		 */
		long timingP = System.currentTimeMillis();	
		finder = new FinderPatternFinder(bBW);
		boolean success = finder.find();
		long elapsed = System.currentTimeMillis() - timingP;
		Log.d("1234","Finder TIME " + (int)elapsed);
		if (success) {
			perspective(finder.fPattern);
			bw = applyPerspective(bw);
			//Save Affine transformed Image
			//TODO: DISABLE SAVING: Only for debugging
			saveMat("perspective.PNG");
			Log.d("1234", "saved perspective.png");
			//Make it boolean
			makebBW(); //Affine transformed image is in bBW will be used from now on
			//align = new AlignmentPatternFinder(bBW);

		//	success = align.find();

			Log.d("1234", "Pattern Found");

		} else
			return false;

		return success;
	}

	public void findbits() {
		/*Extracts the symbols from the QR code and returns them as a boolean Matrix
		 * black <> false		white<>true
		 * @Thomas
		 */
		

		for (int x = 0; x < MODULES; x++) {
			for (int y = 0; y < MODULES; y++) {

				bits[x][y] = getBit(x, y, 3*FINDERSIZE, 3*FINDERSIZE, 3*STEP*FINDERSIZE, 3*STEP*FINDERSIZE);
			}
		}

		
	}
	
	boolean getBit(int x, int y, int Nx, int Ny, int row, int col) {
		/* Extracts a symbol from the processed image
		 * Input: 	x,y - The symbol you want
		 * 			Nx,Ny - Symbol possition of your reference point (e.g. 3,3 for the top left fPattern)
		 * 			row,col - Position of the reference point in the affine transformed image (e.g. 60,60=
		 * Return:	boolean Symbol value (black<>false	white<>true
		 * @Thomas
		 */

		int r = (x - Nx) * STEP + row;
		int c = (y - Ny) * STEP + col;

		return bBW[r][c];
	}

	public void makebBW() {
		/*
		 * Creates a boolean matrix of the BW image
		 * 
		 * @Thomas slow
		 */

		bBW = new boolean[bw.height()][bw.width()];
		Mat m = bw.row(0);
		byte buff[] = new byte[(int) (m.total() * m.channels())];
		for (int y = 0; y < bw.height(); y++) {
			m = bw.row(y);
			m.get(0, 0, buff);
			for (int x = 0; x < bw.width(); x++) {
				bBW[y][x] = !(buff[x] == 0);

			}
		}

	}

	boolean getBW(int x, int y) {
		double[] data = bw.get(x, y);
		return data[0] == 255;
	}

	byte getGrey(int x, int y) {
		/*
		 * Returns the grey value of a pixel
		 * 
		 * @Thomas
		 */
		double[] data = frame.get(x, y);
		return (byte) data[0];

	}

}