/**
 * NON STANDARD VERSION OF ReadFromFile.java
 * Thread that reads a text file, chunks it into n-byte long pieces (n depends on the version, here v2),
 * encodes the data, numbers the frames, and adds the generated boolean matrix in a queue. 
 * The queue is processed by the UI thread for displaying the QR codes on the screen.
 * Thread instantiated in ActivitySend, encode function.
 * Author : Claire
 * Date : May 2013
 */
package se.kth.android.projectred.QR.nonStandard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import se.kth.android.projectred.ActivitySend;
import se.kth.android.projectred.ImgSizePar;
import android.os.Environment;

public class ReadFromFileNS extends Thread {
	
	// Variables
	//String fileName;
	//File dir;
	String path;
	int nbBytes;
	FileInputStream file;
	byte data[];
	RectEncoder encoder;
	
	// Constants
	int DATA_CHUNK_SIZE;
	int FINDERSIZE;
	int SIZEH;
	int SIZEV;

	public ReadFromFileNS(String name, int findersize, int sizeH, int sizeV) {
		this.FINDERSIZE = findersize;
		this.SIZEH = sizeH;
		this.SIZEV = sizeV;
		if (SIZEH == SIZEV) { // square
			DATA_CHUNK_SIZE = ImgSizePar.DATA_CHUNK_SIZE_NS;
		}
		else { // rectangular
			DATA_CHUNK_SIZE = ImgSizePar.DATA_CHUNK_SIZE_RECT; //640
		}
		
		data = new byte[DATA_CHUNK_SIZE + 2]; // 1 byte for the frame number at the beginning, 12 bytes of data, 1 byte at the end 

		//his.fileName = name;
		//this.dir = new File(Environment.getExternalStorageDirectory().getPath()+"/sendings/");
		this.path = name;	
	}
	
	public void run () {
		try {
			
			file = new FileInputStream(path);

			nbBytes = file.available();

			int counter = (int) nbBytes / DATA_CHUNK_SIZE; 
			int remainder = nbBytes % DATA_CHUNK_SIZE;
			int frameNumber = 0; // For data retransmission, include frame numbering -> first byte in the data array
			
			for(int i = 0 ; i < counter ; i++) {
				
				data[0] = (byte) frameNumber;
				file.read(data, 1, DATA_CHUNK_SIZE); // offset to 1, 270 or 700 bytes of real data	
				data[data.length - 1] = (byte) frameNumber; // for better reliability

				encoder = new RectEncoder (data, SIZEH, SIZEV, FINDERSIZE);
				
				ActivitySend.addProgressMessageNS("Progress: " + frameNumber + " / " + counter);
				
				ActivitySend.addSymbolNS(encoder.GetSymbol());
				frameNumber++;
			}
			
			// End of the file, remains less than 12 bytes of data		
			byte [] dataRemaining = new byte [remainder+2]; // first byte is the frame number
			dataRemaining [0] = (byte) counter; // the last frame
			file.read(dataRemaining, 1, remainder);
			dataRemaining[dataRemaining.length - 1] = (byte) counter; // for better reliability

			encoder = new RectEncoder (dataRemaining, SIZEH, SIZEV, FINDERSIZE);
			
			ActivitySend.addProgressMessageNS("Progress: " + counter + " / " + counter);
			ActivitySend.addProgressMessageNS("Transmission completed. " + counter + " frames transmitted.");

			ActivitySend.addSymbolNS(encoder.GetSymbol());
			
			file.close();
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
