package com.kth.android.projectEQ2440;

import java.io.File;
import java.util.ArrayList;
import projectEQ2440.QRcode.Encode.Encoding;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.SurfaceView;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.ToggleButton;

/**
 * Main activity from the encoding application from Group GREEN, 2013
 * Kungliska Tekniska Hgskolan
 * 
 * 
 * @author Group GREEN
 * @version 0.7
 */

public class QRCode extends Activity implements SensorEventListener {
	ToggleButton start_stop_button;
	public boolean flash = false;
	public boolean start_displaying=false;	
	boolean gui_active = false;
	public boolean stop=false;
	

	Thread guiTriggerThread;
	Thread encodingThread;
	Context context;
	Encoding enc;

	public ArrayList<Bitmap> qrQueue = null;
	public QRDisplay_Test QRDisplay_test;
	Saver saver;
	String filename = null;

	
	/////////////TODO LIGHT SENSOR
	private SensorManager sensorManager;
	private Sensor lightSensor;
	SensorEventListener listener;
	private float lightQuantity;
	//////////////END
	@Override
	public void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);
		context = this;
		setContentView(R.layout.main);

		saver = new Saver();
		PreferenceManager.setDefaultValues(this, R.xml.preferences, false);
		QRCodeConfig.sp = PreferenceManager.getDefaultSharedPreferences(this);

		
		QRDisplay_test = new QRDisplay_Test(this);
		QRDisplay_test.main = this;
		
		gui_active = false;

		qrQueue = new ArrayList<Bitmap>();

		start_stop_button = (ToggleButton) findViewById(R.id.toggleButton1);

		start_stop_button.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				if (start_stop_button.isChecked()) {
					start();
				} else {
					stop();
				}
			}
		});

		// ///////////TODO LIGHT SENSOR -> move to own class to get a object! de register it on delete
		sensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
		lightSensor = sensorManager.getDefaultSensor(Sensor.TYPE_LIGHT);
		listener = new SensorEventListener() {
			float threshold=2000;
			float multi=1;  // TODO GET a good value 
			Long tsLong=System.currentTimeMillis();
			@Override
			public void onSensorChanged(SensorEvent event) {
				// might be event.values[0];
				if (event.sensor.getType() == Sensor.TYPE_LIGHT) {
					lightQuantity = event.values[0];
					Log.i("Light Sensor",""+multi*threshold+"<"+Float.toString(lightQuantity));
					
					/*
					if (3*threshold > lightQuantity&& threshold/3 < lightQuantity) {
						threshold = (threshold + lightQuantity) / 2;
					}*/
					if (System.currentTimeMillis() - tsLong > 200) { // TODO GET a good value 
						if (multi * threshold < lightQuantity) { 
							if (flash) {
								Log.i("Light Sensor", "Flash! " + multi * threshold
										+ "<" + Float.toString(lightQuantity));
								tsLong = System.currentTimeMillis();
								QRDisplay_test.updateGUI();
							}
						}
					}
				}
			}
			@Override
			public void onAccuracyChanged(Sensor arg0, int arg1) {
				// TODO Auto-generated method stub

			}
		};
		sensorManager.registerListener(listener, lightSensor,
				SensorManager.SENSOR_DELAY_GAME);//SENSOR_DELAY_GAME);SENSOR_DELAY_UI

		// ///////////END

	}

	@Override
	protected void onResume() {
		super.onResume();
		sensorManager.registerListener(listener, lightSensor,
				SensorManager.SENSOR_DELAY_FASTEST);
		if (start_stop_button.isChecked()) {
			start();
		}
	}

	@Override
	protected void onPause() {
		super.onPause();
		sensorManager.unregisterListener(this);
		stop();
	}
	/**
	 * Method taking care about init. of the components needed in flash detection modus.
	 */
	private void init_flash() {
		gui_active=false;
		QRDisplay_test.init();
		QRDisplay_test.updateGUI();
	}
	
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.menu, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		Intent i = null;
		switch (item.getItemId()) {
		case R.id.preferences:
			stop();
			i = new Intent(QRCode.this, QRCodeConfig.class);
			startActivity(i);
			break;
		case R.id.filename:
			stop();
			saver.save();
			break;
		case R.id.exit:
			android.os.Process.killProcess(android.os.Process.myPid());
			break;
		}
		return true;
	}
	/**
	 * Starts the encoding thread and takes care about the right settings of the boolean variables. 
	 */
	private void start_encoding() {
		// Encoding
		stop = false;
		encodingThread = new Thread(new Runnable() {
			public void run() {
				enc = null;
				enc = new Encoding(
						QRCodeConfig.getBoolean("forceVersion") == true ? 
								QRCodeConfig.getInt("IntforceVersion", 25) < 0 || 
								QRCodeConfig.getInt("IntforceVersion", 25) > 40? 
										25 : QRCodeConfig.getInt("IntforceVersion", 25)
								: 0, 
						QRCodeConfig.getInt("ecl", 3), 
						QRCodeConfig.getBoolean("color") == true ? 3 : -1,
						QRCodeConfig.getBoolean("color") == true ? 
								QRCodeConfig.getInt("numberOfColors", 1) : -1, 
						filename,
						QRDisplay_test.main); 
				enc.start();
			}
		});
		encodingThread.start();
	}

	/**
	 * Starts the gui thread and takes care about the right settings of the boolean variables.
	 * Will wait till the old thread is terminated. 
	 */
	private void start_gui() {
		if (guiTriggerThread != null) {
			while (guiTriggerThread.getState() != Thread.State.TERMINATED
					|| guiTriggerThread.getState() == Thread.State.NEW) {
				gui_active = false;
				guiTriggerThread.interrupt();
			}
		}
		guiTriggerThread = new Thread(new Runnable() {
			public synchronized void run() {
				QRDisplay_test.init();
				gui_active = true;
				while (gui_active) {
					QRDisplay_test.updateGUI();
					try {
						wait(QRDisplay_test.display_rate);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		});
		guiTriggerThread.start();

	}

	/**
	 * Starts the flash init or gui thread.  
	 */
	private void start_threads() {
		start_stop_button.setChecked(true);
		start_encoding();
		// ///////Flash Callback////////////////
		if (flash) {
			QRDisplay_test.init();
		} else {
			start_gui();
		}
	}
	/**
	 * Creates a ok-popup with the title equal to header and text as message. 
	 */
	public void show_popup(String header,String text){
		AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(
				context);

		// set title
		alertDialogBuilder.setTitle(header);

		// set dialog message
		alertDialogBuilder.setMessage(text)
				.setNeutralButton("OK",
						new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dialog,
									int id) {
								// if this button is clicked, just
								// close
								// the dialog box and do nothing
								dialog.cancel();
							}
						});

		// create alert dialog
		AlertDialog alertDialog = alertDialogBuilder.create();

		// show it
		alertDialog.show();
		stop();
	}

	/**
	 * This is called when the user presses start on the gui, reinitialize
	 * any data if needed.
	 */
	public void start() {
		if (filename == null) {
			show_popup("Error","Please press menu and select a file!");
		} else {
			flash = QRCodeConfig.getBoolean("flash") == true ? true : false;
			// //// Flash
			if (flash) {
				init_flash();
				start_threads();
			} else { // NOT FLASH
				start_threads();
			}
		}
	}
	/**
	 * This is called when the user presses stop, do any post
	 * processing here. Stopping the Threads, remove QR-code from screen. 
	 */
	public void stop() {
		start_displaying = false;
		// /////////////Flash Callback////////////////
		if (flash) {
			QRDisplay_test.plot_black();
		} else {
			gui_active = false; // stop GUI Thread
			QRDisplay_test.plot_black();
		}
		if (encodingThread != null) {
			if (enc != null) {
				enc.active = false;
			}
		}
		if (qrQueue != null) {
			qrQueue.clear(); // clearing queue
		}
		start_stop_button.setChecked(false);
	}
	/**
	 * Class for handling displaying QR code and information about the QR code.
	 * 
	 */
	public class QRDisplay_Test {
		// Set the approximate interval in milliseconds for your need for calls
		// to your process function
		protected final long display_rate = 1000;
		QRCode main = null;
		Activity mAct = null;
		TextView textViewNbr = null;
		TextView textView = null;
		SurfaceView visual = null;
		
		protected int qr_index;
		/**
		 * Constructor.
		 * 
		 */
		public QRDisplay_Test(Activity activity) {
			this.mAct = activity;
			textViewNbr = (TextView) findViewById(R.id.TextView01);
			visual = (SurfaceView) findViewById(R.id.oscview);
			qr_index = 0;
		}

		/**
		 * Updates the text information about the QR-codes and the actual index of encoding. 
		 * 
		 */
		public void updateText() {
			mAct.runOnUiThread(new Runnable() {
				@Override
				public void run() {
					setQRCodeNumber(qr_index);
				}
			});
		}

		/**
		 * Updates the text information.
		 * 
		 * @param str String which is displayed
		 */
		public void updateText(final String str) {
			mAct.runOnUiThread(new Runnable() {
				@Override
				public void run() {
					textViewNbr.setText(str);				
				}
			});
		}

		/**
		 * Resets the index for qr_queue.
		 */
		public void init() {
			qr_index = 0;
		}

		/**
		 * Sets text information about displayed qr codes.
		 * 
		 * @param i Index for QR-code
		 */
		public void setQRCodeNumber(int i) {
			textViewNbr.setText("Current QR-code: " + (i != 0 ? i : "-encoding-")
					+ "\nTotal number of encoded QR-codes: "
					+ main.qrQueue.size());
			setStaticText();
		}
		/**
		 * Sets text information about used encoding parameters.
		 * 
		 * @param i Index for QR-code
		 */
		private void setStaticText() {
			textViewNbr.append("\n Used version: " + main.enc.version
					+ "\nUsed Error Correction Level: " + main.enc.ecl);
		}

		Bitmap mapBM = null;
		/**
		 * Updates the qr information. Calls  {@link #drawQR()} for plotting a new qr-code. 
		 *
		 */
		public void updateGUI() {
			Log.d("updateGUI","");
			mAct.runOnUiThread(new Runnable() {
				@Override
				public void run() {
					if (stop == false)
						drawQR();
					else{
						textViewNbr.setText("Error!, File is too big!");
						stop();
					}									
				}
			});
		}
		/**
		 * Handling the index of the actual qr-code and calls the {@link #plot_bitmap} function
		 *
		 */
		public void drawQR() {
			Log.d("drawQR","");
			if(start_displaying){	
					if (qr_index >= main.qrQueue.size()) {
						qr_index = 0;
					}
					if(!qrQueue.isEmpty()){
						Log.d("drawQR","Plot");
						plot_bitmap((Bitmap) main.qrQueue.get(qr_index),
							visual.getMeasuredWidth(),
							visual.getMeasuredWidth());
						qr_index++;
						//textViewNbr.setText("PLOT..");
					}
					setQRCodeNumber(qr_index);
					
			} else {
				//textViewNbr.setText("Encoding..");
			}
		}
		/**
		 * Plots a black square instead of a qr-code and deletes qr-information.
		 *
		 */
		public void plot_black() {
			Canvas bmcanvas = visual.getHolder().lockCanvas();
			bmcanvas.drawColor(Color.BLACK);
			visual.getHolder().unlockCanvasAndPost(bmcanvas);

			if(stop)textViewNbr.setText("Error!, File is too big!\nDeselect Force Version or choose a smaller File.\n");
			else textViewNbr.setText("");
			
			textViewNbr.append("Waiting for user input..");
		}
		/**
		 * Gets a bitmap and size for it. Plots it with a canvas on the view and resizes it to width and height. 
		 *
		 *@param h Bitmap to plot
		 *@param width width of the rectangle
		 *@param height height of the rectangle
		 */
		public void plot_bitmap(Bitmap h, int width, int height) {
			Canvas bmcanvas = visual.getHolder().lockCanvas();
			bmcanvas.drawColor(Color.BLACK);
			bmcanvas.drawBitmap(h, null, new Rect(0, 0, width, height), null);
			visual.getHolder().unlockCanvasAndPost(bmcanvas);
		}

	}

	public class Saver {

		private RelativeLayout visual;

		private EditText text;

		private Button ok;
		private Button cancel;

		public Saver() {

			visual = (RelativeLayout) findViewById(R.id.saver);
			text = (EditText) findViewById(R.id.addressBar);
			ok = (Button) findViewById(R.id.buttonSaverOK);
			cancel = (Button) findViewById(R.id.buttonSaverCancel);

			ok.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					InputMethodManager mgr = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
					mgr.hideSoftInputFromWindow(text.getWindowToken(), 0);
					filename = text.getText().toString();
					File file = new File(Environment.getExternalStorageDirectory(), filename );
					if (!file.exists()) {
						filename=null;
					}
					// encodingThread.start();

					visual.setVisibility(View.GONE);
					// text.setText("");
				}

			});

			cancel.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					visual.setVisibility(View.GONE);

					text.setText("");

				}
			});

		}

		public void save() {
			runOnUiThread(new Runnable() {
				public void run() {
					text.setText("");
					visual.setVisibility(View.VISIBLE);
				}
			});
		}

	}

	@Override
	public void onAccuracyChanged(Sensor sensor, int accuracy) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSensorChanged(SensorEvent event) {
		// TODO Auto-generated method stub
		
	}

}
