 package projectEQ2440.QRcode.Encode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.kth.android.projectEQ2440.QRCode;

import android.graphics.Bitmap;
import android.os.Environment;
import android.util.Log;

import projectEQ2440.QRcode.image.DataArea;
import projectEQ2440.QRcode.info.*;
import projectEQ2440.QRcode.mask.Mask;
import projectEQ2440.utils.Type;

 /**
 *  <b>public class Encoding</b><br/>
 * Manages generation of QR codes. Function Modules of QR code are fixed for multiple codes and they are generated inside constructor.
 * Data and Error Correction codewords are generated by the method "create_qr_code"
 */
public class Encoding {
	public Version myVersion	= null;
	public Mask 	myMask  	= null;
	public DataArea myDataArea 	= null;
	QRCode main=null;
	public int version;
	public int ecl; 		// ecl is Error Correction Level 1 for L, 2 for M, 3
							// for Q, 4 for H
	public int number_mask;
	public int blocksize_m_1;
	public int N;
	public boolean[][] H;
	public boolean active=false;
	
	static final boolean[][] A = new boolean[][] {
			{ true, true,  true,  true,  true },
			{ true, false, false, false, true },
			{ true, false, true,  false, true },
			{ true, false, false, false, true },
			{ true, true,  true,  true,  true } };

	static final boolean[][] p = new boolean[][] {
		{ true, true,  true,  true,  true,  true,  true },
		{ true, false, false, false, false, false, true },
		{ true, false, true,  true,  true,  false, true },
		{ true, false, true,  true,  true,  false, true },
		{ true, false, true,  true,  true,  false, true },
		{ true, false, false, false, false, false, true },
		{ true, true,  true,  true,  true,  true,  true } };
	
	List <Encoding> encoderList=null;
	int nbr_pic;
	int msg_len;
	
	
	/**
	 * <b>Encoding</b><br/>
	 * Constructor for Encoding class. Function modules are created by calling the constructor
	 * @param version1 : Version of the QR code to be generated
	 * @param ecl1 : Error Correction Level to be used. It must be from 1-4. 1 for L, 2 for M, 3 for Q, 4 for H
	 * @param mask1 : Mask to be used. It must be from 1-8
	 * @param colors : Number of colors 
	 * @param fn : Filename that we want to read
	 * @param main2 : Object of main class QRCode
	 */
	public Encoding(int version1, int ecl1,int mask1, int colors, String fn, QRCode main2) {
		ecl=ecl1;main=main2;
		filename = fn;
		load_file();
		if (colors < 1)
			colors = 1; // Black and White
		version = 0;
		int subt;
		if (version1 == 0) {
			version = getVersion(colors);
		}
		else{
			version=version1;
		}
		
		if (version>9) 
			subt=5;
		else 
			subt=4;
		
		encoderList = new ArrayList<Encoding>();
		for(int i=0;i<colors;i++){
			encoderList.add(new Encoding(version,ecl1,mask1)); // Add first encoder.
		}
		
		msg_len = encoderList.get(0).myVersion.messageLength()
				- encoderList.get(0).myVersion.nbrCorrectionByte(encoderList.get(0).ecl) 
				- subt;
		
		nbr_pic = (int) ((in_data.length() / msg_len) / (colors)) + 1;
		if(nbr_pic>(255/encoderList.size())){
			active = false; main.stop=true;
			if(main.flash)main.QRDisplay_test.updateGUI();
		}else{
			active = true;
		}
	}
	
	
	/**
	 * <b>getVersion</b><br/>
	 * Selects the version for QR code if it is not specified
	 * @param colors : number of colors
	 * @return Calculated version
	 */
	private int getVersion(int colors) {
		int ver;
		int temp=(int)in_data.length()/colors;
		ver=Version.getSuitableVersion(temp,ecl);
		return ver;
	}


	String filename;
	FileInputStream ios;
	File in_data;

	/**
	 * <b>load_file</b><br/>
	 * Loads the whole file, selected by filename, into one byte array.  
	 *
	 */
	private void load_file() {

		// Reading the file..
		in_data = new File(Environment.getExternalStorageDirectory()
				.getPath() + "/" + filename); // for ex. path=
  
			try {
				Log.i("load_file", "Before : "+in_data);
				ios = new FileInputStream(in_data);
				Log.i("load_file", "After : "+in_data);
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			//return ios;
	}
	
	/**
	 * <b>Encoding</b><br/>
	 * Constructor for Encoding class. Function modules are created by calling the constructor
	 * @param version1 Version of the QR code to be generated
	 * @param ecl1     Error Correction Level to be used. It must be from 1-4. 1 for L, 2 for M, 3 for Q, 4 for H
	 * @param mask1    Mask to be used. It must be from 1-8
	 */
	public Encoding(int version1, int ecl1, int mask1) {
		number_mask=mask1;
		if(mask1!=-1){
		myMask = Mask.generate(mask1);// Get a m
		}

		myVersion = new Version(version1);
		//System.out.print("My Version: " + myVersion.version() + "\n");
		
	
		myDataArea = new DataArea(myVersion);
		ecl = ecl1;
        version=version1;
		
		H = new boolean[myVersion.lengthQR()][myVersion.lengthQR()];

		// Fill out the structure!
		// ////////////////////////////////////////////////////////////////////////
		// Allignment
		H = insertAllignmentInfo(H, myVersion.patternsLocalization());
		//System.out.print("Allignment Pattern \n");
		//print_boolean(H);

		// ////////////////////////////////////////////////////////////////////////
		// Timing
		H = timing_information(H);
		//System.out.print("Timing Information \n");
		//print_boolean(H);

		// ////////////////////////////////////////////////////////////////////////
		// Finding
		H = finding_pattern(H);
		//System.out.print("Finding Pattern \n");
		//print_boolean(H);

		// ////////////////////////////////////////////////////////////////////////
		// Version
		H = version_info(H);
		//System.out.print("Version Info \n"); print_boolean(H);	

		// ////////////////////////////////////////////////////////////////////////
		// Format
		if(myMask!=null){
			H = format_info(H);
		}
		//System.out.print("Format Info \n"); print_boolean(H);	
	}


	/**
	 * <b>create_qr_code</b><br/>
	 * Manages creation and insertion of data and error correction codewords in the QR code
	 * @param msg Message to be encoded into a QR code
	 * @param Ver Object of Version class
	 * @return Final boolean matrix for our QR code
	 */

	public void create_qr_code(byte[] msg,boolean[][] temp, int cur_pic, int total) {
		
		Data_ErrorCorrection_Module data_error=new Data_ErrorCorrection_Module(msg, this, myVersion);
		byte[] output=data_error.Message(cur_pic, total);
		byte[] output_f=data_error.reed_solomon(output);
		output_f=data_error.Interleaving(output_f);
		Log.i("output_f"," "+(output_f[0]&0xFF)+" "+(output_f[1]&0xFF)+" "+(output_f[2]&0xFF)+" "+(output_f[3]&0xFF)+" "+(output_f[4]&0xFF));
		
		boolean[] codeword = Type.byte2bit(output_f, 0);
		if(myMask==null){
			H=data_error.Data_into_Matrix_evaluate_Mask(codeword);
			H=format_info(H);
		}else{
		H=data_error.Data_into_Matrix_Mask(codeword);
		}
		// Adding white border
		//boolean[][] temp=new boolean[H.length+4][H[0].length+4];
		for(int i=0;i<H.length;i++)
			System.arraycopy(H[i], 0, temp[i+2], 2, H.length);
		
		
		//return temp;
	}


	boolean[][][] Hs=null;
	
	/**
	 * <b>start</b><br/>
	 * This function is called when user presses start in the menu, it reinitializes any data if needed.
	 *  It read the specified file and call 'create_qr_code' to generate the codes
	 */
	public void start() {
		byte[] temp = null;
		byte[] message = null;
		temp = new byte[msg_len];
		// for(int i=0;i<msg_len;i++)
		// temp[i]=(byte)i;
		Hs=new boolean[encoderList.size()][encoderList.get(0).H.length+4][encoderList.get(0).H[0].length+4];
		for (int i = 0; i < nbr_pic && i < (int)255/encoderList.size()&& active==true; i++) { //TODO display error!
			for(int j=0; j< encoderList.size()&& active==true; j++){
				try {
					int len = ios.read(temp, 0, msg_len);
					if (len == -1) {
						message = new byte[0];
					} else { // -1 end of stream
						message = new byte[len];
						System.arraycopy(temp, 0, message, 0, len);
					}/* else {
						message = new byte[msg_len];
						System.arraycopy(temp, 0, message, 0, msg_len);
					}*/

				} catch (IOException e) {
					e.printStackTrace();
				}
				encoderList.get(j).create_qr_code(message, Hs[j], j+i*encoderList.size(), nbr_pic*encoderList.size());
				frame_info(Hs[j],j+i*encoderList.size());
			} // END For loop, Number of colors
			if(active){
				combine_Hs();
			}
		}
		if(active) // If we have less than 3 QR Codes
			check_displaying_status();
		try {
			ios.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		active=false;
	}
	
	/**
	 * <b>fill_color_masks</b><br/>
	 * It specifies colors to be used and fill them in color_mask
	 * @param number : Number of colors
	 * @return color masks
	 */
	public int[] fill_color_masks(int number){
		int[] color_masks=null;
		color_masks=new int[number];
		if(number==1){
			color_masks[0]=(int)0xFFFFFFFF;
		}
		else if (number == 3) {
			color_masks[0]=(int)0xFFFF0000;
			color_masks[1]=(int)0xFF00FF00;
			color_masks[2]=(int)0xFF0000FF;
		} else if (number == 6) {
			color_masks[0] = 0xFFAA0000;
			color_masks[1] = 0xFF550000;
			color_masks[2] = 0xFF00AA00;
			color_masks[3] = 0xFF005500;
			color_masks[4] = 0xFF0000AA;
			color_masks[5] = 0xFF000055;
		}
		return color_masks;
	}
	private void check_displaying_status(){	
			if(main.flash==false)
				main.start_displaying=true;
			else{
				if(!main.start_displaying){
					main.start_displaying=true;
					main.QRDisplay_test.updateGUI();
				}
			}
		
	}
	
	/**
	 * <b>combine_Hs</b><br/>
	 * This method is responsible for combining different colored QR codes into one code
	 */
	public void combine_Hs(){
		int[] data=null;
		int[] color_masks=fill_color_masks(Hs.length);
		for(int i=0;i<Hs.length;i++){
			data=convert_2d_bitmap(data,Hs[i], color_masks[i]);
		}		
		Bitmap result = Bitmap.createBitmap(data, Hs[0].length, Hs[0][0].length, Bitmap.Config.ARGB_8888);
		
		main.qrQueue.add(result); // We wait till space in the queue is available. Wait happens if qrQueue is to small! TODO
		Log.i("CombineQRs", Integer.toString(main.qrQueue.size()));
		main.QRDisplay_test.updateText();
		if(main.qrQueue.size()>3){
			check_displaying_status();	
		}
		data=null;
	}
	
	   /**
	    * <b>convert_2d_bitmap</b><br/>
	    * This method is responsible for applying color mask to the generated boolean matrix
	    * @param data : If colored codes, converted array of integers is given as input so that it can be summed up
	    * @param h : Generated boolean matirx
	    * @param mask : Mask to be applied
	    * @return Array of integers representing a code
	    */

	public int[] convert_2d_bitmap(int[] data,boolean[][] h, int mask){
		if(data==null){
			data = new int[h.length*h[0].length]; 	
			Arrays.fill(data, 0x00000000);
		}
		
		for (int y = 0; y < h.length; y++) {
			for (int x = 0; x < h[0].length; x++) {
				if (!h[y][x]) {
				// false
					data[x + h.length*y] |= mask; //0x00FF0000
				}
			}
		}
		return data;
	}
	
	
	/**
	 * <b>format_info</b><br/>
	 * Insert Format Information in the boolean matrix of QR code
	 * @param H Boolean Matrix
	 * @return  Boolean Matrix containing format information
	 */
	public boolean[][] format_info(boolean[][] H){  
		  
		   Format f1=new Format(ecl,number_mask);
		   boolean[] format=f1.codeWordSpread();
		   int j=8,k=7;
		   N=myVersion.lengthQR();
		   for (int i=0;i<6;i++)
			   H[8][i]=format[i];
		   
		   //System.arraycopy(format, 0, H[8], 0, 6);
		    H[8][7]=format[6];
		   
		   for (int i=0;i<6;i++)
			   H[i][8]=format[14-i];
		   
		   for (int i=7;i<9;i++)
			   H[i][8]=format[15-i];
		   
		   for (int i=7;i<15;i++){
			   H[8][N-j]=format[i];
			   j=j-1;
		   }
		   
		   for (int i=0;i<7;i++){
			   H[N-k][8]=format[6-i];
			   k=k-1;
		   }
		   H[N-8][8]=true;
		   
		   
		   return H;
	}
	

	/**
	 * <b>version_info</b><br/>
	 * Insert Version Information in the boolean matrix of QR code
	 * @param H Boolean Matrix
	 * @return  Boolean Matrix containing version information
	 */
	
	public boolean[][] version_info(boolean[][] H){
		if(myVersion.version()>6){
			N=myVersion.lengthQR();
		boolean[] version_in=null;
		version_in=myVersion.codeWord();
		
		//Flip the version information
		for(int i = 0; i < version_in.length/2; i++)
		{
		    boolean temp = version_in[i];
		    version_in[i] = version_in[version_in.length - i - 1];
		    version_in[version_in.length - i - 1] = temp;
		}
		
		//Convert into 3*6 Matrix
		boolean[][] vt=new boolean[3][6];
		for (int j=0;j<3;j++){
			int aa=1;
			for(int i=0;i<6;i++){
				vt[j][i]=version_in[j+aa-1];
				aa=aa+3;
			}
		}
		//Put version information in H matrix
		for(int i=0;i<3;i++){
			System.arraycopy(vt[2-i], 0, H[N-9-i], 0, 6);
		}
		for(int i=0;i<6;i++){
			for(int j=3;j>0;j--)
				H[i][N-8-j]=vt[3-j][i];
				
		}
		
		}
		
		return H;
		
		
	}
	
	
	

		
	public static void print_boolean(boolean[][] print_me) {
		System.out.format("  ");
		for (int i = 0; i < print_me.length; i++) {
			System.out.format("%3d", i);
		}
		System.out.println();
		for (int i = 0; i < print_me.length; i++) {
			// String.replaceAll(Arrays.toString(print_me[i]),"1");
			System.out.format("%2d ", i);
			// System.out.println(Arrays.toString(print_me[i]).replaceAll("true",Character.toString((char)219)).replaceAll("false",
			// " "));
			System.out.println(Arrays.toString(print_me[i])
					.replaceAll("true", "#").replaceAll("false", " "));
		}
		System.out.println("\n");
	}

	
	/**
	 * <b>insertAllignmentInfo</b><br/>
	 * Insert Allignment Patterns in the boolean matrix of QR code
	 * @param H Boolean Matrix
	 * @param version_pattern Indicate allignment patterns for a specific version
	 * @return  Boolean Matrix containing allignment patterns
	 */
	public boolean[][] insertAllignmentInfo(boolean[][] H, int[] version_pattern) {
		int n = version_pattern.length;
		int x, y;
		for (int i = 0; i < n; i++) {
			x = version_pattern[i];
			for (int j = 0; j < n; j++) {
				y = version_pattern[j];
				//
				if (!((i == 0 && j == 0) || (i == 0 && j == n - 1) || (i == n - 1 && j == 0))) {
					// H(x-2:x+2,y-2:y+2) = A;
					for (int bb = 0; bb < A.length; bb++) {
						System.arraycopy(A[bb], 0, H[y - 2 + bb], x - 2, 5);
					}
				}
			}
		}
		return H;
	}

	/**
	 * <b>finding_pattern</b><br/>
	 * Insert Finding Patterns in the Boolean Matrix of QR code
	 * @param H Boolean Matrix
	 * @return Boolean Matrix containing finding patterns
	 */
	public boolean[][] finding_pattern(boolean[][] H) {
		for (int i = 0; i < 7; i++) {
			// TODO Check whether reference copying or Deep copying is better
			// System.arraycopy = Reference/Pointer
			// Arrays.copyOf() = Deep copy
			System.arraycopy(p[i], 0, H[i], 0, 7);
			System.arraycopy(p[i], 0, H[i], H.length - 7, 7);
			System.arraycopy(p[i], 0, H[H.length - 1 - i], 0, 7);
		}
		return H;
	}

	/**
	 * <b>timing_information</b><br/>
	 * Insert Timing Information in the Boolean Matrix of QR code
	 * @param H Boolean Matrix
	 * @return Boolean Matrix containing timing information
	 */

	public boolean[][] timing_information(boolean[][] H) {
		for (int i = 8; i < H.length; i += 2) {
			H[6][i] = true;
			H[i][6] = true;
		}
		return H;
	}

	
	/**
	 * <b>frame_info</b><br/>
	 * Responsible for inserting frame number information in the Boolean matrix
	 * @param H : Generated boolean matrix
	 * @param curr_frame : Current frame number
	 */

	public void frame_info(boolean[][] H,int curr_frame){
		
		boolean[] frame_in=null;
		Frame f=new Frame(curr_frame);
		frame_in=f.codeWord();
		
		//Flip the version information
		for(int i = 0; i < frame_in.length/2; i++)
		{
		    boolean temp = frame_in[i];
		    frame_in[i] = frame_in[frame_in.length - i - 1];
		    frame_in[frame_in.length - i - 1] = temp;
		}
		
		
		//Put version information in H matrix
		int aa=0;
		for(int i=0+2;i<6+2;i++){
			for(int j=9+2;j<11+2;j++){
			H[i][j]=frame_in[aa];
			H[j][i]=frame_in[23-aa];
			aa++;
			}
		}

		
		
	}

	
	
}
