package projectEQ2440.QRcode.info;

/**
 * <b>abstract class VersionConst</b><br/>
 * Abstract class for initialization of the used constants of Version
 */
abstract class VersionConst {
	

	// Polynom used for encoding Version : X^12 + X^11 + X^10 + X^9 + X^8 + x^5 + x^2 + 1
	final static private boolean[] polynom = { true, true, true, true, true, 
		                                       false, false, true, false,
		                                       false, true, false, true }; 
	
	// Table with any Version between 7 and 40
	final static protected boolean[][] tableVersion = new boolean[34][18];
	
	static {
		boolean[][] tmp = new boolean[34][6];
		
		int i, j, k;

		for (j=3; j<6; j++) {
			tableVersion[0][j] = true;
			tmp[0][j] = true; 
		}
		
		for (i=1; i<34; i++) {
			tableVersion[i][5] = !tableVersion[i-1][5];
			for (j=4; tableVersion[i-1][j+1]; j--) tableVersion[i][j] = !tableVersion[i-1][j];
			for (; j>=0; j--) tableVersion[i][j] = tableVersion[i-1][j];
			for (j=0; j<6; j++) tmp[i][j] = tableVersion[i][j];
		}
		
		for (i=0; i<34; i++) 
			for (k=0; k<6; k++) {
				if (tableVersion[i][k]) 
					for (j=k; j<k+13; j++) 
						tableVersion[i][j] ^= polynom[j-k];
				tableVersion[i][k] = tmp[i][k];
			}
		
	}
	
	final static protected int[][] patternsLocalization = 
		{ { },
		  { 6  , 18  },
		  { 6  , 22  },
		  { 6  , 26  },
		  { 6  , 30  },
		  { 6  , 34  },
		  { 6  , 22 , 38  },
		  { 6  , 24 , 42  },
		  { 6  , 26 , 46  },
		  { 6  , 28 , 50  },
		  { 6  , 30 , 54  },
		  { 6  , 32 , 58  },
		  { 6  , 34 , 62  },
		  { 6  , 26 , 46 , 66  },
		  { 6  , 26 , 48 , 70  },
		  { 6  , 26 , 50 , 74  },
		  { 6  , 30 , 54 , 78  },
		  { 6  , 30 , 56 , 82  },
		  { 6  , 30 , 58 , 86  },
		  { 6  , 34 , 62 , 90  },
		  { 6  , 28 , 50 , 72 , 94  },
		  { 6  , 26 , 50 , 74 , 98  },
		  { 6  , 30 , 54 , 78 , 102 },
		  { 6  , 28 , 54 , 80 , 106 },
		  { 6  , 32 , 58 , 84 , 110 },
		  { 6  , 30 , 58 , 86 , 114 },
		  { 6  , 34 , 62 , 90 , 118 },
		  { 6  , 26 , 50 , 74 , 98 , 122 },
		  { 6  , 30 , 54 , 78 , 102, 126 },
		  { 6  , 26 , 52 , 78 , 104, 130 },
		  { 6  , 30 , 56 , 82 , 108, 134 },
		  { 6  , 34 , 60 , 86 , 112, 138 },
		  { 6  , 30 , 58 , 86 , 114, 142 },
		  { 6  , 34 , 62 , 90 , 118, 146 },
		  { 6  , 30 , 54 , 78 , 102, 126, 150 },
		  { 6  , 24 , 50 , 76 , 102, 128, 154 },
		  { 6  , 28 , 54 , 80 , 106, 132, 158 },
		  { 6  , 32 , 58 , 84 , 110, 136, 162 },
		  { 6  , 26 , 54 , 82 , 110, 138, 166 },
		  { 6  , 30 , 58 , 86 , 114, 142, 170 }};
	
	final static protected int[] messageLength = 
			{ 26   , 44   , 70   , 100  , 134  , 
			  172  , 196  , 242  , 292  , 346  , 
			  404  , 466  , 532  , 581  , 655  , 
			  733  , 815  , 901  , 991  , 1085 , 
			  1156 , 1258 , 1364 , 1474 , 1588 , 
			  1706 , 1828 , 1921 , 2051 , 2185 , 
			  2323 , 2465 , 2611 , 2761 , 2876 , 
			  3034 , 3196 , 3362 , 3532 , 3706 }; 
	
	final static protected int[][] nbrInterleavingBlock =   
		{   {  1   , 1   , 1   , 1   },
		    {  1   , 1   , 1   , 1   },
			{  1   , 1   , 2   , 2   },
			{  1   , 2   , 2   , 4   },
			{  1   , 2   , 4   , 4   },
			  
			{  2   , 4   , 4   , 4   },
			{  2   , 4   , 6   , 5   },
			{  2   , 4   , 6   , 6   },
			{  2   , 5   , 8   , 8   },
			{  4   , 5   , 8   , 8   },
			  
			{  4   , 5   , 8   , 11  },
			{  4   , 8   , 10  , 11  },
			{  4   , 9   , 12  , 16  },
			{  4   , 9   , 16  , 16  },
			{  6   , 10  , 12  , 18  },
			  
			{  6   , 10  , 17  , 16  },
			{  6   , 11  , 16  , 19  },
			{  6   , 13  , 18  , 21  },
			{  7   , 14  , 21  , 25  },
			{  8   , 16  , 20  , 25  },
			  
			{  8   , 17  , 23  , 25  },
			{  9   , 17  , 23  , 34  },
			{  9   , 18  , 25  , 30  },
			{  10  , 20  , 27  , 32  },
			{  12  , 21  , 29  , 35  },
			  
			{  12  , 23  , 34  , 37  },
			{  12  , 25  , 34  , 40  },
			{  13  , 26  , 35  , 42  },
			{  14  , 28  , 38  , 45  },
			{  15  , 29  , 40  , 48  },
			  
			{  16  , 31  , 43  , 51  },
			{  17  , 33  , 45  , 54  },
			{  18  , 35  , 48  , 57  },
			{  19  , 37  , 51  , 60  },
			{  19  , 38  , 53  , 63  },
			  
			{  20  , 40  , 56  , 66  },
			{  21  , 43  , 59  , 70  },
			{  22  , 45  , 62  , 74  },
			{  24  , 47  , 65  , 77  },
			{  25  , 49  , 68  , 81  } };
	
	final static protected int[][] nbrCorrectionByte = 
		{	{  7    , 10   , 13   , 17    },
			{  10   , 16   , 22   , 28    },
			{  15   , 26   , 36   , 44    },
			{  20   , 36   , 52   , 64    },
			{  26   , 48   , 72   , 88    },
			  
			{  36   , 64   , 96   , 112   },
			{  40   , 72   , 108  , 130   },
			{  48   , 88   , 132  , 156   },
			{  60   , 110  , 160  , 192   },
			{  72   , 130  , 192  , 224   },
	
			{  80   , 150  , 224  , 264   },
			{  96   , 176  , 260  , 308   },
			{  104  , 198  , 288  , 352   },
			{  120  , 216  , 320  , 384   },
			{  132  , 240  , 360  , 432   },
			  
			{  144  , 280  , 408  , 480   },
			{  168  , 308  , 448  , 532   },
			{  180  , 338  , 504  , 588   },
			{  196  , 364  , 546  , 650   },
			{  224  , 416  , 600  , 700   },
			  
			{  224  , 442  , 644  , 750   },
			{  252  , 476  , 690  , 816   },
			{  270  , 504  , 750  , 900   },
			{  300  , 560  , 810  , 960   },
			{  312  , 588  , 870  , 1050  },
			  
			{  336  , 644  , 952  , 1110  },
			{  360  , 700  , 1020 , 1200  },
			{  390  , 728  , 1050 , 1260  },
			{  420  , 784  , 1140 , 1350  },
			{  450  , 812  , 1200 , 1440  },
			  
			{  480  , 868  , 1290 , 1530  },
			{  510  , 924  , 1350 , 1620  },
			{  540  , 980  , 1440 , 1710  },
			{  570  , 1036 , 1530 , 1800  },
			{  570  , 1064 , 1590 , 1890  },
			  
			{  600  , 1120 , 1680 , 1980  },
			{  630  , 1204 , 1770 , 2100  },
			{  660  , 1260 , 1860 , 2220  },
			{  720  , 1316 , 1950 , 2310  },
			{  750  , 1372 , 2040 , 2430  } };

}
