package projectEQ2440.QRcode.ReedSolomon.GaloisField;

abstract class GaloisConst {

	final static protected byte[] table_pow;
	final static protected int[] table_log;
	
	static {
		// Polynom used for GF(256) : X^8 + X^4 + X^3 + X^2 + 1
		
		// Table of power using the previous polynom
		table_pow = new byte[256];
		table_pow[0] = (byte) 0x01;
		table_pow[1] = (byte) 0x02;
		table_pow[2] = (byte) 0x04;
		table_pow[3] = (byte) 0x08;
		table_pow[4] = (byte) 0x10;
		table_pow[5] = (byte) 0x20;
		table_pow[6] = (byte) 0x40;
		table_pow[7] = (byte) 0x80;
		table_pow[255] = (byte) 0x01;
		
		int k;
		for (k=8; k<255; k++) {
			table_pow[k] = (byte) (table_pow[k-4] ^ table_pow[k-5] ^ table_pow[k-6] ^ table_pow[k-8]);
		}
		
		// Table of logarithms : inverted table
		table_log = new int[256];
		table_log[0] = -1;
		
		for (k=0; k<255; k++) {
			table_log[(int) (table_pow[k] & 0xFF)] = k;
		}
		
	}
}
